/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.onlab.util.Bandwidth;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BandwidthCapacity;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAdminService;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
final class ResourceNetworkConfigListener
implements NetworkConfigListener {
    private static final Set<Class<?>> CONFIG_CLASSES = ImmutableSet.of(BandwidthCapacity.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ResourceAdminService adminService;
    private final NetworkConfigService cfgService;
    private final MastershipService mastershipService;
    private final ExecutorService executor;

    ResourceNetworkConfigListener(ResourceAdminService adminService, NetworkConfigService cfgService, MastershipService mastershipService, ExecutorService executor) {
        this.adminService = (ResourceAdminService)Preconditions.checkNotNull((Object)adminService);
        this.cfgService = (NetworkConfigService)Preconditions.checkNotNull((Object)cfgService);
        this.mastershipService = (MastershipService)Preconditions.checkNotNull((Object)mastershipService);
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
    }

    public boolean isRelevant(NetworkConfigEvent event) {
        switch ((NetworkConfigEvent.Type)event.type()) {
            case CONFIG_ADDED: 
            case CONFIG_REMOVED: 
            case CONFIG_UPDATED: {
                return CONFIG_CLASSES.contains(event.configClass());
            }
        }
        return false;
    }

    public void event(NetworkConfigEvent event) {
        if (event.configClass() == BandwidthCapacity.class) {
            this.executor.execute(() -> {
                try {
                    this.handleBandwidthCapacity(event);
                }
                catch (Exception e) {
                    this.log.error("Exception handling BandwidthCapacity", (Throwable)e);
                }
            });
        }
    }

    private void handleBandwidthCapacity(NetworkConfigEvent event) {
        Preconditions.checkArgument((event.configClass() == BandwidthCapacity.class ? 1 : 0) != 0);
        ConnectPoint cp = (ConnectPoint)event.subject();
        if (!this.mastershipService.isLocalMaster(cp.deviceId())) {
            return;
        }
        BandwidthCapacity bwCapacity = (BandwidthCapacity)this.cfgService.getConfig((Object)cp, BandwidthCapacity.class);
        switch ((NetworkConfigEvent.Type)event.type()) {
            case CONFIG_ADDED: {
                if (this.adminService.register(new Resource[]{Resources.continuous((DeviceId)cp.deviceId(), (PortNumber)cp.port(), Bandwidth.class).resource(bwCapacity.capacity().bps())})) break;
                this.log.info("Failed to register Bandwidth for {}, attempting update", (Object)cp);
                if (this.updateRegistration(cp, bwCapacity)) break;
                this.log.warn("Failed to update Bandwidth for {}", (Object)cp);
                break;
            }
            case CONFIG_UPDATED: {
                if (this.updateRegistration(cp, bwCapacity)) break;
                this.log.warn("Failed to update Bandwidth for {}", (Object)cp);
                break;
            }
            case CONFIG_REMOVED: {
                if (this.adminService.unregister(new ResourceId[]{Resources.continuous((DeviceId)cp.deviceId(), (PortNumber)cp.port(), Bandwidth.class).id()})) break;
                this.log.warn("Failed to unregister Bandwidth for {}", (Object)cp);
                break;
            }
            case CONFIG_REGISTERED: 
            case CONFIG_UNREGISTERED: {
                break;
            }
        }
    }

    private boolean updateRegistration(ConnectPoint cp, BandwidthCapacity bwCapacity) {
        if (!this.adminService.unregister(new ResourceId[]{Resources.continuous((DeviceId)cp.deviceId(), (PortNumber)cp.port(), Bandwidth.class).id()})) {
            this.log.warn("unregisterResources for {} failed", (Object)cp);
        }
        return this.adminService.register(new Resource[]{Resources.continuous((DeviceId)cp.deviceId(), (PortNumber)cp.port(), Bandwidth.class).resource(bwCapacity.capacity().bps())});
    }
}

