/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.GuavaCollectors;
import org.onlab.util.Tools;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAdminService;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceEvent;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.ResourceListener;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.ResourceStore;
import org.onosproject.net.resource.ResourceStoreDelegate;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
@Beta
public final class ResourceManager
extends AbstractListenerManager<ResourceEvent, ResourceListener>
implements ResourceService,
ResourceAdminService {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceStore store;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ResourceStoreDelegate delegate = new InternalStoreDelegate();

    @Activate
    public void activate() {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(ResourceEvent.class, (EventSink)this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(ResourceEvent.class);
        this.log.info("Stopped");
    }

    public List<ResourceAllocation> allocate(ResourceConsumer consumer, List<? extends Resource> resources) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.RESOURCE_WRITE);
        Preconditions.checkNotNull((Object)consumer);
        Preconditions.checkNotNull(resources);
        boolean success = this.store.allocate(resources, consumer);
        if (!success) {
            return ImmutableList.of();
        }
        return resources.stream().map(x -> new ResourceAllocation(x, consumer)).collect(Collectors.toList());
    }

    public boolean release(List<ResourceAllocation> allocations) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.RESOURCE_WRITE);
        Preconditions.checkNotNull(allocations);
        return this.store.release(allocations);
    }

    public boolean release(ResourceConsumer consumer) {
        Preconditions.checkNotNull((Object)consumer);
        Collection<ResourceAllocation> allocations = this.getResourceAllocations(consumer);
        return this.release((List<ResourceAllocation>)ImmutableList.copyOf(allocations));
    }

    public List<ResourceAllocation> getResourceAllocations(ResourceId id) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.RESOURCE_READ);
        Preconditions.checkNotNull((Object)id);
        return this.store.getResourceAllocations(id);
    }

    public <T> Collection<ResourceAllocation> getResourceAllocations(DiscreteResourceId parent, Class<T> cls) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.RESOURCE_READ);
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull(cls);
        Collection resources = this.store.getAllocatedResources(parent, cls);
        return (Collection)resources.stream().flatMap(resource -> this.store.getResourceAllocations(resource.id()).stream()).collect(GuavaCollectors.toImmutableList());
    }

    public Collection<ResourceAllocation> getResourceAllocations(ResourceConsumer consumer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.RESOURCE_READ);
        Preconditions.checkNotNull((Object)consumer);
        Collection resources = this.store.getResources(consumer);
        return resources.stream().map(x -> new ResourceAllocation(x, consumer)).collect(Collectors.toList());
    }

    public Set<Resource> getAvailableResources(DiscreteResourceId parent) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.RESOURCE_READ);
        Preconditions.checkNotNull((Object)parent);
        Set children = this.store.getChildResources(parent);
        return children.stream().filter(arg_0 -> ((ResourceStore)this.store).isAvailable(arg_0)).collect(Collectors.toSet());
    }

    public <T> Set<Resource> getAvailableResources(DiscreteResourceId parent, Class<T> cls) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.RESOURCE_READ);
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull(cls);
        return this.store.getChildResources(parent, cls).stream().filter(arg_0 -> ((ResourceStore)this.store).isAvailable(arg_0)).collect(Collectors.toSet());
    }

    public <T> Set<T> getAvailableResourceValues(DiscreteResourceId parent, Class<T> cls) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.RESOURCE_READ);
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull(cls);
        return this.store.getChildResources(parent, cls).stream().filter(arg_0 -> ((ResourceStore)this.store).isAvailable(arg_0)).map(x -> x.valueAs(cls)).flatMap(Tools::stream).collect(Collectors.toSet());
    }

    public Set<Resource> getRegisteredResources(DiscreteResourceId parent) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.RESOURCE_READ);
        Preconditions.checkNotNull((Object)parent);
        return this.store.getChildResources(parent);
    }

    public boolean isAvailable(Resource resource) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.RESOURCE_READ);
        Preconditions.checkNotNull((Object)resource);
        return this.store.isAvailable(resource);
    }

    public boolean register(List<? extends Resource> resources) {
        Preconditions.checkNotNull(resources);
        return this.store.register(resources);
    }

    public boolean unregister(List<? extends ResourceId> ids) {
        Preconditions.checkNotNull(ids);
        return this.store.unregister(ids);
    }

    protected void bindStore(ResourceStore resourceStore) {
        this.store = resourceStore;
    }

    protected void unbindStore(ResourceStore resourceStore) {
        if (this.store == resourceStore) {
            this.store = null;
        }
    }

    private class InternalStoreDelegate
    implements ResourceStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(ResourceEvent event) {
            ResourceManager.this.post((Event)event);
        }
    }
}

