/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onlab.util.Bandwidth;
import org.onlab.util.GuavaCollectors;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.TributarySlot;
import org.onosproject.net.behaviour.LambdaQuery;
import org.onosproject.net.behaviour.MplsQuery;
import org.onosproject.net.behaviour.TributarySlotQuery;
import org.onosproject.net.behaviour.VlanQuery;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BandwidthCapacity;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAdminService;
import org.onosproject.net.resource.ResourceQueryService;
import org.onosproject.net.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResourceDeviceListener
implements DeviceListener {
    private static final Logger log = LoggerFactory.getLogger(ResourceDeviceListener.class);
    private final ResourceAdminService adminService;
    private final ResourceQueryService resourceService;
    private final DeviceService deviceService;
    private final MastershipService mastershipService;
    private final DriverService driverService;
    private final NetworkConfigService netcfgService;
    private final ExecutorService executor;

    ResourceDeviceListener(ResourceAdminService adminService, ResourceQueryService resourceService, DeviceService deviceService, MastershipService mastershipService, DriverService driverService, NetworkConfigService netcfgService, ExecutorService executor) {
        this.adminService = (ResourceAdminService)Preconditions.checkNotNull((Object)adminService);
        this.resourceService = (ResourceQueryService)Preconditions.checkNotNull((Object)resourceService);
        this.deviceService = (DeviceService)Preconditions.checkNotNull((Object)deviceService);
        this.mastershipService = (MastershipService)Preconditions.checkNotNull((Object)mastershipService);
        this.driverService = (DriverService)Preconditions.checkNotNull((Object)driverService);
        this.netcfgService = (NetworkConfigService)Preconditions.checkNotNull((Object)netcfgService);
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
    }

    public void event(DeviceEvent event) {
        Device device = (Device)event.subject();
        if (!this.mastershipService.isLocalMaster(device.id())) {
            return;
        }
        switch ((DeviceEvent.Type)event.type()) {
            case DEVICE_ADDED: {
                this.registerDeviceResource(device);
                break;
            }
            case DEVICE_REMOVED: {
                this.unregisterDeviceResource(device);
                break;
            }
            case DEVICE_AVAILABILITY_CHANGED: {
                if (this.deviceService.isAvailable(device.id())) {
                    this.registerDeviceResource(device);
                    break;
                }
                this.unregisterDeviceResource(device);
                break;
            }
            case PORT_ADDED: 
            case PORT_UPDATED: {
                if (event.port().isEnabled()) {
                    this.registerPortResource(device, event.port());
                    break;
                }
                this.unregisterPortResource(device, event.port());
                break;
            }
            case PORT_REMOVED: {
                this.unregisterPortResource(device, event.port());
                break;
            }
        }
    }

    private void registerDeviceResource(Device device) {
        this.executor.execute(() -> {
            boolean success = this.adminService.register(new Resource[]{Resources.discrete((DeviceId)device.id()).resource()});
            if (!success) {
                log.error("Failed to register Device: {}", (Object)device.id());
            }
        });
    }

    private void unregisterDeviceResource(Device device) {
        this.executor.execute(() -> {
            DiscreteResource devResource = Resources.discrete((DeviceId)device.id()).resource();
            List<Resource> allResources = this.getDescendantResources(devResource);
            this.adminService.unregister(Lists.transform(allResources, Resource::id));
        });
    }

    private void registerPortResource(Device device, Port port) {
        DiscreteResource portPath = Resources.discrete((DeviceId)device.id(), (PortNumber)port.number(), (Object[])new Object[0]).resource();
        this.executor.execute(() -> this.lambda$registerPortResource$5((Resource)portPath, device, port));
    }

    private void unregisterPortResource(Device device, Port port) {
        this.executor.execute(() -> {
            DiscreteResource portResource = Resources.discrete((DeviceId)device.id(), (PortNumber)port.number(), (Object[])new Object[0]).resource();
            List<Resource> allResources = this.getDescendantResources(portResource);
            this.adminService.unregister(Lists.transform(allResources, Resource::id));
        });
    }

    private List<Resource> getDescendantResources(DiscreteResource parent) {
        LinkedList<Resource> allResources = new LinkedList<Resource>();
        allResources.add((Resource)parent);
        Set nextResources = this.resourceService.getRegisteredResources(parent.id());
        while (!nextResources.isEmpty()) {
            Set currentResources = nextResources;
            allResources.addAll(0, currentResources);
            nextResources = currentResources.stream().filter(r -> r instanceof DiscreteResource).map(r -> (DiscreteResource)r).flatMap(r -> this.resourceService.getRegisteredResources(r.id()).stream()).collect(Collectors.toSet());
        }
        return allResources;
    }

    private Optional<Bandwidth> queryBandwidth(DeviceId did, PortNumber number) {
        ConnectPoint cp = new ConnectPoint((ElementId)did, number);
        BandwidthCapacity config = (BandwidthCapacity)this.netcfgService.getConfig((Object)cp, BandwidthCapacity.class);
        if (config != null) {
            log.trace("Registering configured bandwidth {} for {}/{}", new Object[]{config.capacity(), did, number});
            return Optional.of(config.capacity());
        }
        Port port = this.deviceService.getPort(did, number);
        if (port != null) {
            return Optional.of(Bandwidth.mbps((long)port.portSpeed()));
        }
        return Optional.empty();
    }

    private Set<OchSignal> queryLambdas(DeviceId did, PortNumber port) {
        try {
            DriverHandler handler = this.driverService.createHandler(did, new String[0]);
            if (handler == null || !handler.hasBehaviour(LambdaQuery.class)) {
                return Collections.emptySet();
            }
            LambdaQuery query = (LambdaQuery)handler.behaviour(LambdaQuery.class);
            if (query != null) {
                return (Set)query.queryLambdas(port).stream().flatMap(ResourceDeviceListener::toResourceGrid).collect(GuavaCollectors.toImmutableSet());
            }
            return Collections.emptySet();
        }
        catch (ItemNotFoundException e) {
            return Collections.emptySet();
        }
    }

    private static Stream<OchSignal> toResourceGrid(OchSignal ochSignal) {
        if (ochSignal.gridType() != GridType.FLEX) {
            return OchSignal.toFlexGrid((OchSignal)ochSignal).stream();
        }
        if (ochSignal.gridType() == GridType.FLEX && ochSignal.channelSpacing() == ChannelSpacing.CHL_6P25GHZ && ochSignal.slotGranularity() == 1) {
            return Stream.of(ochSignal);
        }
        log.error("Converting {} to resource tracking grid not supported yet.", (Object)ochSignal);
        return Stream.builder().build();
    }

    private Set<VlanId> queryVlanIds(DeviceId device, PortNumber port) {
        try {
            DriverHandler handler = this.driverService.createHandler(device, new String[0]);
            if (handler == null || !handler.hasBehaviour(VlanQuery.class)) {
                return ImmutableSet.of();
            }
            VlanQuery query = (VlanQuery)handler.behaviour(VlanQuery.class);
            if (query == null) {
                return ImmutableSet.of();
            }
            return query.queryVlanIds(port);
        }
        catch (ItemNotFoundException e) {
            return ImmutableSet.of();
        }
    }

    private Set<MplsLabel> queryMplsLabels(DeviceId device, PortNumber port) {
        try {
            DriverHandler handler = this.driverService.createHandler(device, new String[0]);
            if (handler == null || !handler.hasBehaviour(MplsQuery.class)) {
                return ImmutableSet.of();
            }
            MplsQuery query = (MplsQuery)handler.behaviour(MplsQuery.class);
            if (query == null) {
                return ImmutableSet.of();
            }
            return query.queryMplsLabels(port);
        }
        catch (ItemNotFoundException e) {
            return ImmutableSet.of();
        }
    }

    private Set<TributarySlot> queryTributarySlots(DeviceId device, PortNumber port) {
        try {
            DriverHandler handler = this.driverService.createHandler(device, new String[0]);
            if (handler == null || !handler.hasBehaviour(TributarySlotQuery.class)) {
                return Collections.emptySet();
            }
            TributarySlotQuery query = (TributarySlotQuery)handler.behaviour(TributarySlotQuery.class);
            if (query != null) {
                return query.queryTributarySlots(port);
            }
            return Collections.emptySet();
        }
        catch (ItemNotFoundException e) {
            return Collections.emptySet();
        }
    }

    private /* synthetic */ void lambda$registerPortResource$5(Resource portPath, Device device, Port port) {
        Set<TributarySlot> tSlots;
        Set<OchSignal> lambdas;
        Set<MplsLabel> mplsLabels;
        if (!this.adminService.register(new Resource[]{portPath})) {
            log.error("Failed to register Port: {}", (Object)portPath.id());
        }
        this.queryBandwidth(device.id(), port.number()).map(bw -> portPath.child(Bandwidth.class, bw.bps())).map(xva$0 -> this.adminService.register(new Resource[]{xva$0})).ifPresent(success -> {
            if (!success.booleanValue()) {
                log.error("Failed to register Bandwidth for {}", (Object)portPath.id());
            }
        });
        Set<VlanId> vlans = this.queryVlanIds(device.id(), port.number());
        if (!vlans.isEmpty()) {
            boolean success2 = this.adminService.register(vlans.stream().map(arg_0 -> ((Resource)portPath).child(arg_0)).collect(Collectors.toList()));
            if (!success2) {
                log.error("Failed to register VLAN IDs for {}", (Object)portPath.id());
            }
        }
        if (!(mplsLabels = this.queryMplsLabels(device.id(), port.number())).isEmpty()) {
            boolean success3 = this.adminService.register(mplsLabels.stream().map(arg_0 -> ((Resource)portPath).child(arg_0)).collect(Collectors.toList()));
            if (!success3) {
                log.error("Failed to register MPLS Labels for {}", (Object)portPath.id());
            }
        }
        if (!(lambdas = this.queryLambdas(device.id(), port.number())).isEmpty()) {
            boolean success4 = this.adminService.register(lambdas.stream().map(arg_0 -> ((Resource)portPath).child(arg_0)).collect(Collectors.toList()));
            if (!success4) {
                log.error("Failed to register lambdas for {}", (Object)portPath.id());
            }
        }
        if (!(tSlots = this.queryTributarySlots(device.id(), port.number())).isEmpty()) {
            boolean success5 = this.adminService.register(tSlots.stream().map(arg_0 -> ((Resource)portPath).child(arg_0)).collect(Collectors.toList()));
            if (!success5) {
                log.error("Failed to register tributary slots for {}", (Object)portPath.id());
            }
        }
    }
}

