/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.math.RandomUtils;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onlab.util.Identifier;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.PortNumber;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LabelAllocator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ResourceService resourceService;
    private LabelSelection labelSelection;
    private OptimizationBehavior optLabelSelection;

    public LabelAllocator(ResourceService rs) {
        this.resourceService = (ResourceService)Preconditions.checkNotNull((Object)rs);
        this.labelSelection = this.getLabelSelection(SelectionBehavior.RANDOM);
        this.optLabelSelection = OptimizationBehavior.NONE;
    }

    public static boolean isInSelEnum(String value) {
        for (SelectionBehavior b : SelectionBehavior.values()) {
            if (!b.name().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInOptEnum(String value) {
        for (OptimizationBehavior b : OptimizationBehavior.values()) {
            if (!b.name().equals(value)) continue;
            return true;
        }
        return false;
    }

    public void setLabelSelection(String type) {
        if (LabelAllocator.isInSelEnum(type)) {
            this.labelSelection = this.getLabelSelection(type);
        }
    }

    public LabelSelection getLabelSelection() {
        return this.labelSelection;
    }

    public void setOptLabelSelection(String type) {
        if (LabelAllocator.isInOptEnum(type)) {
            this.optLabelSelection = OptimizationBehavior.valueOf(type);
        }
    }

    public OptimizationBehavior getOptLabelSelection() {
        return this.optLabelSelection;
    }

    private LabelSelection getLabelSelection(String type) {
        SelectionBehavior behavior = SelectionBehavior.valueOf(type);
        return this.getLabelSelection(behavior);
    }

    private LabelSelection getLabelSelection(SelectionBehavior type) {
        LabelSelection selection;
        switch (type) {
            case FIRST_FIT: {
                selection = new FirstFitSelection();
                break;
            }
            default: {
                selection = new RandomSelection();
            }
        }
        return selection;
    }

    private Set<Identifier<?>> getCandidates(LinkKey link, EncapsulationType type) {
        Set<Identifier<?>> availableIDsatSrc = this.getAvailableIDs(link.src(), type);
        Set<Identifier<?>> availableIDsatDst = this.getAvailableIDs(link.dst(), type);
        return Sets.intersection(availableIDsatSrc, availableIDsatDst);
    }

    private Map<LinkKey, Identifier<?>> noOptimizeBehavior(Set<LinkKey> links, EncapsulationType type) {
        HashMap ids = Maps.newHashMap();
        for (LinkKey link : links) {
            Set<Identifier<?>> candidates = this.getCandidates(link, type);
            Identifier<?> selected = this.labelSelection.select(candidates);
            if (selected == null) {
                this.log.warn("No labels for {}", (Object)link);
                return Collections.emptyMap();
            }
            ids.put(link, selected);
        }
        return ids;
    }

    private Map<LinkKey, Identifier<?>> noSwapBehavior(Set<LinkKey> links, EncapsulationType type) {
        HashMap ids = Maps.newHashMap();
        Sets.SetView candidates = null;
        for (LinkKey link : links) {
            Sets.SetView linkCandidates = this.getCandidates(link, type);
            if (candidates == null) {
                candidates = linkCandidates;
                continue;
            }
            candidates = Sets.intersection(candidates, linkCandidates);
        }
        Identifier<?> selected = this.labelSelection.select((Set<Identifier<?>>)candidates);
        if (selected == null) {
            this.log.warn("No common label for path");
            return Collections.emptyMap();
        }
        links.forEach(linkKey -> ids.put(linkKey, selected));
        return ids;
    }

    private Map<LinkKey, Identifier<?>> minSwapBehavior(Set<LinkKey> links, EncapsulationType type) {
        HashMap ids = Maps.newHashMap();
        Identifier<?> selected = null;
        for (LinkKey link : links) {
            Set<Identifier<?>> candidates = this.getCandidates(link, type);
            if (!(selected != null && candidates.contains(selected) || (selected = this.labelSelection.select(candidates)) != null)) {
                this.log.warn("No labels for {}", (Object)link);
                return Collections.emptyMap();
            }
            ids.put(link, selected);
        }
        return ids;
    }

    private Map<LinkKey, Identifier<?>> findAvailableIDs(Set<LinkKey> links, EncapsulationType type) {
        Map<LinkKey, Identifier<?>> ids;
        switch (this.optLabelSelection) {
            case NO_SWAP: {
                ids = this.noSwapBehavior(links, type);
                break;
            }
            case MIN_SWAP: {
                ids = this.minSwapBehavior(links, type);
                break;
            }
            default: {
                ids = this.noOptimizeBehavior(links, type);
            }
        }
        return ids;
    }

    private Set<Identifier<?>> getAvailableIDs(ConnectPoint cp, EncapsulationType type) {
        return this.resourceService.getAvailableResourceValues(Resources.discrete((DeviceId)cp.deviceId(), (PortNumber)cp.port(), (Object[])new Object[0]).id(), this.getEncapsulationClass(type));
    }

    private Class getEncapsulationClass(EncapsulationType type) {
        Class<MplsLabel> idType;
        switch (type) {
            case MPLS: {
                idType = MplsLabel.class;
                break;
            }
            default: {
                idType = VlanId.class;
            }
        }
        return idType;
    }

    public Map<LinkKey, Identifier<?>> assignLabelToLinks(Set<Link> links, ResourceConsumer resourceConsumer, EncapsulationType type) {
        Set linkRequest = links.stream().map(LinkKey::linkKey).collect(Collectors.toCollection(LinkedHashSet::new));
        Map<LinkKey, Identifier<?>> availableIds = this.findAvailableIDs(linkRequest, type);
        if (availableIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Set resources = availableIds.entrySet().stream().flatMap(x -> Stream.of(Resources.discrete((DeviceId)((LinkKey)x.getKey()).src().deviceId(), (PortNumber)((LinkKey)x.getKey()).src().port(), (Object[])new Object[]{x.getValue()}).resource(), Resources.discrete((DeviceId)((LinkKey)x.getKey()).dst().deviceId(), (PortNumber)((LinkKey)x.getKey()).dst().port(), (Object[])new Object[]{x.getValue()}).resource())).collect(Collectors.toSet());
        List allocations = this.resourceService.allocate(resourceConsumer, (List)ImmutableList.copyOf(resources));
        if (allocations.isEmpty()) {
            return Collections.emptyMap();
        }
        return ImmutableMap.copyOf(availableIds);
    }

    public Map<ConnectPoint, Identifier<?>> assignLabelToPorts(Set<Link> links, ResourceConsumer resourceConsumer, EncapsulationType type) {
        Map<LinkKey, Identifier<?>> allocation = this.assignLabelToLinks(links, resourceConsumer, type);
        if (allocation.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap finalAllocation = Maps.newHashMap();
        allocation.forEach((link, value) -> {
            finalAllocation.putIfAbsent(link.src(), value);
            finalAllocation.putIfAbsent(link.dst(), value);
        });
        return ImmutableMap.copyOf((Map)finalAllocation);
    }

    public static class FirstFitSelection
    implements LabelSelection {
        @Override
        public Identifier<?> select(Set<Identifier<?>> values) {
            if (!values.isEmpty()) {
                return values.iterator().next();
            }
            return null;
        }
    }

    public static class RandomSelection
    implements LabelSelection {
        @Override
        public Identifier<?> select(Set<Identifier<?>> values) {
            if (!values.isEmpty()) {
                int size = values.size();
                int index = RandomUtils.nextInt((int)size);
                return (Identifier)Iterables.get(values, (int)index);
            }
            return null;
        }
    }

    public static interface LabelSelection {
        public Identifier<?> select(Set<Identifier<?>> var1);
    }

    static enum OptimizationBehavior {
        NONE,
        NO_SWAP,
        MIN_SWAP;

    }

    private static enum SelectionBehavior {
        RANDOM,
        FIRST_FIT;

    }
}

