/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.region.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicRegionConfig;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionAdminService;
import org.onosproject.net.region.RegionEvent;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionListener;
import org.onosproject.net.region.RegionService;
import org.onosproject.net.region.RegionStore;
import org.onosproject.net.region.RegionStoreDelegate;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.onosproject.ui.topo.LayoutLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class RegionManager
extends AbstractListenerManager<RegionEvent, RegionListener>
implements RegionAdminService,
RegionService {
    private static final String REGION_ID_NULL = "Region ID cannot be null";
    private static final String REGION_TYPE_NULL = "Region type cannot be null";
    private static final String DEVICE_ID_NULL = "Device ID cannot be null";
    private static final String DEVICE_IDS_NULL = "Device IDs cannot be null";
    private static final String DEVICE_IDS_EMPTY = "Device IDs cannot be empty";
    private static final String NAME_NULL = "Name cannot be null";
    private static final String PEER_LOCATIONS = "peerLocations";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final NetworkConfigListener networkConfigListener = new InternalNetworkConfigListener();
    private RegionStoreDelegate delegate = arg_0 -> ((RegionManager)this).post(arg_0);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RegionStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;

    @Activate
    public void activate() {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(RegionEvent.class, (EventSink)this.listenerRegistry);
        this.networkConfigService.addListener((EventListener)this.networkConfigListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.networkConfigService.removeListener((EventListener)this.networkConfigListener);
        this.eventDispatcher.removeSink(RegionEvent.class);
        this.log.info("Stopped");
    }

    private String dstr(double d) {
        return Double.toString(d);
    }

    private Annotations genAnnots(RegionId id) {
        BasicRegionConfig cfg = (BasicRegionConfig)this.networkConfigService.getConfig((Object)id, BasicRegionConfig.class);
        if (cfg == null) {
            return DefaultAnnotations.builder().build();
        }
        return this.genAnnots(cfg, id);
    }

    private Annotations genAnnots(BasicRegionConfig cfg, RegionId rid) {
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder().set("name", cfg.name()).set("latitude", this.dstr(cfg.latitude())).set("longitude", this.dstr(cfg.longitude()));
        String uiType = cfg.uiType();
        if (uiType != null) {
            builder.set("uiType", uiType);
        }
        List locMappings = cfg.getMappings();
        builder.set(PEER_LOCATIONS, LayoutLocation.toCompactListString((List)locMappings));
        return builder.build();
    }

    public Region createRegion(RegionId regionId, String name, Region.Type type, List<Set<NodeId>> masterNodeIds) {
        Preconditions.checkNotNull((Object)regionId, (Object)REGION_ID_NULL);
        Preconditions.checkNotNull((Object)name, (Object)NAME_NULL);
        Preconditions.checkNotNull((Object)name, (Object)REGION_TYPE_NULL);
        return this.store.createRegion(regionId, name, type, this.genAnnots(regionId), (List)(masterNodeIds == null ? ImmutableList.of() : masterNodeIds));
    }

    public Region updateRegion(RegionId regionId, String name, Region.Type type, List<Set<NodeId>> masterNodeIds) {
        Preconditions.checkNotNull((Object)regionId, (Object)REGION_ID_NULL);
        Preconditions.checkNotNull((Object)name, (Object)NAME_NULL);
        Preconditions.checkNotNull((Object)name, (Object)REGION_TYPE_NULL);
        return this.store.updateRegion(regionId, name, type, this.genAnnots(regionId), (List)(masterNodeIds == null ? ImmutableList.of() : masterNodeIds));
    }

    public void removeRegion(RegionId regionId) {
        Preconditions.checkNotNull((Object)regionId, (Object)REGION_ID_NULL);
        this.store.removeRegion(regionId);
    }

    public void addDevices(RegionId regionId, Collection<DeviceId> deviceIds) {
        Preconditions.checkNotNull((Object)regionId, (Object)REGION_ID_NULL);
        Preconditions.checkNotNull(deviceIds, (Object)DEVICE_IDS_NULL);
        Preconditions.checkState((!deviceIds.isEmpty() ? 1 : 0) != 0, (Object)DEVICE_IDS_EMPTY);
        this.store.addDevices(regionId, deviceIds);
    }

    public void removeDevices(RegionId regionId, Collection<DeviceId> deviceIds) {
        Preconditions.checkNotNull((Object)regionId, (Object)REGION_ID_NULL);
        Preconditions.checkNotNull(deviceIds, (Object)DEVICE_IDS_NULL);
        Preconditions.checkState((!deviceIds.isEmpty() ? 1 : 0) != 0, (Object)DEVICE_IDS_EMPTY);
        this.store.removeDevices(regionId, deviceIds);
    }

    public Set<Region> getRegions() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.REGION_READ);
        return this.store.getRegions();
    }

    public Region getRegion(RegionId regionId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.REGION_READ);
        Preconditions.checkNotNull((Object)regionId, (Object)REGION_ID_NULL);
        return this.store.getRegion(regionId);
    }

    public Region getRegionForDevice(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.REGION_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.store.getRegionForDevice(deviceId);
    }

    public Set<DeviceId> getRegionDevices(RegionId regionId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.REGION_READ);
        Preconditions.checkNotNull((Object)regionId, (Object)REGION_ID_NULL);
        return this.store.getRegionDevices(regionId);
    }

    public Set<HostId> getRegionHosts(RegionId regionId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.REGION_READ);
        Preconditions.checkNotNull((Object)regionId, (Object)REGION_ID_NULL);
        return ImmutableSet.of();
    }

    private boolean isAllowed(BasicRegionConfig cfg) {
        return cfg == null || cfg.isAllowed();
    }

    protected void bindStore(RegionStore regionStore) {
        this.store = regionStore;
    }

    protected void unbindStore(RegionStore regionStore) {
        if (this.store == regionStore) {
            this.store = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            RegionId rid = (RegionId)event.subject();
            BasicRegionConfig cfg = (BasicRegionConfig)RegionManager.this.networkConfigService.getConfig((Object)rid, BasicRegionConfig.class);
            if (!RegionManager.this.isAllowed(cfg)) {
                this.kickOutBadRegion(rid);
            } else {
                try {
                    Region region = RegionManager.this.getRegion(rid);
                    String name = region.name();
                    Region.Type type = region.type();
                    Annotations annots = RegionManager.this.genAnnots(cfg, rid);
                    List masterNodeIds = region.masters();
                    RegionManager.this.store.updateRegion(rid, name, type, annots, masterNodeIds);
                }
                catch (ItemNotFoundException infe) {
                    RegionManager.this.log.debug("warn: no region found with id {}", (Object)rid);
                }
            }
        }

        public boolean isRelevant(NetworkConfigEvent event) {
            return (event.type() == NetworkConfigEvent.Type.CONFIG_ADDED || event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED) && event.configClass().equals(BasicRegionConfig.class);
        }

        private void kickOutBadRegion(RegionId regionId) {
            Region badRegion = RegionManager.this.getRegion(regionId);
            if (badRegion != null) {
                RegionManager.this.removeRegion(regionId);
            }
        }
    }
}

