/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.proxyarp.impl;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.ARP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.packet.ndp.NeighborAdvertisement;
import org.onlab.packet.ndp.NeighborSolicitation;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.proxyarp.ProxyArpService;
import org.onosproject.net.proxyarp.ProxyArpStore;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(immediate=true)
@Service
public class ProxyArpManager
implements ProxyArpService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MAC_ADDR_NULL = "MAC address cannot be null.";
    private static final String REQUEST_NULL = "ARP or NDP request cannot be null.";
    private static final String MSG_NOT_REQUEST = "Message is not an ARP or NDP request";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EdgePortService edgeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ProxyArpStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;

    @Activate
    public void activate() {
        this.store.setDelegate(this::sendTo);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.setDelegate(null);
        this.log.info("Stopped");
    }

    public boolean isKnown(IpAddress addr) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        Preconditions.checkNotNull((Object)addr, (Object)MAC_ADDR_NULL);
        Set hosts = this.hostService.getHostsByIp(addr);
        return !hosts.isEmpty();
    }

    public void reply(Ethernet eth, ConnectPoint inPort) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_WRITE);
        Preconditions.checkNotNull((Object)eth, (Object)REQUEST_NULL);
        MessageContext context = this.createContext(eth, inPort);
        if (context != null) {
            this.replyInternal(context);
        }
    }

    private void replyInternal(MessageContext context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((context.type() == MessageType.REQUEST ? 1 : 0) != 0, (Object)MSG_NOT_REQUEST);
        if (this.hasIpAddress(context.inPort())) {
            this.interfaceService.getInterfacesByPort(context.inPort()).stream().filter(intf -> intf.ipAddresses().stream().anyMatch(ia -> ia.ipAddress().equals((Object)context.target()))).forEach(intf -> this.buildAndSendReply(context, intf.mac()));
            return;
        }
        Set hosts = this.hostService.getHostsByIp(context.target());
        Host dst = null;
        Host src = this.hostService.getHost(HostId.hostId((MacAddress)context.srcMac(), (VlanId)context.vlan()));
        for (Host host : hosts) {
            if (!host.vlan().equals((Object)context.vlan())) continue;
            dst = host;
            break;
        }
        if (src != null && dst != null) {
            this.buildAndSendReply(context, dst.mac());
            return;
        }
        boolean matched = false;
        Set interfaces = this.interfaceService.getInterfacesByIp(context.sender());
        for (Interface intf2 : interfaces) {
            if (!intf2.vlan().equals((Object)context.vlan())) continue;
            matched = true;
            this.sendTo(context.packet(), intf2.connectPoint());
            break;
        }
        if (matched) {
            return;
        }
        VlanId vlanId = context.vlan();
        Set<Interface> filteredVlanInterfaces = this.filterVlanInterfacesNoIp(this.interfaceService.getInterfacesByVlan(vlanId));
        if (vlanId != null && !vlanId.equals((Object)VlanId.NONE) && this.confContainsVlans(vlanId, context.inPort())) {
            this.vlanFlood(context.packet(), filteredVlanInterfaces, context.inPort);
            return;
        }
        this.flood(context.packet(), context.inPort());
    }

    private Set<Interface> filterVlanInterfacesNoIp(Set<Interface> vlanInterfaces) {
        return vlanInterfaces.stream().filter(intf -> intf.ipAddresses().isEmpty()).collect(Collectors.toSet());
    }

    private boolean confContainsVlans(VlanId vlanId, ConnectPoint connectPoint) {
        Set vlanInterfaces = this.interfaceService.getInterfacesByVlan(vlanId);
        return this.interfaceService.getInterfacesByVlan(vlanId).stream().anyMatch(intf -> intf.connectPoint().equals((Object)connectPoint) && intf.ipAddresses().isEmpty()) && vlanInterfaces.size() > 1;
    }

    private void buildAndSendReply(MessageContext context, MacAddress targetMac) {
        switch (context.protocol()) {
            case ARP: {
                this.sendTo(ARP.buildArpReply((Ip4Address)((Ip4Address)context.target()), (MacAddress)targetMac, (Ethernet)context.packet()), context.inPort());
                break;
            }
            case NDP: {
                this.sendTo(this.buildNdpReply((Ip6Address)context.target(), targetMac, context.packet()), context.inPort());
                break;
            }
        }
    }

    private void sendTo(Ethernet packet, ConnectPoint outPort) {
        this.sendTo(outPort, ByteBuffer.wrap(packet.serialize()));
    }

    private void sendTo(ConnectPoint outPort, ByteBuffer packet) {
        if (!this.edgeService.isEdgePoint(outPort)) {
            return;
        }
        TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
        builder.setOutput(outPort.port());
        this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(outPort.deviceId(), builder.build(), packet));
    }

    private boolean hasIpAddress(ConnectPoint connectPoint) {
        return this.interfaceService.getInterfacesByPort(connectPoint).stream().flatMap(intf -> intf.ipAddresses().stream()).findAny().isPresent();
    }

    private boolean hasVlan(ConnectPoint connectPoint) {
        return this.interfaceService.getInterfacesByPort(connectPoint).stream().filter(intf -> !intf.vlan().equals((Object)VlanId.NONE)).findAny().isPresent();
    }

    public void forward(Ethernet eth, ConnectPoint inPort) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_WRITE);
        Preconditions.checkNotNull((Object)eth, (Object)REQUEST_NULL);
        Host h = this.hostService.getHost(HostId.hostId((MacAddress)eth.getDestinationMAC(), (VlanId)VlanId.vlanId((short)eth.getVlanID())));
        if (h == null) {
            this.flood(eth, inPort);
        } else {
            Host subject = this.hostService.getHost(HostId.hostId((MacAddress)eth.getSourceMAC(), (VlanId)VlanId.vlanId((short)eth.getVlanID())));
            this.store.forward((ConnectPoint)h.location(), subject, ByteBuffer.wrap(eth.serialize()));
        }
    }

    public boolean handlePacket(PacketContext context) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_WRITE);
        InboundPacket pkt = context.inPacket();
        Ethernet ethPkt = pkt.parsed();
        if (ethPkt == null) {
            return false;
        }
        MessageContext msgContext = this.createContext(ethPkt, pkt.receivedFrom());
        if (msgContext == null) {
            return false;
        }
        switch (msgContext.type()) {
            case REPLY: {
                this.forward(msgContext.packet(), msgContext.inPort());
                break;
            }
            case REQUEST: {
                this.replyInternal(msgContext);
                break;
            }
            default: {
                return false;
            }
        }
        context.block();
        return true;
    }

    private void vlanFlood(Ethernet request, Set<Interface> dsts, ConnectPoint inPort) {
        TrafficTreatment.Builder builder = null;
        ByteBuffer buf = ByteBuffer.wrap(request.serialize());
        for (Interface intf : dsts) {
            ConnectPoint cPoint = intf.connectPoint();
            if (cPoint.equals((Object)inPort)) continue;
            builder = DefaultTrafficTreatment.builder();
            builder.setOutput(cPoint.port());
            this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(cPoint.deviceId(), builder.build(), buf));
        }
    }

    private void flood(Ethernet request, ConnectPoint inPort) {
        TrafficTreatment.Builder builder = null;
        ByteBuffer buf = ByteBuffer.wrap(request.serialize());
        for (ConnectPoint connectPoint : this.edgeService.getEdgePoints()) {
            if (this.hasIpAddress(connectPoint) || this.hasVlan(connectPoint) || connectPoint.equals((Object)inPort)) continue;
            builder = DefaultTrafficTreatment.builder();
            builder.setOutput(connectPoint.port());
            this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(connectPoint.deviceId(), builder.build(), buf));
        }
    }

    private Ethernet buildNdpReply(Ip6Address srcIp, MacAddress srcMac, Ethernet request) {
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(request.getSourceMAC());
        eth.setSourceMACAddress(srcMac);
        eth.setEtherType(Ethernet.TYPE_IPV6);
        eth.setVlanID(request.getVlanID());
        IPv6 requestIp = (IPv6)request.getPayload();
        IPv6 ipv6 = new IPv6();
        ipv6.setSourceAddress(srcIp.toOctets());
        ipv6.setDestinationAddress(requestIp.getSourceAddress());
        ipv6.setHopLimit((byte)-1);
        ICMP6 icmp6 = new ICMP6();
        icmp6.setIcmpType((byte)-120);
        icmp6.setIcmpCode((byte)0);
        NeighborAdvertisement nadv = new NeighborAdvertisement();
        nadv.setTargetAddress(srcIp.toOctets());
        nadv.setSolicitedFlag((byte)1);
        nadv.setOverrideFlag((byte)1);
        nadv.addOption((byte)2, srcMac.toBytes());
        icmp6.setPayload((IPacket)nadv);
        ipv6.setPayload((IPacket)icmp6);
        eth.setPayload((IPacket)ipv6);
        return eth;
    }

    private MessageContext createContext(Ethernet eth, ConnectPoint inPort) {
        if (eth.getEtherType() == Ethernet.TYPE_ARP) {
            return this.createArpContext(eth, inPort);
        }
        if (eth.getEtherType() == Ethernet.TYPE_IPV6) {
            return this.createNdpContext(eth, inPort);
        }
        return null;
    }

    private MessageContext createArpContext(Ethernet eth, ConnectPoint inPort) {
        MessageType type;
        if (eth.getEtherType() != Ethernet.TYPE_ARP) {
            return null;
        }
        ARP arp = (ARP)eth.getPayload();
        Ip4Address target = Ip4Address.valueOf((byte[])arp.getTargetProtocolAddress());
        Ip4Address sender = Ip4Address.valueOf((byte[])arp.getSenderProtocolAddress());
        if (arp.getOpCode() == 1) {
            type = MessageType.REQUEST;
        } else if (arp.getOpCode() == 2) {
            type = MessageType.REPLY;
        } else {
            return null;
        }
        return new MessageContext(eth, inPort, Protocol.ARP, type, (IpAddress)target, (IpAddress)sender);
    }

    private MessageContext createNdpContext(Ethernet eth, ConnectPoint inPort) {
        MessageType type;
        if (eth.getEtherType() != Ethernet.TYPE_IPV6) {
            return null;
        }
        IPv6 ipv6 = (IPv6)eth.getPayload();
        if (ipv6.getNextHeader() != 58) {
            return null;
        }
        ICMP6 icmpv6 = (ICMP6)ipv6.getPayload();
        Ip6Address sender = Ip6Address.valueOf((byte[])ipv6.getSourceAddress());
        Ip6Address target = null;
        if (icmpv6.getIcmpType() == -121) {
            type = MessageType.REQUEST;
            NeighborSolicitation nsol = (NeighborSolicitation)icmpv6.getPayload();
            target = Ip6Address.valueOf((byte[])nsol.getTargetAddress());
        } else if (icmpv6.getIcmpType() == -120) {
            type = MessageType.REPLY;
        } else {
            return null;
        }
        return new MessageContext(eth, inPort, Protocol.NDP, type, (IpAddress)target, (IpAddress)sender);
    }

    protected void bindEdgeService(EdgePortService edgePortService) {
        this.edgeService = edgePortService;
    }

    protected void unbindEdgeService(EdgePortService edgePortService) {
        if (this.edgeService == edgePortService) {
            this.edgeService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindStore(ProxyArpStore proxyArpStore) {
        this.store = proxyArpStore;
    }

    protected void unbindStore(ProxyArpStore proxyArpStore) {
        if (this.store == proxyArpStore) {
            this.store = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    private class MessageContext {
        private Protocol protocol;
        private MessageType type;
        private IpAddress target;
        private IpAddress sender;
        private Ethernet eth;
        private ConnectPoint inPort;

        public MessageContext(Ethernet eth, ConnectPoint inPort, Protocol protocol, MessageType type, IpAddress target, IpAddress sender) {
            this.eth = eth;
            this.inPort = inPort;
            this.protocol = protocol;
            this.type = type;
            this.target = target;
            this.sender = sender;
        }

        public ConnectPoint inPort() {
            return this.inPort;
        }

        public Ethernet packet() {
            return this.eth;
        }

        public Protocol protocol() {
            return this.protocol;
        }

        public MessageType type() {
            return this.type;
        }

        public VlanId vlan() {
            return VlanId.vlanId((short)this.eth.getVlanID());
        }

        public MacAddress srcMac() {
            return MacAddress.valueOf((byte[])this.eth.getSourceMACAddress());
        }

        public IpAddress target() {
            return this.target;
        }

        public IpAddress sender() {
            return this.sender;
        }
    }

    private static enum MessageType {
        REQUEST,
        REPLY;

    }

    private static enum Protocol {
        ARP,
        NDP;

    }
}

