/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.packet.DefaultPacketRequest;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketEvent;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketProcessorEntry;
import org.onosproject.net.packet.PacketProvider;
import org.onosproject.net.packet.PacketProviderRegistry;
import org.onosproject.net.packet.PacketProviderService;
import org.onosproject.net.packet.PacketRequest;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.packet.PacketStore;
import org.onosproject.net.packet.PacketStoreDelegate;
import org.onosproject.net.packet.impl.PacketDriverProvider;
import org.onosproject.net.provider.AbstractProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PacketManager
extends AbstractProviderRegistry<PacketProvider, PacketProviderService>
implements PacketService,
PacketProviderRegistry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ERROR_NULL_PROCESSOR = "Processor cannot be null";
    private static final String ERROR_NULL_SELECTOR = "Selector cannot be null";
    private static final String ERROR_NULL_APP_ID = "Application ID cannot be null";
    private static final String ERROR_NULL_DEVICE_ID = "Device ID cannot be null";
    private final PacketStoreDelegate delegate = new InternalStoreDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService objectiveService;
    private ExecutorService eventHandlingExecutor;
    private final DeviceListener deviceListener = new InternalDeviceListener();
    private final List<ProcessorEntry> processors = Lists.newCopyOnWriteArrayList();
    private final PacketDriverProvider defaultProvider = new PacketDriverProvider();
    private ApplicationId appId;
    private NodeId localNodeId;
    private static final Set<String> SUPPORTED = ImmutableSet.of((Object)"of");

    @Activate
    public void activate() {
        this.eventHandlingExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/net/packet", (String)"event-handler", (Logger)this.log));
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.appId = this.coreService.getAppId("org.onosproject.core");
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.store.existingRequests().forEach(this::pushToAllDevices);
        this.defaultProvider.init(this.deviceService);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.eventHandlingExecutor.shutdown();
        this.log.info("Stopped");
    }

    protected PacketProvider defaultProvider() {
        return this.defaultProvider;
    }

    public void addProcessor(PacketProcessor processor, int priority) {
        int i;
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_EVENT);
        Preconditions.checkNotNull((Object)processor, (Object)ERROR_NULL_PROCESSOR);
        ProcessorEntry entry = new ProcessorEntry(processor, priority);
        for (i = 0; i < this.processors.size() && priority >= this.processors.get(i).priority(); ++i) {
        }
        this.processors.add(i, entry);
    }

    public void removeProcessor(PacketProcessor processor) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_EVENT);
        Preconditions.checkNotNull((Object)processor, (Object)ERROR_NULL_PROCESSOR);
        for (int i = 0; i < this.processors.size(); ++i) {
            if (this.processors.get(i).processor() != processor) continue;
            this.processors.remove(i);
            break;
        }
    }

    public List<PacketProcessorEntry> getProcessors() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        return ImmutableList.copyOf(this.processors);
    }

    public void requestPackets(TrafficSelector selector, PacketPriority priority, ApplicationId appId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        Preconditions.checkNotNull((Object)selector, (Object)ERROR_NULL_SELECTOR);
        Preconditions.checkNotNull((Object)appId, (Object)ERROR_NULL_APP_ID);
        DefaultPacketRequest request = new DefaultPacketRequest(selector, priority, appId, this.localNodeId, Optional.empty());
        this.store.requestPackets((PacketRequest)request);
    }

    public void requestPackets(TrafficSelector selector, PacketPriority priority, ApplicationId appId, Optional<DeviceId> deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        Preconditions.checkNotNull((Object)selector, (Object)ERROR_NULL_SELECTOR);
        Preconditions.checkNotNull((Object)appId, (Object)ERROR_NULL_APP_ID);
        Preconditions.checkNotNull(deviceId, (Object)ERROR_NULL_DEVICE_ID);
        DefaultPacketRequest request = new DefaultPacketRequest(selector, priority, appId, this.localNodeId, deviceId);
        this.store.requestPackets((PacketRequest)request);
    }

    public void cancelPackets(TrafficSelector selector, PacketPriority priority, ApplicationId appId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        Preconditions.checkNotNull((Object)selector, (Object)ERROR_NULL_SELECTOR);
        Preconditions.checkNotNull((Object)appId, (Object)ERROR_NULL_APP_ID);
        DefaultPacketRequest request = new DefaultPacketRequest(selector, priority, appId, this.localNodeId, Optional.empty());
        this.store.cancelPackets((PacketRequest)request);
    }

    public void cancelPackets(TrafficSelector selector, PacketPriority priority, ApplicationId appId, Optional<DeviceId> deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        Preconditions.checkNotNull((Object)selector, (Object)ERROR_NULL_SELECTOR);
        Preconditions.checkNotNull((Object)appId, (Object)ERROR_NULL_APP_ID);
        Preconditions.checkNotNull(deviceId, (Object)ERROR_NULL_DEVICE_ID);
        DefaultPacketRequest request = new DefaultPacketRequest(selector, priority, appId, this.localNodeId, deviceId);
        this.store.cancelPackets((PacketRequest)request);
    }

    public List<PacketRequest> getRequests() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        return this.store.existingRequests();
    }

    private void pushRulesToDevice(Device device) {
        this.log.debug("Pushing packet requests to device {}", (Object)device.id());
        for (PacketRequest request : this.store.existingRequests()) {
            if (!request.deviceId().isPresent()) {
                this.pushRule(device, request);
                continue;
            }
            if (!((DeviceId)request.deviceId().get()).equals((Object)device.id())) continue;
            this.pushRule(device, request);
        }
    }

    private void pushToAllDevices(PacketRequest request) {
        this.log.debug("Pushing packet request {} to all devices", (Object)request);
        for (Device device : this.deviceService.getDevices()) {
            if (!SUPPORTED.contains(device.id().uri().getScheme())) continue;
            this.pushRule(device, request);
        }
    }

    private void removeFromAllDevices(PacketRequest request) {
        this.deviceService.getAvailableDevices().forEach(d -> this.removeRule((Device)d, request));
    }

    private void pushRule(final Device device, final PacketRequest request) {
        if (!device.type().equals((Object)Device.Type.SWITCH)) {
            return;
        }
        ForwardingObjective forwarding = this.createBuilder(request).add(new ObjectiveContext(){

            public void onError(Objective objective, ObjectiveError error) {
                PacketManager.this.log.warn("Failed to install packet request {} to {}: {}", new Object[]{request, device.id(), error});
            }
        });
        this.objectiveService.forward(device.id(), forwarding);
    }

    private void removeRule(final Device device, final PacketRequest request) {
        if (!device.type().equals((Object)Device.Type.SWITCH)) {
            return;
        }
        ForwardingObjective forwarding = this.createBuilder(request).remove(new ObjectiveContext(){

            public void onError(Objective objective, ObjectiveError error) {
                PacketManager.this.log.warn("Failed to withdraw packet request {} from {}: {}", new Object[]{request, device.id(), error});
            }
        });
        this.objectiveService.forward(device.id(), forwarding);
    }

    private DefaultForwardingObjective.Builder createBuilder(PacketRequest request) {
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().punt().wipeDeferred().build();
        return DefaultForwardingObjective.builder().withPriority(request.priority().priorityValue()).withSelector(request.selector()).fromApp(this.appId).withFlag(ForwardingObjective.Flag.VERSATILE).withTreatment(treatment).makePermanent();
    }

    public void emit(OutboundPacket packet) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_WRITE);
        Preconditions.checkNotNull((Object)packet, (Object)"Packet cannot be null");
        this.store.emit(packet);
    }

    private void localEmit(OutboundPacket packet) {
        Device device = this.deviceService.getDevice(packet.sendThrough());
        if (device == null) {
            return;
        }
        PacketProvider packetProvider = (PacketProvider)this.getProvider(device.providerId());
        if (packetProvider != null) {
            packetProvider.emit(packet);
        }
    }

    protected PacketProviderService createProviderService(PacketProvider provider) {
        return new InternalPacketProviderService(provider);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindStore(PacketStore packetStore) {
        this.store = packetStore;
    }

    protected void unbindStore(PacketStore packetStore) {
        if (this.store == packetStore) {
            this.store = null;
        }
    }

    protected void bindObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.objectiveService = flowObjectiveService;
    }

    protected void unbindObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.objectiveService == flowObjectiveService) {
            this.objectiveService = null;
        }
    }

    private class ProcessorEntry
    implements PacketProcessorEntry {
        private final PacketProcessor processor;
        private final int priority;
        private long invocations = 0L;
        private long nanos = 0L;

        public ProcessorEntry(PacketProcessor processor, int priority) {
            this.processor = processor;
            this.priority = priority;
        }

        public PacketProcessor processor() {
            return this.processor;
        }

        public int priority() {
            return this.priority;
        }

        public long invocations() {
            return this.invocations;
        }

        public long totalNanos() {
            return this.nanos;
        }

        public long averageNanos() {
            return this.invocations > 0L ? this.nanos / this.invocations : 0L;
        }

        void addNanos(long nanos) {
            this.nanos += nanos;
            ++this.invocations;
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            PacketManager.this.eventHandlingExecutor.execute(() -> {
                try {
                    Device device = (Device)event.subject();
                    switch ((DeviceEvent.Type)event.type()) {
                        case DEVICE_ADDED: 
                        case DEVICE_AVAILABILITY_CHANGED: {
                            if (!PacketManager.this.deviceService.isAvailable(((Device)event.subject()).id())) break;
                            PacketManager.this.pushRulesToDevice(device);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    PacketManager.this.log.warn("Failed to process {}", (Object)event, (Object)e);
                }
            });
        }
    }

    protected class InternalStoreDelegate
    implements PacketStoreDelegate {
        protected InternalStoreDelegate() {
        }

        public void notify(PacketEvent event) {
            PacketManager.this.localEmit((OutboundPacket)event.subject());
        }

        public void requestPackets(PacketRequest request) {
            DeviceId deviceid = request.deviceId().orElse(null);
            if (deviceid != null) {
                PacketManager.this.pushRule(PacketManager.this.deviceService.getDevice(deviceid), request);
            } else {
                PacketManager.this.pushToAllDevices(request);
            }
        }

        public void cancelPackets(PacketRequest request) {
            DeviceId deviceid = request.deviceId().orElse(null);
            if (deviceid != null) {
                PacketManager.this.removeRule(PacketManager.this.deviceService.getDevice(deviceid), request);
            } else {
                PacketManager.this.removeFromAllDevices(request);
            }
        }
    }

    private class InternalPacketProviderService
    extends AbstractProviderService<PacketProvider>
    implements PacketProviderService {
        protected InternalPacketProviderService(PacketProvider provider) {
            super((Provider)provider);
        }

        public void processPacket(PacketContext context) {
            for (ProcessorEntry entry : PacketManager.this.processors) {
                try {
                    long start = System.nanoTime();
                    entry.processor().process(context);
                    entry.addNanos(System.nanoTime() - start);
                }
                catch (Exception e) {
                    PacketManager.this.log.warn("Packet processor {} threw an exception", (Object)entry.processor(), (Object)e);
                }
            }
        }
    }
}

