/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet.impl;

import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketProgrammable;
import org.onosproject.net.packet.PacketProvider;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketDriverProvider
extends AbstractProvider
implements PacketProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String SCHEME = "default";
    private static final String PROVIDER_NAME = "org.onosproject.provider";
    protected DeviceService deviceService;

    public PacketDriverProvider() {
        super(new ProviderId(SCHEME, PROVIDER_NAME));
    }

    void init(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    public void emit(OutboundPacket packet) {
        PacketProgrammable programmable = this.getPacketProgrammable(packet.sendThrough());
        if (programmable != null) {
            programmable.emit(packet);
        }
    }

    private PacketProgrammable getPacketProgrammable(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device.is(PacketProgrammable.class)) {
            return (PacketProgrammable)device.as(PacketProgrammable.class);
        }
        this.log.debug("Device {} is not packet programmable", (Object)deviceId);
        return null;
    }
}

