/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.link.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.Provided;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicLinkConfig;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.link.LinkAdminService;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.link.LinkStore;
import org.onosproject.net.link.LinkStoreDelegate;
import org.onosproject.net.link.impl.BasicLinkOperator;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class LinkManager
extends AbstractListenerProviderRegistry<LinkEvent, LinkListener, LinkProvider, LinkProviderService>
implements LinkService,
LinkAdminService,
LinkProviderRegistry {
    private static final String DEVICE_ID_NULL = "Device ID cannot be null";
    private static final String LINK_DESC_NULL = "Link description cannot be null";
    private static final String CONNECT_POINT_NULL = "Connection point cannot be null";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final LinkStoreDelegate delegate = new InternalStoreDelegate();
    private final DeviceListener deviceListener = new InternalDeviceListener();
    private final NetworkConfigListener networkConfigListener = new InternalNetworkConfigListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;

    @Activate
    public void activate() {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(LinkEvent.class, (EventSink)this.listenerRegistry);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.networkConfigService.addListener((EventListener)this.networkConfigListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(LinkEvent.class);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.networkConfigService.removeListener((EventListener)this.networkConfigListener);
        this.log.info("Stopped");
    }

    public int getLinkCount() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.LINK_READ);
        return this.store.getLinkCount();
    }

    public Iterable<Link> getLinks() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.LINK_READ);
        return this.store.getLinks();
    }

    public Iterable<Link> getActiveLinks() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.LINK_READ);
        return FluentIterable.from(this.getLinks()).filter(input -> input.state() == Link.State.ACTIVE);
    }

    public Set<Link> getDeviceLinks(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.LINK_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return Sets.union((Set)this.store.getDeviceEgressLinks(deviceId), (Set)this.store.getDeviceIngressLinks(deviceId));
    }

    public Set<Link> getDeviceEgressLinks(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.LINK_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.store.getDeviceEgressLinks(deviceId);
    }

    public Set<Link> getDeviceIngressLinks(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.LINK_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.store.getDeviceIngressLinks(deviceId);
    }

    public Set<Link> getLinks(ConnectPoint connectPoint) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.LINK_READ);
        Preconditions.checkNotNull((Object)connectPoint, (Object)CONNECT_POINT_NULL);
        return Sets.union((Set)this.store.getEgressLinks(connectPoint), (Set)this.store.getIngressLinks(connectPoint));
    }

    public Set<Link> getEgressLinks(ConnectPoint connectPoint) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.LINK_READ);
        Preconditions.checkNotNull((Object)connectPoint, (Object)CONNECT_POINT_NULL);
        return this.store.getEgressLinks(connectPoint);
    }

    public Set<Link> getIngressLinks(ConnectPoint connectPoint) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.LINK_READ);
        Preconditions.checkNotNull((Object)connectPoint, (Object)CONNECT_POINT_NULL);
        return this.store.getIngressLinks(connectPoint);
    }

    public Link getLink(ConnectPoint src, ConnectPoint dst) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.LINK_READ);
        Preconditions.checkNotNull((Object)src, (Object)CONNECT_POINT_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)CONNECT_POINT_NULL);
        return this.store.getLink(src, dst);
    }

    public void removeLinks(ConnectPoint connectPoint) {
        if (this.deviceService.getRole(connectPoint.deviceId()) != MastershipRole.MASTER) {
            return;
        }
        this.removeLinks(this.getLinks(connectPoint), false);
    }

    public void removeLinks(DeviceId deviceId) {
        if (this.deviceService.getRole(deviceId) != MastershipRole.MASTER) {
            return;
        }
        this.removeLinks(this.getDeviceLinks(deviceId), false);
    }

    public void removeLink(ConnectPoint src, ConnectPoint dst) {
        this.post((Event)this.store.removeLink(src, dst));
    }

    private boolean isAllowed(BasicLinkConfig cfg) {
        return cfg == null || cfg.isAllowed();
    }

    protected LinkProviderService createProviderService(LinkProvider provider) {
        return new InternalLinkProviderService(provider);
    }

    private void removeLinks(Set<Link> links, boolean isSoftRemove) {
        for (Link link : links) {
            LinkEvent event = isSoftRemove ? this.store.removeOrDownLink(link.src(), link.dst()) : this.store.removeLink(link.src(), link.dst());
            if (event == null) continue;
            this.log.info("Link {} removed/vanished", event.subject());
            this.post((Event)event);
        }
    }

    protected void bindStore(LinkStore linkStore) {
        this.store = linkStore;
    }

    protected void unbindStore(LinkStore linkStore) {
        if (this.store == linkStore) {
            this.store = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public boolean isRelevant(NetworkConfigEvent event) {
            return event.configClass().equals(BasicLinkConfig.class) && (event.type() == NetworkConfigEvent.Type.CONFIG_ADDED || event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED);
        }

        public void event(NetworkConfigEvent event) {
            LinkKey lk = (LinkKey)event.subject();
            BasicLinkConfig cfg = (BasicLinkConfig)event.config().get();
            LinkManager.this.log.debug("Detected link network config event {}", (Object)event.type());
            if (!LinkManager.this.isAllowed(cfg)) {
                LinkManager.this.log.info("Kicking out links between {} and {}", (Object)lk.src(), (Object)lk.dst());
                LinkManager.this.removeLink(lk.src(), lk.dst());
                LinkManager.this.removeLink(lk.dst(), lk.src());
                return;
            }
            this.doUpdate(lk.src(), lk.dst(), cfg);
            if (cfg.isBidirectional().booleanValue()) {
                this.doUpdate(lk.dst(), lk.src(), cfg);
            }
        }

        private void doUpdate(ConnectPoint src, ConnectPoint dst, BasicLinkConfig cfg) {
            Link link = LinkManager.this.getLink(src, dst);
            LinkDescription desc = link == null ? BasicLinkOperator.descriptionOf(src, dst, cfg) : BasicLinkOperator.combine(cfg, BasicLinkOperator.descriptionOf(src, dst, link));
            ProviderId pid = Optional.ofNullable(link).map(Provided::providerId).orElse(ProviderId.NONE);
            LinkManager.this.store.createOrUpdateLink(pid, desc);
        }
    }

    private class InternalStoreDelegate
    implements LinkStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(LinkEvent event) {
            LinkManager.this.post((Event)event);
        }
    }

    private class InternalLinkProviderService
    extends AbstractProviderService<LinkProvider>
    implements LinkProviderService {
        InternalLinkProviderService(LinkProvider provider) {
            super((Provider)provider);
        }

        public void linkDetected(LinkDescription linkDescription) {
            LinkEvent event;
            Preconditions.checkNotNull((Object)linkDescription, (Object)LinkManager.LINK_DESC_NULL);
            this.checkValidity();
            linkDescription = this.validateLink(linkDescription);
            if (linkDescription != null && (event = LinkManager.this.store.createOrUpdateLink(((LinkProvider)this.provider()).id(), linkDescription)) != null) {
                LinkManager.this.log.info("Link {} detected", (Object)linkDescription);
                LinkManager.this.post((Event)event);
            }
        }

        private LinkDescription validateLink(LinkDescription linkDescription) {
            BasicLinkConfig cfg = (BasicLinkConfig)LinkManager.this.networkConfigService.getConfig((Object)LinkKey.linkKey((ConnectPoint)linkDescription.src(), (ConnectPoint)linkDescription.dst()), BasicLinkConfig.class);
            BasicLinkConfig cfgTwo = (BasicLinkConfig)LinkManager.this.networkConfigService.getConfig((Object)LinkKey.linkKey((ConnectPoint)linkDescription.dst(), (ConnectPoint)linkDescription.src()), BasicLinkConfig.class);
            if (LinkManager.this.isAllowed(cfg) && LinkManager.this.isAllowed(cfgTwo)) {
                return BasicLinkOperator.combine(cfg, linkDescription);
            }
            LinkManager.this.log.trace("Link {} is not allowed", (Object)linkDescription);
            return null;
        }

        public void linkVanished(LinkDescription linkDescription) {
            Preconditions.checkNotNull((Object)linkDescription, (Object)LinkManager.LINK_DESC_NULL);
            this.checkValidity();
            ConnectPoint src = linkDescription.src();
            ConnectPoint dst = linkDescription.dst();
            LinkEvent event = LinkManager.this.store.removeOrDownLink(src, dst);
            if (event != null) {
                LinkManager.this.log.info("Link {} vanished", (Object)linkDescription);
                LinkManager.this.post((Event)event);
            }
        }

        public void linksVanished(ConnectPoint connectPoint) {
            Preconditions.checkNotNull((Object)connectPoint, (Object)"Connect point cannot be null");
            this.checkValidity();
            LinkManager.this.log.debug("Links for connection point {} vanished", (Object)connectPoint);
            LinkManager.this.removeLinks(LinkManager.this.getLinks(connectPoint), true);
        }

        public void linksVanished(DeviceId deviceId) {
            Preconditions.checkNotNull((Object)deviceId, (Object)LinkManager.DEVICE_ID_NULL);
            this.checkValidity();
            LinkManager.this.log.debug("Links for device {} vanished", (Object)deviceId);
            LinkManager.this.removeLinks(LinkManager.this.getDeviceLinks(deviceId), true);
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            if (event.type() == DeviceEvent.Type.DEVICE_REMOVED) {
                LinkManager.this.removeLinks(((Device)event.subject()).id());
            } else if (event.type() == DeviceEvent.Type.PORT_REMOVED) {
                LinkManager.this.removeLinks(new ConnectPoint((ElementId)((Device)event.subject()).id(), event.port().number()));
            }
        }
    }
}

