/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.link.impl;

import com.google.common.base.Preconditions;
import java.time.Duration;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Link;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.ConfigOperator;
import org.onosproject.net.config.basics.BasicLinkConfig;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicLinkOperator
implements ConfigOperator {
    private static final long DEF_BANDWIDTH = -1L;
    private static final double DEF_METRIC = -1.0;
    private static final Duration DEF_DURATION = Duration.ofNanos(-1L);
    private static final Logger log = LoggerFactory.getLogger(BasicLinkOperator.class);

    private BasicLinkOperator() {
    }

    public static LinkDescription combine(BasicLinkConfig cfg, LinkDescription descr) {
        if (cfg == null) {
            return descr;
        }
        Link.Type type = descr.type();
        if (cfg.type() != type) {
            type = cfg.type();
        }
        SparseAnnotations sa = BasicLinkOperator.combine(cfg, descr.annotations());
        return new DefaultLinkDescription(descr.src(), descr.dst(), type, new SparseAnnotations[]{sa});
    }

    public static SparseAnnotations combine(BasicLinkConfig cfg, SparseAnnotations an) {
        DefaultAnnotations.Builder b = DefaultAnnotations.builder();
        if (cfg.metric() != -1.0) {
            b.set("metric", String.valueOf(cfg.metric()));
        }
        if (!cfg.latency().equals(DEF_DURATION)) {
            b.set("latency", cfg.latency().toString());
        }
        if (cfg.bandwidth() != -1L) {
            b.set("bandwidth", String.valueOf(cfg.bandwidth()));
        }
        if (cfg.isDurable() != null) {
            b.set("durable", String.valueOf(cfg.isDurable()));
        }
        return DefaultAnnotations.union((SparseAnnotations)an, (SparseAnnotations)b.build());
    }

    public static LinkDescription descriptionOf(ConnectPoint src, ConnectPoint dst, Link link) {
        Preconditions.checkNotNull((Object)src, (Object)"Must supply a source endpoint");
        Preconditions.checkNotNull((Object)dst, (Object)"Must supply a destination endpoint");
        Preconditions.checkNotNull((Object)link, (Object)"Must supply a link");
        return new DefaultLinkDescription(src, dst, link.type(), link.isExpected(), new SparseAnnotations[]{(SparseAnnotations)link.annotations()});
    }

    public static LinkDescription descriptionOf(ConnectPoint src, ConnectPoint dst, BasicLinkConfig link) {
        Preconditions.checkNotNull((Object)src, (Object)"Must supply a source endpoint");
        Preconditions.checkNotNull((Object)dst, (Object)"Must supply a destination endpoint");
        Preconditions.checkNotNull((Object)link, (Object)"Must supply a link config");
        boolean expected = link.isAllowed();
        return new DefaultLinkDescription(src, dst, link.type(), expected, new SparseAnnotations[]{BasicLinkOperator.combine(link, DefaultAnnotations.EMPTY)});
    }
}

