/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.key.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.EventSink;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.key.DeviceKeyAdminService;
import org.onosproject.net.key.DeviceKeyEvent;
import org.onosproject.net.key.DeviceKeyId;
import org.onosproject.net.key.DeviceKeyListener;
import org.onosproject.net.key.DeviceKeyService;
import org.onosproject.net.key.DeviceKeyStore;
import org.onosproject.net.key.DeviceKeyStoreDelegate;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DeviceKeyManager
extends AbstractListenerManager<DeviceKeyEvent, DeviceKeyListener>
implements DeviceKeyService,
DeviceKeyAdminService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private DeviceKeyStoreDelegate delegate = arg_0 -> ((DeviceKeyManager)this).post(arg_0);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceKeyStore store;

    @Activate
    public void activate() {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(DeviceKeyEvent.class, (EventSink)this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(DeviceKeyEvent.class);
        this.log.info("Stopped");
    }

    public void addKey(DeviceKey deviceKey) {
        Preconditions.checkNotNull((Object)deviceKey, (Object)"Device key cannot be null");
        this.store.createOrUpdateDeviceKey(deviceKey);
    }

    public void removeKey(DeviceKeyId deviceKeyId) {
        Preconditions.checkNotNull((Object)deviceKeyId, (Object)"Device key identifier cannot be null");
        this.store.deleteDeviceKey(deviceKeyId);
    }

    public Collection<DeviceKey> getDeviceKeys() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_KEY_READ);
        return this.store.getDeviceKeys();
    }

    public DeviceKey getDeviceKey(DeviceKeyId deviceKeyId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_KEY_READ);
        Preconditions.checkNotNull((Object)deviceKeyId, (Object)"Device key identifier cannot be null");
        return this.store.getDeviceKey(deviceKeyId);
    }

    protected void bindStore(DeviceKeyStore deviceKeyStore) {
        this.store = deviceKeyStore;
    }

    protected void unbindStore(DeviceKeyStore deviceKeyStore) {
        if (this.store == deviceKeyStore) {
            this.store = null;
        }
    }
}

