/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.phase;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.impl.IntentProcessor;
import org.onosproject.net.intent.impl.phase.Failed;
import org.onosproject.net.intent.impl.phase.IntentProcessPhase;
import org.onosproject.net.intent.impl.phase.Withdrawing;
import org.onosproject.net.intent.impl.phase.Withdrawn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WithdrawRequest
implements IntentProcessPhase {
    private static final Logger log = LoggerFactory.getLogger(WithdrawRequest.class);
    private final IntentProcessor processor;
    private final IntentData data;
    private final Optional<IntentData> stored;

    WithdrawRequest(IntentProcessor processor, IntentData intentData, Optional<IntentData> stored) {
        this.processor = (IntentProcessor)Preconditions.checkNotNull((Object)processor);
        this.data = (IntentData)Preconditions.checkNotNull((Object)intentData);
        this.stored = (Optional)Preconditions.checkNotNull(stored);
    }

    @Override
    public Optional<IntentProcessPhase> execute() {
        IntentProcessPhase.transferErrorCount(this.data, this.stored);
        if (!this.stored.isPresent() || this.stored.get().installables().isEmpty()) {
            switch (this.data.request()) {
                case INSTALL_REQ: {
                    log.warn("{} was requested to withdraw during installation?", (Object)this.data.intent());
                    return Optional.of(new Failed(this.data));
                }
            }
            return Optional.of(new Withdrawn(this.data));
        }
        return Optional.of(new Withdrawing(this.processor, new IntentData(this.data, this.stored.get().installables())));
    }
}

