/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.phase;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.impl.phase.FinalIntentProcessPhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PurgeRequest
extends FinalIntentProcessPhase {
    private static final Logger log = LoggerFactory.getLogger(PurgeRequest.class);
    private final IntentData data;
    private final Optional<IntentData> stored;

    PurgeRequest(IntentData intentData, Optional<IntentData> stored) {
        this.data = (IntentData)Preconditions.checkNotNull((Object)intentData);
        this.stored = (Optional)Preconditions.checkNotNull(stored);
    }

    private boolean shouldAcceptPurge() {
        if (!this.stored.isPresent()) {
            log.info("Purge for intent {}, but intent is not present", (Object)this.data.key());
            return true;
        }
        IntentData storedData = this.stored.get();
        if (storedData.state() == IntentState.WITHDRAWN || storedData.state() == IntentState.FAILED) {
            return true;
        }
        log.info("Purge for intent {} is rejected because intent state is {}", (Object)this.data.key(), (Object)storedData.state());
        return false;
    }

    @Override
    public IntentData data() {
        if (this.shouldAcceptPurge()) {
            return this.data;
        }
        return this.stored.get();
    }
}

