/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.phase;

import java.util.Objects;
import java.util.Optional;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.impl.IntentProcessor;
import org.onosproject.net.intent.impl.phase.Failed;
import org.onosproject.net.intent.impl.phase.FinalIntentProcessPhase;
import org.onosproject.net.intent.impl.phase.InstallRequest;
import org.onosproject.net.intent.impl.phase.PurgeRequest;
import org.onosproject.net.intent.impl.phase.WithdrawRequest;

public interface IntentProcessPhase {
    public Optional<IntentProcessPhase> execute();

    public static IntentProcessPhase newInitialPhase(IntentProcessor processor, IntentData data, IntentData current) {
        switch (data.request()) {
            case INSTALL_REQ: {
                return new InstallRequest(processor, data, Optional.ofNullable(current));
            }
            case WITHDRAW_REQ: {
                return new WithdrawRequest(processor, data, Optional.ofNullable(current));
            }
            case PURGE_REQ: {
                return new PurgeRequest(data, Optional.ofNullable(current));
            }
        }
        return new Failed(data);
    }

    public static FinalIntentProcessPhase process(IntentProcessPhase initial) {
        Optional<IntentProcessPhase> currentPhase = Optional.of(initial);
        IntentProcessPhase previousPhase = initial;
        while (currentPhase.isPresent()) {
            previousPhase = currentPhase.get();
            currentPhase = previousPhase.execute();
        }
        return (FinalIntentProcessPhase)previousPhase;
    }

    public static void transferErrorCount(IntentData data, Optional<IntentData> stored) {
        stored.ifPresent(storedData -> {
            if (Objects.equals(data.intent(), storedData.intent()) && Objects.equals(data.request(), storedData.request())) {
                data.setErrorCount(storedData.errorCount());
            } else {
                data.setErrorCount(0);
            }
        });
    }
}

