/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.phase;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentException;
import org.onosproject.net.intent.impl.IntentProcessor;
import org.onosproject.net.intent.impl.phase.Failed;
import org.onosproject.net.intent.impl.phase.Installing;
import org.onosproject.net.intent.impl.phase.IntentProcessPhase;
import org.onosproject.net.intent.impl.phase.Withdrawing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Compiling
implements IntentProcessPhase {
    private static final Logger log = LoggerFactory.getLogger(Compiling.class);
    private final IntentProcessor processor;
    private final IntentData data;
    private final Optional<IntentData> stored;

    Compiling(IntentProcessor processor, IntentData data, Optional<IntentData> stored) {
        this.processor = (IntentProcessor)Preconditions.checkNotNull((Object)processor);
        this.data = (IntentData)Preconditions.checkNotNull((Object)data);
        this.stored = (Optional)Preconditions.checkNotNull(stored);
    }

    @Override
    public Optional<IntentProcessPhase> execute() {
        try {
            List<Intent> compiled = this.processor.compile(this.data.intent(), this.stored.map(IntentData::installables).orElse(null));
            return Optional.of(new Installing(this.processor, IntentData.compiled((IntentData)this.data, compiled), this.stored));
        }
        catch (IntentException e) {
            log.warn("Unable to compile intent {} due to:", (Object)this.data.intent(), (Object)e);
            if (this.stored.filter(x -> !x.installables().isEmpty()).isPresent()) {
                return Optional.of(new Withdrawing(this.processor, new IntentData(this.data, this.stored.get().installables())));
            }
            return Optional.of(new Failed(this.data));
        }
    }
}

