/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.installer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointDescription;
import org.onosproject.net.behaviour.protection.ProtectionConfig;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentException;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.IntentInstallCoordinator;
import org.onosproject.net.intent.IntentInstaller;
import org.onosproject.net.intent.IntentOperationContext;
import org.onosproject.net.intent.ObjectiveTrackerService;
import org.onosproject.net.intent.ProtectionEndpointIntent;
import org.onosproject.net.intent.impl.IntentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ProtectionEndpointIntentInstaller
implements IntentInstaller<ProtectionEndpointIntent> {
    private static final String CONFIG_FAILED = "Config operation unsuccessful, expected %s, actual %s.";
    private final Logger log = LoggerFactory.getLogger(IntentManager.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentExtensionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    NetworkConfigService networkConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    IntentInstallCoordinator intentInstallCoordinator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    ObjectiveTrackerService trackerService;

    @Activate
    public void activate() {
        this.intentExtensionService.registerInstaller(ProtectionEndpointIntent.class, (IntentInstaller)this);
    }

    @Deactivate
    public void deactivated() {
        this.intentExtensionService.unregisterInstaller(ProtectionEndpointIntent.class);
    }

    public void apply(IntentOperationContext<ProtectionEndpointIntent> context) {
        IntentData intentData;
        Optional toUninstall = context.toUninstall();
        Optional toInstall = context.toInstall();
        List uninstallIntents = context.intentsToUninstall();
        List installIntents = context.intentsToInstall();
        if (!toInstall.isPresent() && !toUninstall.isPresent()) {
            this.intentInstallCoordinator.intentInstallSuccess(context);
            return;
        }
        if (toUninstall.isPresent()) {
            intentData = (IntentData)toUninstall.get();
            this.trackerService.removeTrackedResources(intentData.key(), intentData.intent().resources());
            uninstallIntents.forEach(installable -> this.trackerService.removeTrackedResources(intentData.intent().key(), installable.resources()));
        }
        if (toInstall.isPresent()) {
            intentData = (IntentData)toInstall.get();
            this.trackerService.addTrackedResources(intentData.key(), intentData.intent().resources());
            installIntents.forEach(installable -> this.trackerService.addTrackedResources(intentData.key(), installable.resources()));
        }
        ArrayList<Stage> stages = new ArrayList<Stage>();
        stages.add(new Stage(uninstallIntents.stream().map(i -> Pair.of((Object)i, (Object)IntentInstaller.Direction.REMOVE)).collect(Collectors.toList())));
        stages.add(new Stage(installIntents.stream().map(i -> Pair.of((Object)i, (Object)IntentInstaller.Direction.ADD)).collect(Collectors.toList())));
        for (Stage stage : stages) {
            this.log.debug("applying Stage {}", (Object)stage);
            try {
                stage.apply();
                stage.listeners().forEach(arg_0 -> ((NetworkConfigService)this.networkConfigService).removeListener(arg_0));
            }
            catch (IntentException e) {
                this.log.error("Stage {} failed, reason: {}", (Object)stage, (Object)e.toString());
                this.intentInstallCoordinator.intentInstallFailed(context);
                return;
            }
        }
        this.intentInstallCoordinator.intentInstallSuccess(context);
    }

    protected void bindIntentExtensionService(IntentExtensionService intentExtensionService) {
        this.intentExtensionService = intentExtensionService;
    }

    protected void unbindIntentExtensionService(IntentExtensionService intentExtensionService) {
        if (this.intentExtensionService == intentExtensionService) {
            this.intentExtensionService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    protected void bindIntentInstallCoordinator(IntentInstallCoordinator intentInstallCoordinator) {
        this.intentInstallCoordinator = intentInstallCoordinator;
    }

    protected void unbindIntentInstallCoordinator(IntentInstallCoordinator intentInstallCoordinator) {
        if (this.intentInstallCoordinator == intentInstallCoordinator) {
            this.intentInstallCoordinator = null;
        }
    }

    protected void bindTrackerService(ObjectiveTrackerService objectiveTrackerService) {
        this.trackerService = objectiveTrackerService;
    }

    protected void unbindTrackerService(ObjectiveTrackerService objectiveTrackerService) {
        if (this.trackerService == objectiveTrackerService) {
            this.trackerService = null;
        }
    }

    private final class Stage {
        private final Collection<Pair<ProtectionEndpointIntent, IntentInstaller.Direction>> ops;
        private final Set<NetworkConfigListener> listeners = Sets.newHashSet();

        Stage(Collection<Pair<ProtectionEndpointIntent, IntentInstaller.Direction>> ops) {
            this.ops = (Collection)Preconditions.checkNotNull(ops);
        }

        void apply() {
            this.ops.stream().map(op -> this.applyOp((IntentInstaller.Direction)op.getRight(), (ProtectionEndpointIntent)op.getLeft())).forEach(future -> {
                try {
                    future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new IntentException(e.toString());
                }
            });
        }

        private CompletableFuture<Void> applyOp(IntentInstaller.Direction dir, ProtectionEndpointIntent intent) {
            ProtectionEndpointIntentInstaller.this.log.trace("applying {}: {}", (Object)dir, (Object)intent);
            if (dir == IntentInstaller.Direction.REMOVE) {
                ProtectionConfigListener listener = new ProtectionConfigListener((Set<NetworkConfigEvent.Type>)ImmutableSet.of((Object)NetworkConfigEvent.Type.CONFIG_REMOVED), intent.deviceId());
                ProtectionEndpointIntentInstaller.this.networkConfigService.addListener((EventListener)listener);
                this.listeners.add(listener);
                ProtectionEndpointIntentInstaller.this.networkConfigService.removeConfig((Object)intent.deviceId(), ProtectionConfig.class);
                return listener.completableFuture();
            }
            ProtectedTransportEndpointDescription description = intent.description();
            ProtectionConfig cfg = new ProtectionConfig(intent.deviceId());
            cfg.fingerprint(description.fingerprint());
            cfg.peer(description.peer());
            cfg.paths(description.paths());
            ProtectionConfigListener listener = new ProtectionConfigListener((Set<NetworkConfigEvent.Type>)ImmutableSet.of((Object)NetworkConfigEvent.Type.CONFIG_ADDED, (Object)NetworkConfigEvent.Type.CONFIG_UPDATED), intent.deviceId());
            ProtectionEndpointIntentInstaller.this.networkConfigService.addListener((EventListener)listener);
            this.listeners.add(listener);
            ProtectionEndpointIntentInstaller.this.networkConfigService.applyConfig((Object)intent.deviceId(), ProtectionConfig.class, cfg.node());
            return listener.completableFuture();
        }

        public String toString() {
            return this.ops.toString();
        }

        public Set<NetworkConfigListener> listeners() {
            return this.listeners;
        }

        class ProtectionConfigListener
        implements NetworkConfigListener {
            private CompletableFuture<Void> completableFuture = new CompletableFuture();
            private Set<NetworkConfigEvent.Type> listenTypes;
            private DeviceId listenDevice;

            public ProtectionConfigListener(Set<NetworkConfigEvent.Type> listenTypes, DeviceId listenDevice) {
                this.listenTypes = listenTypes;
                this.listenDevice = listenDevice;
            }

            public void event(NetworkConfigEvent event) {
                if (!event.subject().equals(this.listenDevice)) {
                    return;
                }
                if (!this.listenTypes.contains(event.type())) {
                    String errorMsg = String.format(ProtectionEndpointIntentInstaller.CONFIG_FAILED, this.listenTypes.toString(), event.type());
                    this.completableFuture.completeExceptionally((Throwable)new IntentException(errorMsg));
                } else {
                    this.completableFuture.complete(null);
                }
            }

            public CompletableFuture<Void> completableFuture() {
                return this.completableFuture;
            }
        }
    }
}

