/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.installer;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.IntentInstallCoordinator;
import org.onosproject.net.intent.IntentInstaller;
import org.onosproject.net.intent.IntentOperationContext;
import org.onosproject.net.intent.ObjectiveTrackerService;
import org.onosproject.net.intent.impl.IntentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class FlowRuleIntentInstaller
implements IntentInstaller<FlowRuleIntent> {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentExtensionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ObjectiveTrackerService trackerService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentInstallCoordinator intentInstallCoordinator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    protected final Logger log = LoggerFactory.getLogger(IntentManager.class);

    @Activate
    public void activate() {
        this.intentExtensionService.registerInstaller(FlowRuleIntent.class, (IntentInstaller)this);
    }

    @Deactivate
    public void deactivated() {
        this.intentExtensionService.unregisterInstaller(FlowRuleIntent.class);
    }

    public void apply(final IntentOperationContext<FlowRuleIntent> context) {
        List<FlowRule> flowRulesToInstall;
        List<FlowRule> flowRulesToUninstall;
        Optional toUninstall = context.toUninstall();
        Optional toInstall = context.toInstall();
        if (!toInstall.isPresent() && !toUninstall.isPresent()) {
            this.intentInstallCoordinator.intentInstallSuccess(context);
            return;
        }
        List uninstallIntents = context.intentsToUninstall();
        List installIntents = context.intentsToInstall();
        if (toUninstall.isPresent()) {
            this.trackIntentResources((IntentData)toUninstall.get(), uninstallIntents, IntentInstaller.Direction.REMOVE);
            flowRulesToUninstall = uninstallIntents.stream().map(FlowRuleIntent::flowRules).flatMap(Collection::stream).collect(Collectors.toList());
        } else {
            flowRulesToUninstall = Collections.emptyList();
        }
        if (toInstall.isPresent()) {
            this.trackIntentResources((IntentData)toInstall.get(), installIntents, IntentInstaller.Direction.ADD);
            flowRulesToInstall = installIntents.stream().map(FlowRuleIntent::flowRules).flatMap(Collection::stream).collect(Collectors.toList());
        } else {
            flowRulesToInstall = Collections.emptyList();
        }
        List dontUninstall = flowRulesToUninstall.stream().filter(flowRule -> flowRulesToInstall.stream().anyMatch(arg_0 -> ((FlowRule)flowRule).equals(arg_0))).collect(Collectors.toList());
        List dontTouch = flowRulesToInstall.stream().filter(flowRule -> flowRulesToUninstall.stream().anyMatch(arg_0 -> ((FlowRule)flowRule).exactMatch(arg_0))).collect(Collectors.toList());
        flowRulesToUninstall.removeAll(dontUninstall);
        flowRulesToUninstall.removeAll(dontTouch);
        flowRulesToInstall.removeAll(dontTouch);
        if (flowRulesToInstall.isEmpty() && flowRulesToUninstall.isEmpty()) {
            this.intentInstallCoordinator.intentInstallSuccess(context);
            return;
        }
        FlowRuleOperations.Builder builder = FlowRuleOperations.builder();
        flowRulesToInstall.forEach(arg_0 -> ((FlowRuleOperations.Builder)builder).add(arg_0));
        flowRulesToUninstall.forEach(arg_0 -> ((FlowRuleOperations.Builder)builder).remove(arg_0));
        FlowRuleOperationsContext flowRuleOperationsContext = new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                FlowRuleIntentInstaller.this.intentInstallCoordinator.intentInstallSuccess(context);
            }

            public void onError(FlowRuleOperations ops) {
                FlowRuleIntentInstaller.this.intentInstallCoordinator.intentInstallFailed(context);
            }
        };
        FlowRuleOperations operations = builder.build(flowRuleOperationsContext);
        this.log.debug("applying intent {} -> {} with {} rules: {}", new Object[]{toUninstall.map(x -> x.key().toString()).orElse("<empty>"), toInstall.map(x -> x.key().toString()).orElse("<empty>"), operations.stages().stream().mapToLong(Set::size).sum(), operations.stages()});
        this.flowRuleService.apply(operations);
    }

    private void trackIntentResources(IntentData intentData, List<FlowRuleIntent> intentsToApply, IntentInstaller.Direction direction) {
        switch (direction) {
            case ADD: {
                this.trackerService.addTrackedResources(intentData.key(), intentData.intent().resources());
                intentsToApply.forEach(installable -> this.trackerService.addTrackedResources(intentData.key(), installable.resources()));
                break;
            }
            case REMOVE: {
                this.trackerService.removeTrackedResources(intentData.key(), intentData.intent().resources());
                intentsToApply.forEach(installable -> this.trackerService.removeTrackedResources(intentData.intent().key(), installable.resources()));
                break;
            }
            default: {
                this.log.warn("Unknown resource tracking direction.");
            }
        }
    }

    protected void bindIntentExtensionService(IntentExtensionService intentExtensionService) {
        this.intentExtensionService = intentExtensionService;
    }

    protected void unbindIntentExtensionService(IntentExtensionService intentExtensionService) {
        if (this.intentExtensionService == intentExtensionService) {
            this.intentExtensionService = null;
        }
    }

    protected void bindTrackerService(ObjectiveTrackerService objectiveTrackerService) {
        this.trackerService = objectiveTrackerService;
    }

    protected void unbindTrackerService(ObjectiveTrackerService objectiveTrackerService) {
        if (this.trackerService == objectiveTrackerService) {
            this.trackerService = null;
        }
    }

    protected void bindIntentInstallCoordinator(IntentInstallCoordinator intentInstallCoordinator) {
        this.intentInstallCoordinator = intentInstallCoordinator;
    }

    protected void unbindIntentInstallCoordinator(IntentInstallCoordinator intentInstallCoordinator) {
        if (this.intentInstallCoordinator == intentInstallCoordinator) {
            this.intentInstallCoordinator = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }
}

