/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.installer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.intent.FlowObjectiveIntent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.IntentInstallCoordinator;
import org.onosproject.net.intent.IntentInstaller;
import org.onosproject.net.intent.IntentOperationContext;
import org.onosproject.net.intent.ObjectiveTrackerService;
import org.onosproject.net.intent.impl.IntentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class FlowObjectiveIntentInstaller
implements IntentInstaller<FlowObjectiveIntent> {
    private static final int OBJECTIVE_RETRY_THRESHOLD = 5;
    private static final String UNSUPPORT_OBJ = "unsupported objective {}";
    private final Logger log = LoggerFactory.getLogger(IntentManager.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentExtensionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ObjectiveTrackerService trackerService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentInstallCoordinator intentInstallCoordinator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;

    @Activate
    public void activate() {
        this.intentExtensionService.registerInstaller(FlowObjectiveIntent.class, (IntentInstaller)this);
    }

    @Deactivate
    public void deactivated() {
        this.intentExtensionService.unregisterInstaller(FlowObjectiveIntent.class);
    }

    public void apply(IntentOperationContext<FlowObjectiveIntent> intentOperationContext) {
        IntentData intentData;
        Objects.requireNonNull(intentOperationContext);
        Optional toUninstall = intentOperationContext.toUninstall();
        Optional toInstall = intentOperationContext.toInstall();
        List uninstallIntents = intentOperationContext.intentsToUninstall();
        List installIntents = intentOperationContext.intentsToInstall();
        if (!toInstall.isPresent() && !toUninstall.isPresent()) {
            this.intentInstallCoordinator.intentInstallSuccess(intentOperationContext);
            return;
        }
        if (toUninstall.isPresent()) {
            intentData = (IntentData)toUninstall.get();
            this.trackerService.removeTrackedResources(intentData.key(), intentData.intent().resources());
            uninstallIntents.forEach(installable -> this.trackerService.removeTrackedResources(intentData.intent().key(), installable.resources()));
        }
        if (toInstall.isPresent()) {
            intentData = (IntentData)toInstall.get();
            this.trackerService.addTrackedResources(intentData.key(), intentData.intent().resources());
            installIntents.forEach(installable -> this.trackerService.addTrackedResources(intentData.key(), installable.resources()));
        }
        FlowObjectiveIntentInstallationContext intentInstallationContext = new FlowObjectiveIntentInstallationContext(intentOperationContext);
        uninstallIntents.stream().map(intent -> this.buildObjectiveContexts((FlowObjectiveIntent)intent, IntentInstaller.Direction.REMOVE)).flatMap(Collection::stream).forEach(context -> {
            context.intentInstallationContext(intentInstallationContext);
            intentInstallationContext.addContext((ObjectiveContext)context);
            intentInstallationContext.addPendingContext((ObjectiveContext)context);
        });
        installIntents.stream().map(intent -> this.buildObjectiveContexts((FlowObjectiveIntent)intent, IntentInstaller.Direction.ADD)).flatMap(Collection::stream).forEach(context -> {
            context.intentInstallationContext(intentInstallationContext);
            intentInstallationContext.addContext((ObjectiveContext)context);
            intentInstallationContext.addNextPendingContext((ObjectiveContext)context);
        });
        intentInstallationContext.apply();
    }

    private Set<FlowObjectiveInstallationContext> buildObjectiveContexts(FlowObjectiveIntent intent, IntentInstaller.Direction direction) {
        Objects.requireNonNull(intent);
        Objects.requireNonNull(direction);
        HashSet contexts = Sets.newHashSet();
        int size = intent.objectives().size();
        List objectives = intent.objectives();
        List deviceIds = intent.devices();
        if (direction == IntentInstaller.Direction.ADD) {
            for (int i = 0; i < size; ++i) {
                Objective objective = (Objective)objectives.get(i);
                DeviceId deviceId = (DeviceId)deviceIds.get(i);
                FlowObjectiveInstallationContext ctx = this.buildObjectiveContext(objective, deviceId, direction);
                contexts.add(ctx);
            }
            return contexts;
        }
        for (int i = 0; i < size; ++i) {
            Objective objective = (Objective)intent.objectives().get(i);
            DeviceId deviceId = (DeviceId)intent.devices().get(i);
            if (objective instanceof FilteringObjective) {
                FlowObjectiveInstallationContext ctx = this.buildObjectiveContext(objective, deviceId, direction);
                contexts.add(ctx);
                continue;
            }
            if (objective instanceof NextObjective) continue;
            if (objective instanceof ForwardingObjective) {
                FlowObjectiveInstallationContext fwdCtx = this.buildObjectiveContext(objective, deviceId, direction);
                ForwardingObjective fwd = (ForwardingObjective)objective;
                NextObjective nxt = null;
                Integer nextId = fwd.nextId();
                if (nextId != null) {
                    for (int j = 0; j < size; ++j) {
                        if (((Objective)objectives.get(j)).id() != nextId.intValue()) continue;
                        nxt = (NextObjective)objectives.get(j);
                        break;
                    }
                    if (nxt != null) {
                        FlowObjectiveInstallationContext nxtCtx = this.buildObjectiveContext((Objective)nxt, deviceId, direction);
                        fwdCtx.nextContext(nxtCtx);
                    }
                }
                contexts.add(fwdCtx);
                continue;
            }
            this.log.warn(UNSUPPORT_OBJ, (Object)objective);
        }
        return contexts;
    }

    private FlowObjectiveInstallationContext buildObjectiveContext(Objective objective, DeviceId deviceId, IntentInstaller.Direction direction) {
        Objects.requireNonNull(objective);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(direction);
        Objective.Builder builder = objective.copy();
        FlowObjectiveInstallationContext ctx = new FlowObjectiveInstallationContext();
        switch (direction) {
            case ADD: {
                objective = builder.add((ObjectiveContext)ctx);
                break;
            }
            case REMOVE: {
                objective = builder.remove((ObjectiveContext)ctx);
                break;
            }
        }
        ctx.setObjective(objective, deviceId);
        return ctx;
    }

    protected void bindIntentExtensionService(IntentExtensionService intentExtensionService) {
        this.intentExtensionService = intentExtensionService;
    }

    protected void unbindIntentExtensionService(IntentExtensionService intentExtensionService) {
        if (this.intentExtensionService == intentExtensionService) {
            this.intentExtensionService = null;
        }
    }

    protected void bindTrackerService(ObjectiveTrackerService objectiveTrackerService) {
        this.trackerService = objectiveTrackerService;
    }

    protected void unbindTrackerService(ObjectiveTrackerService objectiveTrackerService) {
        if (this.trackerService == objectiveTrackerService) {
            this.trackerService = null;
        }
    }

    protected void bindIntentInstallCoordinator(IntentInstallCoordinator intentInstallCoordinator) {
        this.intentInstallCoordinator = intentInstallCoordinator;
    }

    protected void unbindIntentInstallCoordinator(IntentInstallCoordinator intentInstallCoordinator) {
        if (this.intentInstallCoordinator == intentInstallCoordinator) {
            this.intentInstallCoordinator = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    class FlowObjectiveIntentInstallationContext {
        private final IntentOperationContext<FlowObjectiveIntent> intentOperationContext;
        final List<ObjectiveContext> contexts = Lists.newArrayList();
        final Set<ObjectiveContext> errorContexts = Sets.newConcurrentHashSet();
        final Set<ObjectiveContext> pendingContexts = Sets.newConcurrentHashSet();
        final Set<ObjectiveContext> nextPendingContexts = Sets.newConcurrentHashSet();

        public FlowObjectiveIntentInstallationContext(IntentOperationContext<FlowObjectiveIntent> intentOperationContext) {
            Objects.requireNonNull(intentOperationContext);
            this.intentOperationContext = intentOperationContext;
        }

        public IntentOperationContext<FlowObjectiveIntent> intentOperationContext() {
            return this.intentOperationContext;
        }

        public void apply() {
            if (this.pendingContexts.isEmpty()) {
                this.moveNextPendingToPending();
            }
            Set<ObjectiveContext> contextsToApply = this.pendingContexts();
            contextsToApply.forEach(ctx -> {
                FlowObjectiveInstallationContext foiCtx = (FlowObjectiveInstallationContext)ctx;
                FlowObjectiveIntentInstaller.this.flowObjectiveService.apply(foiCtx.deviceId, foiCtx.objective);
            });
        }

        public Set<ObjectiveContext> errorContexts() {
            return ImmutableSet.copyOf(this.errorContexts);
        }

        public Set<ObjectiveContext> pendingContexts() {
            return ImmutableSet.copyOf(this.pendingContexts);
        }

        public Set<ObjectiveContext> nextPendingContexts() {
            return ImmutableSet.copyOf(this.nextPendingContexts);
        }

        public void addContext(ObjectiveContext context) {
            Objects.requireNonNull(context);
            this.contexts.add(context);
        }

        public void addNextPendingContext(ObjectiveContext context) {
            Objects.requireNonNull(context);
            this.nextPendingContexts.add(context);
        }

        public void addPendingContext(ObjectiveContext context) {
            Objects.requireNonNull(context);
            this.pendingContexts.add(context);
        }

        public void removePendingContext(ObjectiveContext context) {
            Objects.requireNonNull(context);
            this.pendingContexts.remove(context);
        }

        public void moveNextPendingToPending() {
            this.pendingContexts.addAll(this.nextPendingContexts);
            this.nextPendingContexts.clear();
        }

        public void handleObjectiveError(FlowObjectiveInstallationContext ctx, ObjectiveError error) {
            Objects.requireNonNull(ctx);
            Objects.requireNonNull(error);
            FlowObjectiveIntentInstaller.this.log.debug("Got error(s) when install objective: {}, error: {}, retry: {}", new Object[]{ctx.objective, ctx.error, ctx.retry});
            if (ctx.retryTimes() > 5) {
                ctx.error = ObjectiveError.INSTALLATIONTHRESHOLDEXCEEDED;
                this.pendingContexts.remove(ctx);
                this.errorContexts.add(ctx);
                return;
            }
            ctx.error = null;
            switch (error) {
                case GROUPEXISTS: {
                    if (ctx.objective.op() == Objective.Operation.ADD && ctx.objective instanceof NextObjective) {
                        NextObjective newObj = ((NextObjective.Builder)ctx.objective.copy()).addToExisting((ObjectiveContext)ctx);
                        ctx.setObjective((Objective)newObj, ctx.deviceId);
                        ctx.increaseRetryValue();
                        FlowObjectiveIntentInstaller.this.flowObjectiveService.apply(ctx.deviceId, ctx.objective);
                        break;
                    }
                    this.pendingContexts.remove(ctx);
                    this.errorContexts.add(ctx);
                    break;
                }
                case GROUPINSTALLATIONFAILED: {
                    ctx.increaseRetryValue();
                    FlowObjectiveIntentInstaller.this.flowObjectiveService.apply(ctx.deviceId, ctx.objective);
                    break;
                }
                case GROUPMISSING: {
                    if (ctx.objective.op() == Objective.Operation.ADD_TO_EXISTING) {
                        NextObjective newObj = (NextObjective)ctx.objective.copy().add((ObjectiveContext)ctx);
                        ctx.setObjective((Objective)newObj, ctx.deviceId);
                        ctx.increaseRetryValue();
                        FlowObjectiveIntentInstaller.this.flowObjectiveService.apply(ctx.deviceId, ctx.objective);
                        break;
                    }
                    if (ctx.objective.op() == Objective.Operation.REMOVE || ctx.objective.op() == Objective.Operation.REMOVE_FROM_EXISTING) {
                        ctx.error = null;
                        this.pendingContexts.remove(ctx);
                        return;
                    }
                    ctx.increaseRetryValue();
                    FlowObjectiveIntentInstaller.this.flowObjectiveService.apply(ctx.deviceId, ctx.objective);
                    break;
                }
                case FLOWINSTALLATIONFAILED: 
                case GROUPREMOVALFAILED: 
                case INSTALLATIONTIMEOUT: {
                    ctx.increaseRetryValue();
                    FlowObjectiveIntentInstaller.this.flowObjectiveService.apply(ctx.deviceId, ctx.objective);
                    break;
                }
                default: {
                    this.pendingContexts.remove(ctx);
                    this.errorContexts.add(ctx);
                }
            }
        }
    }

    class FlowObjectiveInstallationContext
    implements ObjectiveContext {
        private Objective objective;
        private DeviceId deviceId;
        private ObjectiveError error;
        private AtomicInteger retry;
        private FlowObjectiveInstallationContext nextContext;
        private FlowObjectiveIntentInstallationContext intentInstallationContext;

        FlowObjectiveInstallationContext() {
        }

        public void intentInstallationContext(FlowObjectiveIntentInstallationContext intentInstallationContext) {
            Objects.requireNonNull(intentInstallationContext);
            this.intentInstallationContext = intentInstallationContext;
            if (this.nextContext != null) {
                this.nextContext.intentInstallationContext(intentInstallationContext);
            }
        }

        public void nextContext(FlowObjectiveInstallationContext nextContext) {
            Objects.requireNonNull(nextContext);
            this.nextContext = nextContext;
        }

        void setObjective(Objective objective, DeviceId deviceId) {
            Objects.requireNonNull(objective);
            Objects.requireNonNull(deviceId);
            this.objective = objective;
            this.deviceId = deviceId;
            this.error = null;
            this.retry = new AtomicInteger(0);
        }

        int retryTimes() {
            return this.retry.get();
        }

        void increaseRetryValue() {
            this.retry.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finished(ObjectiveError error) {
            FlowObjectiveIntentInstallationContext flowObjectiveIntentInstallationContext = this.intentInstallationContext;
            synchronized (flowObjectiveIntentInstallationContext) {
                if (error != null) {
                    this.error = error;
                    this.intentInstallationContext.handleObjectiveError(this, error);
                } else if (this.nextContext != null) {
                    this.intentInstallationContext.addPendingContext(this.nextContext);
                    FlowObjectiveIntentInstaller.this.flowObjectiveService.apply(this.nextContext.deviceId, this.nextContext.objective);
                    this.intentInstallationContext.removePendingContext(this);
                } else {
                    this.intentInstallationContext.removePendingContext(this);
                }
                if (!this.intentInstallationContext.pendingContexts().isEmpty()) {
                    return;
                }
                if (!this.intentInstallationContext.nextPendingContexts().isEmpty()) {
                    this.intentInstallationContext.moveNextPendingToPending();
                    HashSet contextsToApply = Sets.newHashSet(this.intentInstallationContext.pendingContexts());
                    contextsToApply.forEach(ctx -> {
                        FlowObjectiveInstallationContext foiCtx = (FlowObjectiveInstallationContext)ctx;
                        FlowObjectiveIntentInstaller.this.flowObjectiveService.apply(foiCtx.deviceId, foiCtx.objective);
                    });
                    return;
                }
                if (this.intentInstallationContext.errorContexts().isEmpty()) {
                    FlowObjectiveIntentInstaller.this.intentInstallCoordinator.intentInstallSuccess(this.intentInstallationContext.intentOperationContext());
                } else {
                    FlowObjectiveIntentInstaller.this.intentInstallCoordinator.intentInstallFailed(this.intentInstallationContext.intentOperationContext());
                }
            }
        }

        public void onSuccess(Objective objective) {
            this.finished(null);
        }

        public void onError(Objective objective, ObjectiveError error) {
            this.finished(error);
        }

        public String toString() {
            return String.format("(%s on %s for %s)", this.error, this.deviceId, this.objective);
        }
    }
}

