/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.installer;

import java.util.List;
import java.util.Optional;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.domain.DomainIntent;
import org.onosproject.net.domain.DomainIntentOperations;
import org.onosproject.net.domain.DomainIntentOperationsContext;
import org.onosproject.net.domain.DomainIntentService;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.IntentInstallCoordinator;
import org.onosproject.net.intent.IntentInstaller;
import org.onosproject.net.intent.IntentOperationContext;
import org.onosproject.net.intent.ObjectiveTrackerService;
import org.onosproject.net.intent.impl.IntentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class DomainIntentInstaller
implements IntentInstaller<DomainIntent> {
    private final Logger log = LoggerFactory.getLogger(IntentManager.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentExtensionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ObjectiveTrackerService trackerService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentInstallCoordinator intentInstallCoordinator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DomainIntentService domainIntentService;

    @Activate
    public void activated() {
        this.intentExtensionService.registerInstaller(DomainIntent.class, (IntentInstaller)this);
    }

    @Deactivate
    public void deactivated() {
        this.intentExtensionService.unregisterInstaller(DomainIntent.class);
    }

    public void apply(final IntentOperationContext<DomainIntent> context) {
        IntentData intentData;
        Optional toUninstall = context.toUninstall();
        Optional toInstall = context.toInstall();
        List uninstallIntents = context.intentsToUninstall();
        List installIntents = context.intentsToInstall();
        if (!toInstall.isPresent() && !toUninstall.isPresent()) {
            this.intentInstallCoordinator.intentInstallSuccess(context);
            return;
        }
        if (toUninstall.isPresent()) {
            intentData = (IntentData)toUninstall.get();
            this.trackerService.removeTrackedResources(intentData.key(), intentData.intent().resources());
            uninstallIntents.forEach(installable -> this.trackerService.removeTrackedResources(intentData.intent().key(), installable.resources()));
        }
        if (toInstall.isPresent()) {
            intentData = (IntentData)toInstall.get();
            this.trackerService.addTrackedResources(intentData.key(), intentData.intent().resources());
            installIntents.forEach(installable -> this.trackerService.addTrackedResources(intentData.key(), installable.resources()));
        }
        DomainIntentOperations.Builder builder = DomainIntentOperations.builder();
        uninstallIntents.forEach(arg_0 -> ((DomainIntentOperations.Builder)builder).remove(arg_0));
        installIntents.forEach(arg_0 -> ((DomainIntentOperations.Builder)builder).add(arg_0));
        DomainIntentOperationsContext domainOperationsContext = new DomainIntentOperationsContext(){

            public void onSuccess(DomainIntentOperations idops) {
                DomainIntentInstaller.this.intentInstallCoordinator.intentInstallSuccess(context);
            }

            public void onError(DomainIntentOperations idos) {
                DomainIntentInstaller.this.intentInstallCoordinator.intentInstallFailed(context);
            }
        };
        this.log.debug("submitting domain intent {} -> {}", (Object)toUninstall.map(x -> x.key().toString()).orElse("<empty>"), (Object)toInstall.map(x -> x.key().toString()).orElse("<empty>"));
        this.domainIntentService.sumbit(builder.build(domainOperationsContext));
    }

    protected void bindIntentExtensionService(IntentExtensionService intentExtensionService) {
        this.intentExtensionService = intentExtensionService;
    }

    protected void unbindIntentExtensionService(IntentExtensionService intentExtensionService) {
        if (this.intentExtensionService == intentExtensionService) {
            this.intentExtensionService = null;
        }
    }

    protected void bindTrackerService(ObjectiveTrackerService objectiveTrackerService) {
        this.trackerService = objectiveTrackerService;
    }

    protected void unbindTrackerService(ObjectiveTrackerService objectiveTrackerService) {
        if (this.trackerService == objectiveTrackerService) {
            this.trackerService = null;
        }
    }

    protected void bindIntentInstallCoordinator(IntentInstallCoordinator intentInstallCoordinator) {
        this.intentInstallCoordinator = intentInstallCoordinator;
    }

    protected void unbindIntentInstallCoordinator(IntentInstallCoordinator intentInstallCoordinator) {
        if (this.intentInstallCoordinator == intentInstallCoordinator) {
            this.intentInstallCoordinator = null;
        }
    }

    protected void bindDomainIntentService(DomainIntentService domainIntentService) {
        this.domainIntentService = domainIntentService;
    }

    protected void unbindDomainIntentService(DomainIntentService domainIntentService) {
        if (this.domainIntentService == domainIntentService) {
            this.domainIntentService = null;
        }
    }
}

