/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkIntent;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualNetworkStore;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompilationException;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.impl.compiler.ConnectivityIntentCompiler;
import org.onosproject.net.topology.TopologyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class VirtualNetworkIntentCompiler
extends ConnectivityIntentCompiler<VirtualNetworkIntent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String NETWORK_ID = "networkId=";
    protected static final String KEY_FORMAT = "{networkId=%s, src=%s, dst=%s}";
    protected ServiceDirectory serviceDirectory = new DefaultServiceDirectory();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualNetworkService manager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualNetworkStore store;

    @Activate
    public void activate() {
        this.intentManager.registerCompiler(VirtualNetworkIntent.class, (IntentCompiler)this);
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(VirtualNetworkIntent.class);
    }

    public List<Intent> compile(VirtualNetworkIntent intent, List<Intent> installable) {
        List links;
        this.log.debug("Compiling intent: " + intent);
        ArrayList<Intent> intents = new ArrayList<Intent>();
        Optional path = this.getPaths(intent).stream().findFirst();
        if (path != null && path.isPresent()) {
            links = ((Path)path.get()).links();
            Link firstLink = (Link)links.get(0);
            if (!intent.ingressPoint().equals((Object)firstLink.src())) {
                intents.add(this.createPtPtIntent(intent, intent.ingressPoint(), firstLink.src()));
            }
            Link lastLink = (Link)links.get(links.size() - 1);
            if (!intent.egressPoint().equals((Object)lastLink.dst())) {
                intents.add(this.createPtPtIntent(intent, lastLink.dst(), intent.egressPoint()));
            }
        } else {
            throw new IntentCompilationException("Unable to find a path for intent " + intent);
        }
        int[] index = new int[]{0};
        links.forEach(link -> {
            intents.add(this.createPtPtIntent(intent, link.src(), link.dst()));
            if (index[0] > 0) {
                Link previousLink = (Link)links.get(index[0] - 1);
                intents.add(this.createPtPtIntent(intent, previousLink.dst(), link.src()));
            }
            index[0] = index[0] + 1;
        });
        return intents;
    }

    private Set<Path> getPaths(VirtualNetworkIntent intent) {
        TopologyService topologyService = (TopologyService)this.manager.get(intent.networkId(), TopologyService.class);
        if (topologyService == null) {
            throw new IntentCompilationException("topologyService is null");
        }
        return topologyService.getPaths(topologyService.currentTopology(), intent.ingressPoint().deviceId(), intent.egressPoint().deviceId());
    }

    private static Key encodeKey(NetworkId networkId, ApplicationId applicationId, ConnectPoint src, ConnectPoint dst) {
        String key = String.format(KEY_FORMAT, networkId, src, dst);
        return Key.of((String)key, (ApplicationId)applicationId);
    }

    private Intent createPtPtIntent(VirtualNetworkIntent intent, ConnectPoint src, ConnectPoint dst) {
        ConnectPoint ingressPoint = this.mapVirtualToPhysicalPort(intent.networkId(), src);
        ConnectPoint egressPoint = this.mapVirtualToPhysicalPort(intent.networkId(), dst);
        Key intentKey = VirtualNetworkIntentCompiler.encodeKey(intent.networkId(), intent.appId(), ingressPoint, egressPoint);
        PointToPointIntent physicalIntent = PointToPointIntent.builder().key(intentKey).appId(intent.appId()).ingressPoint(ingressPoint).egressPoint(egressPoint).constraints(intent.constraints()).selector(intent.selector()).treatment(intent.treatment()).resourceGroup(intent.resourceGroup()).build();
        this.log.debug("Submitting physical intent: " + physicalIntent);
        this.intentService.submit((Intent)physicalIntent);
        this.store.addTunnelId((Intent)intent, TunnelId.valueOf((String)physicalIntent.key().toString()));
        return physicalIntent;
    }

    private ConnectPoint mapVirtualToPhysicalPort(NetworkId networkId, ConnectPoint virtualCp) {
        Set ports = this.manager.getVirtualPorts(networkId, virtualCp.deviceId());
        for (VirtualPort port : ports) {
            if (!port.element().id().equals(virtualCp.elementId()) || !port.number().equals((Object)virtualCp.port())) continue;
            return new ConnectPoint((ElementId)port.realizedBy().deviceId(), port.realizedBy().port());
        }
        return null;
    }

    protected void bindManager(VirtualNetworkService virtualNetworkService) {
        this.manager = virtualNetworkService;
    }

    protected void unbindManager(VirtualNetworkService virtualNetworkService) {
        if (this.manager == virtualNetworkService) {
            this.manager = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindStore(VirtualNetworkStore virtualNetworkStore) {
        this.store = virtualNetworkStore;
    }

    protected void unbindStore(VirtualNetworkStore virtualNetworkStore) {
        if (this.store == virtualNetworkStore) {
            this.store = null;
        }
    }
}

