/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.ElementId;
import org.onosproject.net.Path;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentException;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.onosproject.net.intent.constraint.PartialFailureConstraint;
import org.onosproject.net.intent.impl.compiler.ConnectivityIntentCompiler;

@Component(immediate=true)
public class SinglePointToMultiPointIntentCompiler
extends ConnectivityIntentCompiler<SinglePointToMultiPointIntent> {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;

    @Activate
    public void activate() {
        this.intentManager.registerCompiler(SinglePointToMultiPointIntent.class, (IntentCompiler)this);
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(SinglePointToMultiPointIntent.class);
    }

    public List<Intent> compile(SinglePointToMultiPointIntent intent, List<Intent> installable) {
        HashSet links = new HashSet();
        boolean allowMissingPaths = PartialFailureConstraint.intentAllowsPartialFailure((Intent)intent);
        boolean hasPaths = false;
        boolean missingSomePaths = false;
        for (ConnectPoint egressPoint : intent.egressPoints()) {
            if (egressPoint.deviceId().equals((Object)intent.ingressPoint().deviceId())) {
                if (this.deviceService.isAvailable(egressPoint.deviceId())) {
                    hasPaths = true;
                    continue;
                }
                missingSomePaths = true;
                continue;
            }
            Path path = this.getPath((ConnectivityIntent)intent, (ElementId)intent.ingressPoint().deviceId(), (ElementId)egressPoint.deviceId());
            if (path != null) {
                hasPaths = true;
                links.addAll(path.links());
                continue;
            }
            missingSomePaths = true;
        }
        ConnectPoint ingressCP = intent.filteredIngressPoint().connectPoint();
        List egressCPs = intent.filteredEgressPoints().stream().map(fcp -> fcp.connectPoint()).collect(Collectors.toList());
        List<ConnectPoint> pathCPs = links.stream().flatMap(l -> Stream.of(l.src(), l.dst())).collect(Collectors.toList());
        pathCPs.add(ingressCP);
        pathCPs.addAll(egressCPs);
        this.allocateBandwidth((ConnectivityIntent)intent, pathCPs);
        if (!hasPaths) {
            throw new IntentException("Cannot find any path between ingress and egress points.");
        }
        if (!allowMissingPaths && missingSomePaths) {
            throw new IntentException("Missing some paths between ingress and egress points.");
        }
        LinkCollectionIntent result = LinkCollectionIntent.builder().appId(intent.appId()).key(intent.key()).selector(intent.selector()).treatment(intent.treatment()).links(links).filteredIngressPoints((Set)ImmutableSet.of((Object)intent.filteredIngressPoint())).filteredEgressPoints(intent.filteredEgressPoints()).priority(intent.priority()).applyTreatmentOnEgress(true).constraints(intent.constraints()).resourceGroup(intent.resourceGroup()).build();
        return Collections.singletonList(result);
    }

    @Override
    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    @Override
    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

