/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.VlanId;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.ElementId;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.MarkerResource;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointDescription;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompilationException;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.ProtectedTransportIntent;
import org.onosproject.net.intent.ProtectionEndpointIntent;
import org.onosproject.net.intent.impl.compiler.ConnectivityIntentCompiler;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
public class ProtectedTransportIntentCompiler
extends ConnectivityIntentCompiler<ProtectedTransportIntent> {
    private static final String FWD = "fwd";
    private static final String REV = "rev";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;

    @Activate
    public void activate() {
        this.intentManager.registerCompiler(ProtectedTransportIntent.class, (IntentCompiler)this);
        this.log.info("started");
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(ProtectedTransportIntent.class);
        this.log.info("stopped");
    }

    public List<Intent> compile(ProtectedTransportIntent intent, List<Intent> installable) {
        block5: {
            DeviceId did2;
            DeviceId did1;
            block4: {
                this.log.trace("compiling {} {}", (Object)intent, installable);
                did1 = intent.one();
                did2 = intent.two();
                if (Objects.equals(did1, did2)) {
                    this.log.error("0 hop not supported yet.");
                    throw new IntentCompilationException("0 hop not supported yet.");
                }
                List reusable = Optional.ofNullable(installable).orElse((List<Intent>)ImmutableList.of()).stream().filter(this::isIntact).collect(Collectors.toList());
                if (reusable.isEmpty()) break block4;
                if (!reusable.stream().allMatch(ProtectionEndpointIntent.class::isInstance)) break block5;
            }
            return this.createFreshProtectedPaths(intent, did1, did2);
        }
        this.log.warn("Re-computing adding new backup path not supported yet. No-Op.");
        return installable;
    }

    private boolean isIntact(Intent installed) {
        return installed.resources().stream().filter(Link.class::isInstance).map(Link.class::cast).allMatch(this::isLive);
    }

    private boolean isLive(Link link) {
        return link.state() != Link.State.INACTIVE;
    }

    private List<Intent> createFreshProtectedPaths(ProtectedTransportIntent intent, DeviceId did1, DeviceId did2) {
        DisjointPath disjointPath = this.getDisjointPath((ConnectivityIntent)intent, (ElementId)did1, (ElementId)did2);
        if (disjointPath == null || disjointPath.backup() == null) {
            this.log.error("Unable to find disjoint path between {}, {}", (Object)did1, (Object)did2);
            throw new IntentCompilationException("Unable to find disjoint paths.");
        }
        Path primary = disjointPath.primary();
        Path secondary = disjointPath.backup();
        String fingerprint = intent.key().toString();
        Pair<VlanId, VlanId> vlans = this.allocateEach((Intent)intent, primary, secondary, VlanId.class);
        VlanId primaryVlan = (VlanId)vlans.getLeft();
        VlanId secondaryVlan = (VlanId)vlans.getRight();
        ArrayList oneResources = new ArrayList();
        ArrayList twoResources = new ArrayList();
        ArrayList<TransportEndpointDescription> onePaths = new ArrayList<TransportEndpointDescription>();
        onePaths.add(TransportEndpointDescription.builder().withOutput(ProtectedTransportIntentCompiler.vlanPort(primary.src(), primaryVlan)).build());
        onePaths.add(TransportEndpointDescription.builder().withOutput(ProtectedTransportIntentCompiler.vlanPort(secondary.src(), secondaryVlan)).build());
        ArrayList<TransportEndpointDescription> twoPaths = new ArrayList<TransportEndpointDescription>();
        twoPaths.add(TransportEndpointDescription.builder().withOutput(ProtectedTransportIntentCompiler.vlanPort(primary.dst(), primaryVlan)).build());
        twoPaths.add(TransportEndpointDescription.builder().withOutput(ProtectedTransportIntentCompiler.vlanPort(secondary.dst(), secondaryVlan)).build());
        ProtectionEndpointIntent oneIntent = ProtectionEndpointIntent.builder().key(intent.key()).appId(intent.appId()).priority(intent.priority()).resources(oneResources).deviceId(did1).description(ProtectedTransportEndpointDescription.buildDescription(onePaths, (DeviceId)did2, (String)fingerprint)).build();
        ProtectionEndpointIntent twoIntent = ProtectionEndpointIntent.builder().key(intent.key()).appId(intent.appId()).resources(twoResources).deviceId(did2).description(ProtectedTransportEndpointDescription.buildDescription(twoPaths, (DeviceId)did1, (String)fingerprint)).build();
        ImmutableList resources1 = ImmutableList.of((Object)MarkerResource.marker((String)"protection1"));
        ImmutableList resources2 = ImmutableList.of((Object)MarkerResource.marker((String)"protection2"));
        ImmutableList result = ImmutableList.builder().addAll(this.createTransitIntent((Intent)intent, primary, primaryVlan, (Collection<NetworkResource>)resources1)).addAll(this.createTransitIntent((Intent)intent, secondary, secondaryVlan, (Collection<NetworkResource>)resources2)).add((Object)oneIntent).add((Object)twoIntent).build();
        this.log.trace("createFreshProtectedPaths result: {}", (Object)result);
        return result;
    }

    List<LinkCollectionIntent> createTransitIntent(Intent intent, Path path, VlanId vid, Collection<NetworkResource> resources) {
        if (path.links().size() <= 1) {
            return ImmutableList.of();
        }
        ImmutableList fwd = ImmutableList.builder().addAll(resources).add((Object)MarkerResource.marker((String)FWD)).build();
        ImmutableList rev = ImmutableList.builder().addAll(resources).add((Object)MarkerResource.marker((String)REV)).build();
        return ImmutableList.of((Object)this.createSubTransitIntent(intent, path, vid, (Collection<NetworkResource>)fwd), (Object)this.createSubTransitIntent(intent, this.reverse(path), vid, (Collection<NetworkResource>)rev));
    }

    Path reverse(Path path) {
        List revLinks = Lists.reverse((List)Lists.transform((List)path.links(), this::reverse));
        return new DefaultPath(path.providerId(), revLinks, path.cost(), new Annotations[]{path.annotations()});
    }

    Link reverse(Link link) {
        return DefaultLink.builder().providerId(link.providerId()).src(link.dst()).dst(link.src()).type(link.type()).state(link.state()).isExpected(link.isExpected()).annotations(link.annotations()).build();
    }

    LinkCollectionIntent createSubTransitIntent(Intent intent, Path path, VlanId vid, Collection<NetworkResource> resources) {
        Preconditions.checkArgument((path.links().size() > 1 ? 1 : 0) != 0);
        ConnectPoint one = ((Link)path.links().get(0)).dst();
        ConnectPoint two = ((Link)path.links().get(path.links().size() - 1)).src();
        return LinkCollectionIntent.builder().key(intent.key()).appId(intent.appId()).priority(intent.priority()).resources(resources).links((Set)ImmutableSet.copyOf((Collection)path.links())).filteredIngressPoints((Set)ImmutableSet.of((Object)ProtectedTransportIntentCompiler.vlanPort(one, vid))).filteredEgressPoints((Set)ImmutableSet.of((Object)ProtectedTransportIntentCompiler.vlanPort(two, vid))).applyTreatmentOnEgress(true).cost(path.cost()).build();
    }

    static FilteredConnectPoint vlanPort(ConnectPoint cp, VlanId vid) {
        return new FilteredConnectPoint(cp, DefaultTrafficSelector.builder().matchVlanId(vid).build());
    }

    static DiscreteResourceId resourceId(ConnectPoint cp) {
        return Resources.discrete((DeviceId)cp.deviceId(), (PortNumber)cp.port(), (Object[])new Object[0]).id();
    }

    <T> Pair<T, T> allocateEach(Intent intent, Path primary, Path secondary, Class<T> klass) {
        this.log.trace("allocateEach({}, {}, {}, {})", new Object[]{intent, primary, secondary, klass});
        Pair<T, T> vlans = null;
        Set<T> primaryVlans = this.commonLabelResource(primary, klass);
        Set<T> secondaryVlans = this.commonLabelResource(secondary, klass);
        Pair<T, T> candidates = this.pickEach(primaryVlans, secondaryVlans);
        Object primaryT = candidates.getLeft();
        Object secondaryT = candidates.getRight();
        Stream<Resource> primaryResources = primary.links().stream().flatMap(link -> Stream.of(link.src(), link.dst())).distinct().map(cp -> Resources.discrete((DiscreteResourceId)ProtectedTransportIntentCompiler.resourceId(cp), (Object)primaryT).resource());
        Stream<Resource> secondaryResources = secondary.links().stream().flatMap(link -> Stream.of(link.src(), link.dst())).distinct().map(cp -> Resources.discrete((DiscreteResourceId)ProtectedTransportIntentCompiler.resourceId(cp), (Object)secondaryT).resource());
        List resources = Stream.concat(primaryResources, secondaryResources).collect(Collectors.toList());
        this.log.trace("Calling allocate({},{})", (Object)intent.key(), resources);
        if (this.resourceService.allocate((ResourceConsumer)intent.key(), resources).isEmpty()) {
            this.log.warn("Allocation failed, retrying");
        } else {
            vlans = candidates;
        }
        this.log.trace("allocation done.");
        return vlans;
    }

    <T> T pickOne(Set<T> set) {
        return (T)Iterables.get(set, (int)RandomUtils.nextInt((int)0, (int)set.size()));
    }

    <T> Pair<T, T> pickEach(Set<T> primary, Set<T> secondary) {
        Sets.SetView intersection = Sets.intersection(primary, secondary);
        if (!intersection.isEmpty()) {
            T picked = this.pickOne((Set<T>)intersection);
            return Pair.of(picked, picked);
        }
        T pickedP = this.pickOne(primary);
        T pickedS = this.pickOne(secondary);
        return Pair.of(pickedP, pickedS);
    }

    <T> Set<T> commonLabelResource(Path path, Class<T> klass) {
        Optional<Set> common = path.links().stream().flatMap(link -> Stream.of(link.src(), link.dst())).distinct().map(cp -> this.getAvailableResourceValues((ConnectPoint)cp, klass)).reduce(Sets::intersection);
        if (!common.isPresent() || common.get().isEmpty()) {
            this.log.error("No common label available for: {}", (Object)path);
            throw new IntentCompilationException("No common label available for: " + path);
        }
        return common.get();
    }

    <T> Set<T> getAvailableResourceValues(ConnectPoint cp, Class<T> klass) {
        return this.resourceService.getAvailableResourceValues(ProtectedTransportIntentCompiler.resourceId(cp), klass);
    }

    @Override
    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    @Override
    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }
}

