/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.event.EventListener;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompilationException;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.constraint.ProtectionConstraint;
import org.onosproject.net.intent.impl.PathNotFoundException;
import org.onosproject.net.intent.impl.compiler.ConnectivityIntentCompiler;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class PointToPointIntentCompiler
extends ConnectivityIntentCompiler<PointToPointIntent> {
    private static final ProviderId PID = new ProviderId("core", "org.onosproject.core", true);
    public static final int DEFAULT_COST = 1;
    protected static final int PRIORITY = 100;
    private static final int GROUP_TIMEOUT = 5;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected boolean erasePrimary = false;
    protected boolean eraseBackup = false;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected GroupService groupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;

    @Activate
    public void activate() {
        this.intentManager.registerCompiler(PointToPointIntent.class, (IntentCompiler)this);
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(PointToPointIntent.class);
    }

    public List<Intent> compile(PointToPointIntent intent, List<Intent> installable) {
        this.log.trace("compiling {} {}", (Object)intent, installable);
        ConnectPoint ingressPoint = intent.filteredIngressPoint().connectPoint();
        ConnectPoint egressPoint = intent.filteredEgressPoint().connectPoint();
        if (ingressPoint.deviceId().equals((Object)egressPoint.deviceId())) {
            return this.createZeroHopLinkCollectionIntent(intent);
        }
        if (!ProtectionConstraint.requireProtectedPath((Intent)intent)) {
            return this.createUnprotectedLinkCollectionIntent(intent);
        }
        try {
            return this.createProtectedIntent(ingressPoint, egressPoint, intent, installable);
        }
        catch (PathNotFoundException e) {
            this.log.warn("Could not find disjoint Path for {}", (Object)intent);
            return this.createSinglePathIntent(ingressPoint, egressPoint, intent, installable);
        }
    }

    private List<Intent> createZeroHopIntent(ConnectPoint ingressPoint, ConnectPoint egressPoint, PointToPointIntent intent) {
        List<Link> links = Arrays.asList(DefaultEdgeLink.createEdgeLink((ConnectPoint)ingressPoint, (boolean)true), DefaultEdgeLink.createEdgeLink((ConnectPoint)egressPoint, (boolean)false));
        return Arrays.asList(this.createPathIntent((Path)new DefaultPath(PID, links, 1.0, new Annotations[0]), intent, PathIntent.ProtectionType.PRIMARY));
    }

    private List<Intent> createZeroHopLinkCollectionIntent(PointToPointIntent intent) {
        return Arrays.asList(this.createLinkCollectionIntent((Set<Link>)ImmutableSet.of(), 1.0, intent));
    }

    @Deprecated
    private List<Intent> createUnprotectedIntent(ConnectPoint ingressPoint, ConnectPoint egressPoint, PointToPointIntent intent) {
        ArrayList<DefaultEdgeLink> links = new ArrayList<DefaultEdgeLink>();
        Path path = this.getPathOrException((ConnectivityIntent)intent, (ElementId)ingressPoint.deviceId(), (ElementId)egressPoint.deviceId());
        links.add(DefaultEdgeLink.createEdgeLink((ConnectPoint)ingressPoint, (boolean)true));
        links.addAll(path.links());
        links.add(DefaultEdgeLink.createEdgeLink((ConnectPoint)egressPoint, (boolean)false));
        return Arrays.asList(this.createPathIntent((Path)new DefaultPath(PID, links, path.cost(), new Annotations[]{path.annotations()}), intent, PathIntent.ProtectionType.PRIMARY));
    }

    private List<Intent> createUnprotectedLinkCollectionIntent(PointToPointIntent intent) {
        Path path = this.getPathOrException((ConnectivityIntent)intent, (ElementId)intent.filteredIngressPoint().connectPoint().deviceId(), (ElementId)intent.filteredEgressPoint().connectPoint().deviceId());
        ConnectPoint ingressCP = intent.filteredIngressPoint().connectPoint();
        ConnectPoint egressCP = intent.filteredEgressPoint().connectPoint();
        List<ConnectPoint> pathCPs = path.links().stream().flatMap(l -> Stream.of(l.src(), l.dst())).collect(Collectors.toList());
        pathCPs.add(ingressCP);
        pathCPs.add(egressCP);
        this.allocateBandwidth((ConnectivityIntent)intent, pathCPs);
        return Arrays.asList(this.createLinkCollectionIntent((Set<Link>)ImmutableSet.copyOf((Collection)path.links()), path.cost(), intent));
    }

    private List<Intent> createProtectedIntent(ConnectPoint ingressPoint, ConnectPoint egressPoint, PointToPointIntent intent, List<Intent> installable) {
        this.log.trace("createProtectedIntent");
        DisjointPath path = this.getDisjointPath((ConnectivityIntent)intent, (ElementId)ingressPoint.deviceId(), (ElementId)egressPoint.deviceId());
        List<Intent> reusableIntents = null;
        if (installable != null && (reusableIntents = this.filterInvalidSubIntents(installable, intent)).size() == installable.size()) {
            return installable;
        }
        ArrayList<Intent> intentList = new ArrayList<Intent>();
        ArrayList<Link> links = new ArrayList<Link>();
        links.addAll(path.links());
        links.add((Link)DefaultEdgeLink.createEdgeLink((ConnectPoint)egressPoint, (boolean)false));
        ArrayList<Link> backupLinks = new ArrayList<Link>();
        backupLinks.addAll(path.backup().links());
        backupLinks.add((Link)DefaultEdgeLink.createEdgeLink((ConnectPoint)egressPoint, (boolean)false));
        if (reusableIntents != null && reusableIntents.size() > 1) {
            PortNumber primaryPort = this.getPrimaryPort(intent);
            if (primaryPort != null && !((Link)links.get(0)).src().port().equals((Object)primaryPort)) {
                reusableIntents.add(this.createPathIntent((Path)new DefaultPath(PID, links, path.cost(), new Annotations[]{path.annotations()}), intent, PathIntent.ProtectionType.BACKUP));
                this.updateFailoverGroup(intent, links);
                return reusableIntents;
            }
            reusableIntents.add(this.createPathIntent((Path)new DefaultPath(PID, backupLinks, path.backup().cost(), new Annotations[]{path.backup().annotations()}), intent, PathIntent.ProtectionType.BACKUP));
            this.updateFailoverGroup(intent, backupLinks);
            return reusableIntents;
        }
        intentList.add(this.createPathIntent((Path)new DefaultPath(PID, links, path.cost(), new Annotations[]{path.annotations()}), intent, PathIntent.ProtectionType.PRIMARY));
        intentList.add(this.createPathIntent((Path)new DefaultPath(PID, backupLinks, path.backup().cost(), new Annotations[]{path.backup().annotations()}), intent, PathIntent.ProtectionType.BACKUP));
        if (this.groupService.getGroup(ingressPoint.deviceId(), PointToPointIntentCompiler.makeGroupKey(intent.id())) == null) {
            this.createFailoverTreatmentGroup(path.links(), path.backup().links(), intent);
            FlowRuleIntent frIntent = new FlowRuleIntent(intent.appId(), intent.key(), this.createFailoverFlowRules(intent), Arrays.asList(ingressPoint.deviceId()), PathIntent.ProtectionType.FAILOVER, intent.resourceGroup());
            intentList.add((Intent)frIntent);
        } else {
            this.updateFailoverGroup(intent, links);
            this.updateFailoverGroup(intent, backupLinks);
        }
        return intentList;
    }

    private List<Intent> createSinglePathIntent(ConnectPoint ingressPoint, ConnectPoint egressPoint, PointToPointIntent intent, List<Intent> installable) {
        ArrayList<DefaultEdgeLink> links = new ArrayList<DefaultEdgeLink>();
        Path onlyPath = this.getPathOrException((ConnectivityIntent)intent, (ElementId)ingressPoint.deviceId(), (ElementId)egressPoint.deviceId());
        List<Intent> reusableIntents = null;
        if (installable != null && (reusableIntents = this.filterInvalidSubIntents(installable, intent)).size() == installable.size()) {
            return installable;
        }
        if (reusableIntents != null && reusableIntents.size() > 1) {
            return reusableIntents;
        }
        ConnectPoint ingressCP = intent.filteredIngressPoint().connectPoint();
        ConnectPoint egressCP = intent.filteredEgressPoint().connectPoint();
        List<ConnectPoint> pathCPs = onlyPath.links().stream().flatMap(l -> Stream.of(l.src(), l.dst())).collect(Collectors.toList());
        pathCPs.add(ingressCP);
        pathCPs.add(egressCP);
        this.allocateBandwidth((ConnectivityIntent)intent, pathCPs);
        links.add(DefaultEdgeLink.createEdgeLink((ConnectPoint)ingressPoint, (boolean)true));
        links.addAll(onlyPath.links());
        links.add(DefaultEdgeLink.createEdgeLink((ConnectPoint)egressPoint, (boolean)false));
        return Arrays.asList(this.createPathIntent((Path)new DefaultPath(PID, links, onlyPath.cost(), new Annotations[]{onlyPath.annotations()}), intent, PathIntent.ProtectionType.PRIMARY));
    }

    private Intent createPathIntent(Path path, PointToPointIntent intent, PathIntent.ProtectionType type) {
        return PathIntent.builder().appId(intent.appId()).key(intent.key()).selector(intent.selector()).treatment(intent.treatment()).path(path).constraints(intent.constraints()).priority(intent.priority()).setType(type).resourceGroup(intent.resourceGroup()).build();
    }

    private Intent createLinkCollectionIntent(Set<Link> links, double cost, PointToPointIntent intent) {
        return LinkCollectionIntent.builder().key(intent.key()).appId(intent.appId()).selector(intent.selector()).treatment(intent.treatment()).links((Set)ImmutableSet.copyOf(links)).filteredIngressPoints((Set)ImmutableSet.of((Object)intent.filteredIngressPoint())).filteredEgressPoints((Set)ImmutableSet.of((Object)intent.filteredEgressPoint())).applyTreatmentOnEgress(true).constraints(intent.constraints()).priority(intent.priority()).cost(cost).resourceGroup(intent.resourceGroup()).build();
    }

    private PortNumber getPrimaryPort(PointToPointIntent intent) {
        Group group = this.groupService.getGroup(intent.filteredIngressPoint().connectPoint().deviceId(), PointToPointIntentCompiler.makeGroupKey(intent.id()));
        PortNumber primaryPort = null;
        if (group != null) {
            List buckets = group.buckets().buckets();
            Iterator iterator = buckets.iterator();
            while (primaryPort == null && iterator.hasNext()) {
                GroupBucket bucket = (GroupBucket)iterator.next();
                Instruction individualInstruction = (Instruction)bucket.treatment().allInstructions().get(0);
                if (!(individualInstruction instanceof Instructions.OutputInstruction)) continue;
                Instructions.OutputInstruction outInstruction = (Instructions.OutputInstruction)individualInstruction;
                PortNumber tempPortNum = outInstruction.port();
                Port port = this.deviceService.getPort(intent.filteredIngressPoint().connectPoint().deviceId(), tempPortNum);
                if (port == null || !port.isEnabled()) continue;
                primaryPort = tempPortNum;
            }
        }
        return primaryPort;
    }

    public static GroupKey makeGroupKey(IntentId intentId) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(intentId.fingerprint());
        return new DefaultGroupKey(buffer.array());
    }

    private void createFailoverTreatmentGroup(List<Link> links, List<Link> backupLinks, PointToPointIntent intent) {
        ArrayList<GroupBucket> buckets = new ArrayList<GroupBucket>();
        TrafficTreatment.Builder tBuilderIn = DefaultTrafficTreatment.builder();
        ConnectPoint src = links.get(0).src();
        tBuilderIn.setOutput(src.port());
        TrafficTreatment.Builder tBuilderIn2 = DefaultTrafficTreatment.builder();
        ConnectPoint src2 = backupLinks.get(0).src();
        tBuilderIn2.setOutput(src2.port());
        buckets.add(DefaultGroupBucket.createFailoverGroupBucket((TrafficTreatment)tBuilderIn.build(), (PortNumber)src.port(), null));
        buckets.add(DefaultGroupBucket.createFailoverGroupBucket((TrafficTreatment)tBuilderIn2.build(), (PortNumber)src2.port(), null));
        GroupBuckets groupBuckets = new GroupBuckets(buckets);
        DefaultGroupDescription groupDesc = new DefaultGroupDescription(src.deviceId(), GroupDescription.Type.FAILOVER, groupBuckets, PointToPointIntentCompiler.makeGroupKey(intent.id()), null, intent.appId());
        this.log.trace("adding failover group {}", (Object)groupDesc);
        this.groupService.addGroup((GroupDescription)groupDesc);
    }

    private List<FlowRule> createFailoverFlowRules(PointToPointIntent intent) {
        ArrayList<FlowRule> flowRules = new ArrayList<FlowRule>();
        ConnectPoint ingress = intent.ingressPoint();
        DeviceId deviceId = ingress.deviceId();
        TrafficSelector trafficSelector = DefaultTrafficSelector.builder((TrafficSelector)intent.selector()).matchInPort(ingress.port()).build();
        DefaultFlowRule.Builder flowRuleBuilder = DefaultFlowRule.builder();
        flowRules.add(flowRuleBuilder.withSelector(trafficSelector).withTreatment(this.buildFailoverTreatment(deviceId, PointToPointIntentCompiler.makeGroupKey(intent.id()))).fromApp(intent.appId()).makePermanent().forDevice(deviceId).withPriority(100).build());
        return flowRules;
    }

    private Group waitForGroup(DeviceId deviceId, GroupKey groupKey) {
        return this.waitForGroup(deviceId, groupKey, 5L, TimeUnit.SECONDS);
    }

    private Group waitForGroup(DeviceId deviceId, GroupKey groupKey, long timeout, TimeUnit unit) {
        Group group = this.groupService.getGroup(deviceId, groupKey);
        if (group != null) {
            return group;
        }
        CompletableFuture future = new CompletableFuture();
        GroupListener listener = event -> {
            if (((Group)event.subject()).deviceId() == deviceId && ((Group)event.subject()).appCookie().equals(groupKey)) {
                future.complete(event.subject());
                return;
            }
        };
        this.groupService.addListener((EventListener)listener);
        try {
            group = this.groupService.getGroup(deviceId, groupKey);
            if (group != null) {
                Group group2 = group;
                return group2;
            }
            Group group3 = (Group)future.get(timeout, unit);
            return group3;
        }
        catch (InterruptedException e) {
            this.log.debug("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IntentCompilationException("Interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            this.log.debug("ExecutionException", (Throwable)e);
            throw new IntentCompilationException("ExecutionException caught", (Throwable)e);
        }
        catch (TimeoutException e) {
            group = this.groupService.getGroup(deviceId, groupKey);
            if (group != null) {
                Group group4 = group;
                return group4;
            }
            this.log.debug("Timeout", (Throwable)e);
            throw new IntentCompilationException("Timeout", (Throwable)e);
        }
        finally {
            this.groupService.removeListener((EventListener)listener);
        }
    }

    private TrafficTreatment buildFailoverTreatment(DeviceId srcDevice, GroupKey groupKey) {
        Group group = this.waitForGroup(srcDevice, groupKey);
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
        TrafficTreatment trafficTreatment = tBuilder.group(group.id()).build();
        return trafficTreatment;
    }

    private List<Intent> filterInvalidSubIntents(List<Intent> oldInstallables, PointToPointIntent pointIntent) {
        ArrayList<Intent> intentList = new ArrayList<Intent>();
        intentList.addAll(oldInstallables);
        this.erasePrimary = false;
        this.eraseBackup = false;
        if (intentList != null) {
            Iterator iterator = intentList.iterator();
            while (!(!iterator.hasNext() || this.erasePrimary && this.eraseBackup)) {
                Intent intent = (Intent)iterator.next();
                intent.resources().forEach(resource -> {
                    if (resource instanceof Link) {
                        Link link = (Link)resource;
                        if (link.state() == Link.State.INACTIVE) {
                            this.setPathsToRemove(intent);
                        } else if (link instanceof EdgeLink) {
                            ConnectPoint connectPoint = link.src().elementId() instanceof DeviceId ? link.src() : link.dst();
                            Port port = this.deviceService.getPort(connectPoint.deviceId(), connectPoint.port());
                            if (port == null || !port.isEnabled()) {
                                this.setPathsToRemove(intent);
                            }
                        } else {
                            Port port1 = this.deviceService.getPort(link.src().deviceId(), link.src().port());
                            Port port2 = this.deviceService.getPort(link.dst().deviceId(), link.dst().port());
                            if (port1 == null || !port1.isEnabled() || port2 == null || !port2.isEnabled()) {
                                this.setPathsToRemove(intent);
                            }
                        }
                    }
                });
            }
            this.removeAndUpdateIntents(intentList, pointIntent);
        }
        return intentList;
    }

    private boolean setPathsToRemove(Intent intent) {
        if (intent instanceof FlowRuleIntent) {
            FlowRuleIntent frIntent = (FlowRuleIntent)intent;
            PathIntent.ProtectionType type = frIntent.type();
            if (type == PathIntent.ProtectionType.PRIMARY || type == PathIntent.ProtectionType.FAILOVER) {
                this.erasePrimary = true;
            }
            if (type == PathIntent.ProtectionType.BACKUP || type == PathIntent.ProtectionType.FAILOVER) {
                this.eraseBackup = true;
            }
        }
        return this.erasePrimary && this.eraseBackup;
    }

    private void removeAndUpdateIntents(List<Intent> cleanUpIntents, PointToPointIntent pointIntent) {
        ListIterator<Intent> iterator = cleanUpIntents.listIterator();
        while (iterator.hasNext()) {
            Intent cIntent = iterator.next();
            if (!(cIntent instanceof FlowRuleIntent)) continue;
            FlowRuleIntent fIntent = (FlowRuleIntent)cIntent;
            if (fIntent.type() == PathIntent.ProtectionType.PRIMARY && this.erasePrimary) {
                iterator.remove();
                continue;
            }
            if (fIntent.type() == PathIntent.ProtectionType.BACKUP && this.eraseBackup) {
                iterator.remove();
                continue;
            }
            if (fIntent.type() != PathIntent.ProtectionType.BACKUP || !this.erasePrimary) continue;
            iterator.set((Intent)new FlowRuleIntent(fIntent, PathIntent.ProtectionType.PRIMARY));
        }
        Group group = this.groupService.getGroup(pointIntent.filteredIngressPoint().connectPoint().deviceId(), PointToPointIntentCompiler.makeGroupKey(pointIntent.id()));
        if (group != null) {
            this.updateFailoverGroup(pointIntent);
        }
    }

    private void updateFailoverGroup(PointToPointIntent pointIntent) {
        DeviceId deviceId = pointIntent.filteredIngressPoint().connectPoint().deviceId();
        GroupKey groupKey = PointToPointIntentCompiler.makeGroupKey(pointIntent.id());
        Group group = this.waitForGroup(deviceId, groupKey);
        for (GroupBucket bucket : group.buckets().buckets()) {
            Instructions.OutputInstruction outInstruction;
            Port port;
            Instruction individualInstruction = (Instruction)bucket.treatment().allInstructions().get(0);
            if (!(individualInstruction instanceof Instructions.OutputInstruction) || (port = this.deviceService.getPort(deviceId, (outInstruction = (Instructions.OutputInstruction)individualInstruction).port())) != null && port.isEnabled()) continue;
            GroupBuckets removeBuckets = new GroupBuckets(Collections.singletonList(bucket));
            this.groupService.removeBucketsFromGroup(deviceId, groupKey, removeBuckets, groupKey, pointIntent.appId());
        }
    }

    private void updateFailoverGroup(PointToPointIntent intent, List<Link> links) {
        GroupKey groupKey = PointToPointIntentCompiler.makeGroupKey(intent.id());
        TrafficTreatment.Builder tBuilderIn = DefaultTrafficTreatment.builder();
        ConnectPoint src = links.get(0).src();
        tBuilderIn.setOutput(src.port());
        GroupBucket bucket = DefaultGroupBucket.createFailoverGroupBucket((TrafficTreatment)tBuilderIn.build(), (PortNumber)src.port(), null);
        GroupBuckets addBuckets = new GroupBuckets(Collections.singletonList(bucket));
        this.groupService.addBucketsToGroup(src.deviceId(), groupKey, addBuckets, groupKey, intent.appId());
    }

    protected void bindGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    protected void unbindGroupService(GroupService groupService) {
        if (this.groupService == groupService) {
            this.groupService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    @Override
    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    @Override
    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

