/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.intent.FlowObjectiveIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.intent.impl.compiler.IntentConfigurableRegistrator;
import org.onosproject.net.intent.impl.compiler.PathCompiler;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.impl.LabelAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class PathIntentFlowObjectiveCompiler
extends PathCompiler<Objective>
implements IntentCompiler<PathIntent>,
PathCompiler.PathCompilerCreateFlow<Objective> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentConfigurableRegistrator registrator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    private ApplicationId appId;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.net.intent");
        this.registrator.registerCompiler(PathIntent.class, this, true);
        labelAllocator = new LabelAllocator(this.resourceService);
    }

    @Deactivate
    public void deactivate() {
        this.registrator.unregisterCompiler(PathIntent.class, true);
    }

    public List<Intent> compile(PathIntent intent, List<Intent> installable) {
        LinkedList objectives = new LinkedList();
        LinkedList<DeviceId> devices = new LinkedList<DeviceId>();
        this.compile(this, intent, objectives, devices);
        return ImmutableList.of((Object)new FlowObjectiveIntent(this.appId, intent.key(), devices, objectives, intent.resources(), intent.resourceGroup()));
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public ResourceService resourceService() {
        return this.resourceService;
    }

    @Override
    public void createFlow(TrafficSelector originalSelector, TrafficTreatment originalTreatment, ConnectPoint ingress, ConnectPoint egress, int priority, boolean applyTreatment, List<Objective> objectives, List<DeviceId> devices) {
        TrafficSelector selector = DefaultTrafficSelector.builder((TrafficSelector)originalSelector).matchInPort(ingress.port()).build();
        TrafficTreatment.Builder treatmentBuilder = applyTreatment ? DefaultTrafficTreatment.builder((TrafficTreatment)originalTreatment) : DefaultTrafficTreatment.builder();
        TrafficTreatment treatment = treatmentBuilder.setOutput(egress.port()).build();
        NextObjective nextObjective = DefaultNextObjective.builder().withId(this.flowObjectiveService.allocateNextId()).addTreatment(treatment).withType(NextObjective.Type.SIMPLE).fromApp(this.appId).makePermanent().add();
        objectives.add((Objective)nextObjective);
        devices.add(ingress.deviceId());
        objectives.add((Objective)DefaultForwardingObjective.builder().withSelector(selector).nextStep(nextObjective.id()).withPriority(priority).fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.SPECIFIC).add());
        devices.add(ingress.deviceId());
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindRegistrator(IntentConfigurableRegistrator intentConfigurableRegistrator) {
        this.registrator = intentConfigurableRegistrator;
    }

    protected void unbindRegistrator(IntentConfigurableRegistrator intentConfigurableRegistrator) {
        if (this.registrator == intentConfigurableRegistrator) {
            this.registrator = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }
}

