/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onlab.util.Identifier;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.intent.IntentCompilationException;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.intent.constraint.EncapsulationConstraint;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.impl.LabelAllocator;
import org.slf4j.Logger;

public class PathCompiler<T> {
    private static final String ERROR_VLAN = "No VLAN Ids available for ";
    private static final String ERROR_MPLS = "No available MPLS labels for ";
    static LabelAllocator labelAllocator;

    private boolean isLast(List<Link> links, int i) {
        return i == links.size() - 2;
    }

    private EthType getEthType(TrafficSelector selector) {
        Criterion c = selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (c != null && c instanceof EthTypeCriterion) {
            EthTypeCriterion ethertype = (EthTypeCriterion)c;
            return ethertype.ethType();
        }
        return EthType.EtherType.IPV4.ethType();
    }

    private void manageVlanEncap(PathCompilerCreateFlow<T> creator, List<T> flows, List<DeviceId> devices, PathIntent intent) {
        Set linksSet = Sets.newConcurrentHashSet();
        for (int i = 1; i <= intent.path().links().size() - 2; ++i) {
            linksSet.add(intent.path().links().get(i));
        }
        Map<LinkKey, Identifier<?>> vlanIds = labelAllocator.assignLabelToLinks(linksSet, (ResourceConsumer)intent.key(), EncapsulationType.VLAN);
        Iterator links = intent.path().links().iterator();
        Link srcLink = (Link)links.next();
        Link link = (Link)links.next();
        VlanId vlanId = (VlanId)vlanIds.get(LinkKey.linkKey((Link)link));
        if (vlanId == null) {
            throw new IntentCompilationException(ERROR_VLAN + link);
        }
        VlanId prevVlanId = vlanId;
        Optional<VlanIdCriterion> vlanCriterion = intent.selector().criteria().stream().filter(criterion -> criterion.type() == Criterion.Type.VLAN_VID).map(criterion -> (VlanIdCriterion)criterion).findAny();
        TrafficTreatment.Builder treatBuilder = DefaultTrafficTreatment.builder();
        if (!vlanCriterion.isPresent()) {
            treatBuilder.pushVlan();
        }
        treatBuilder.setVlanId(vlanId);
        creator.createFlow(intent.selector(), treatBuilder.build(), srcLink.dst(), link.src(), intent.priority(), true, flows, devices);
        ConnectPoint prev = link.dst();
        while (links.hasNext()) {
            link = (Link)links.next();
            if (links.hasNext()) {
                VlanId egressVlanId = (VlanId)vlanIds.get(LinkKey.linkKey((Link)link));
                if (egressVlanId == null) {
                    throw new IntentCompilationException(ERROR_VLAN + link);
                }
                TrafficSelector transitSelector = DefaultTrafficSelector.builder().matchInPort(prev.port()).matchVlanId(prevVlanId).build();
                TrafficTreatment.Builder transitTreat = DefaultTrafficTreatment.builder();
                if (!prevVlanId.equals((Object)egressVlanId)) {
                    transitTreat.setVlanId(egressVlanId);
                }
                creator.createFlow(transitSelector, transitTreat.build(), prev, link.src(), intent.priority(), true, flows, devices);
                prevVlanId = egressVlanId;
                prev = link.dst();
                continue;
            }
            TrafficSelector egressSelector = DefaultTrafficSelector.builder().matchInPort(prev.port()).matchVlanId(prevVlanId).build();
            TrafficTreatment.Builder egressTreat = DefaultTrafficTreatment.builder((TrafficTreatment)intent.treatment());
            Optional<L2ModificationInstruction.ModVlanIdInstruction> modVlanIdInstruction = intent.treatment().allInstructions().stream().filter(instruction -> instruction instanceof L2ModificationInstruction.ModVlanIdInstruction).map(x -> (L2ModificationInstruction.ModVlanIdInstruction)x).findAny();
            Optional<L2ModificationInstruction.ModVlanHeaderInstruction> popVlanInstruction = intent.treatment().allInstructions().stream().filter(instruction -> instruction instanceof L2ModificationInstruction.ModVlanHeaderInstruction).map(x -> (L2ModificationInstruction.ModVlanHeaderInstruction)x).findAny();
            if (!modVlanIdInstruction.isPresent() && !popVlanInstruction.isPresent()) {
                if (vlanCriterion.isPresent()) {
                    egressTreat.setVlanId(vlanCriterion.get().vlanId());
                } else {
                    egressTreat.popVlan();
                }
            }
            creator.createFlow(egressSelector, egressTreat.build(), prev, link.src(), intent.priority(), true, flows, devices);
        }
    }

    private void manageMplsEncap(PathCompilerCreateFlow<T> creator, List<T> flows, List<DeviceId> devices, PathIntent intent) {
        Set linksSet = Sets.newConcurrentHashSet();
        for (int i = 1; i <= intent.path().links().size() - 2; ++i) {
            linksSet.add(intent.path().links().get(i));
        }
        Map<LinkKey, Identifier<?>> mplsLabels = labelAllocator.assignLabelToLinks(linksSet, (ResourceConsumer)intent.key(), EncapsulationType.MPLS);
        Iterator links = intent.path().links().iterator();
        Link srcLink = (Link)links.next();
        Link link = (Link)links.next();
        MplsLabel mplsLabel = (MplsLabel)mplsLabels.get(LinkKey.linkKey((Link)link));
        if (mplsLabel == null) {
            throw new IntentCompilationException(ERROR_MPLS + link);
        }
        MplsLabel prevMplsLabel = mplsLabel;
        Optional<MplsCriterion> mplsCriterion = intent.selector().criteria().stream().filter(criterion -> criterion.type() == Criterion.Type.MPLS_LABEL).map(criterion -> (MplsCriterion)criterion).findAny();
        TrafficTreatment.Builder treatBuilder = DefaultTrafficTreatment.builder();
        if (!mplsCriterion.isPresent()) {
            treatBuilder.pushMpls();
        }
        treatBuilder.setMpls(mplsLabel);
        creator.createFlow(intent.selector(), treatBuilder.build(), srcLink.dst(), link.src(), intent.priority(), true, flows, devices);
        ConnectPoint prev = link.dst();
        while (links.hasNext()) {
            link = (Link)links.next();
            if (links.hasNext()) {
                MplsLabel transitMplsLabel = (MplsLabel)mplsLabels.get(LinkKey.linkKey((Link)link));
                if (transitMplsLabel == null) {
                    throw new IntentCompilationException(ERROR_MPLS + link);
                }
                TrafficSelector transitSelector = DefaultTrafficSelector.builder().matchInPort(prev.port()).matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel(prevMplsLabel).build();
                TrafficTreatment.Builder transitTreat = DefaultTrafficTreatment.builder();
                if (!prevMplsLabel.equals((Object)transitMplsLabel)) {
                    transitTreat.setMpls(transitMplsLabel);
                }
                creator.createFlow(transitSelector, transitTreat.build(), prev, link.src(), intent.priority(), true, flows, devices);
                prevMplsLabel = transitMplsLabel;
                prev = link.dst();
                continue;
            }
            TrafficSelector.Builder egressSelector = DefaultTrafficSelector.builder().matchInPort(prev.port()).matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel(prevMplsLabel);
            TrafficTreatment.Builder egressTreat = DefaultTrafficTreatment.builder((TrafficTreatment)intent.treatment());
            for (Instruction instruct : intent.treatment().allInstructions()) {
                if (!(instruct instanceof L2ModificationInstruction)) continue;
                L2ModificationInstruction l2Mod = (L2ModificationInstruction)instruct;
                if (l2Mod.subtype() == L2ModificationInstruction.L2SubType.VLAN_PUSH) break;
                if (l2Mod.subtype() != L2ModificationInstruction.L2SubType.VLAN_POP && l2Mod.subtype() != L2ModificationInstruction.L2SubType.VLAN_ID) continue;
                egressSelector.matchVlanId(VlanId.ANY);
            }
            if (mplsCriterion.isPresent()) {
                egressTreat.setMpls(mplsCriterion.get().label());
            } else {
                egressTreat.popMpls(this.getEthType(intent.selector()));
            }
            creator.createFlow(egressSelector.build(), egressTreat.build(), prev, link.src(), intent.priority(), true, flows, devices);
        }
    }

    public void compile(PathCompilerCreateFlow<T> creator, PathIntent intent, List<T> flows, List<DeviceId> devices) {
        List links = intent.path().links();
        Optional<EncapsulationConstraint> encapConstraint = intent.constraints().stream().filter(constraint -> constraint instanceof EncapsulationConstraint).map(x -> (EncapsulationConstraint)x).findAny();
        if (!encapConstraint.isPresent() || links.size() == 2) {
            for (int i = 0; i < links.size() - 1; ++i) {
                ConnectPoint ingress = ((Link)links.get(i)).dst();
                ConnectPoint egress = ((Link)links.get(i + 1)).src();
                creator.createFlow(intent.selector(), intent.treatment(), ingress, egress, intent.priority(), this.isLast(links, i), flows, devices);
            }
            return;
        }
        encapConstraint.map(EncapsulationConstraint::encapType).map(type -> {
            switch (type) {
                case VLAN: {
                    this.manageVlanEncap(creator, flows, devices, intent);
                    break;
                }
                case MPLS: {
                    this.manageMplsEncap(creator, flows, devices, intent);
                    break;
                }
            }
            return 0;
        });
    }

    public static interface PathCompilerCreateFlow<T> {
        public void createFlow(TrafficSelector var1, TrafficTreatment var2, ConnectPoint var3, ConnectPoint var4, int var5, boolean var6, List<T> var7, List<DeviceId> var8);

        public Logger log();

        public ResourceService resourceService();
    }
}

