/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentException;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.constraint.PartialFailureConstraint;
import org.onosproject.net.intent.impl.compiler.ConnectivityIntentCompiler;

@Component(immediate=true)
public class MultiPointToSinglePointIntentCompiler
extends ConnectivityIntentCompiler<MultiPointToSinglePointIntent> {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;

    @Activate
    public void activate() {
        this.intentManager.registerCompiler(MultiPointToSinglePointIntent.class, (IntentCompiler)this);
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(MultiPointToSinglePointIntent.class);
    }

    public List<Intent> compile(MultiPointToSinglePointIntent intent, List<Intent> installable) {
        HashMap<DeviceId, Link> links = new HashMap<DeviceId, Link>();
        ConnectPoint egressPoint = intent.egressPoint();
        boolean allowMissingPaths = PartialFailureConstraint.intentAllowsPartialFailure((Intent)intent);
        boolean hasPaths = false;
        boolean missingSomePaths = false;
        block0: for (ConnectPoint ingressPoint : intent.ingressPoints()) {
            if (ingressPoint.deviceId().equals((Object)egressPoint.deviceId())) {
                if (this.deviceService.isAvailable(ingressPoint.deviceId())) {
                    hasPaths = true;
                    continue;
                }
                missingSomePaths = true;
                continue;
            }
            Path path = this.getPath((ConnectivityIntent)intent, (ElementId)ingressPoint.deviceId(), (ElementId)egressPoint.deviceId());
            if (path != null) {
                hasPaths = true;
                for (Link link : path.links()) {
                    if (links.containsKey(link.dst().deviceId())) {
                        links.put(link.src().deviceId(), link);
                        continue block0;
                    }
                    links.put(link.src().deviceId(), link);
                }
                continue;
            }
            missingSomePaths = true;
        }
        List ingressCPs = intent.filteredIngressPoints().stream().map(fcp -> fcp.connectPoint()).collect(Collectors.toList());
        ConnectPoint egressCP = intent.filteredEgressPoint().connectPoint();
        List<ConnectPoint> pathCPs = links.values().stream().flatMap(l -> Stream.of(l.src(), l.dst())).collect(Collectors.toList());
        pathCPs.addAll(ingressCPs);
        pathCPs.add(egressCP);
        this.allocateBandwidth((ConnectivityIntent)intent, pathCPs);
        if (!hasPaths) {
            throw new IntentException("Cannot find any path between ingress and egress points.");
        }
        if (!allowMissingPaths && missingSomePaths) {
            throw new IntentException("Missing some paths between ingress and egress points.");
        }
        LinkCollectionIntent result = LinkCollectionIntent.builder().appId(intent.appId()).key(intent.key()).treatment(intent.treatment()).selector(intent.selector()).links((Set)Sets.newHashSet(links.values())).filteredIngressPoints(intent.filteredIngressPoints()).filteredEgressPoints((Set)ImmutableSet.of((Object)intent.filteredEgressPoint())).priority(intent.priority()).constraints(intent.constraints()).resourceGroup(intent.resourceGroup()).build();
        return Collections.singletonList(result);
    }

    @Override
    protected void bindIntentManager(IntentExtensionService intentExtensionService) {
        this.intentManager = intentExtensionService;
    }

    @Override
    protected void unbindIntentManager(IntentExtensionService intentExtensionService) {
        if (this.intentManager == intentExtensionService) {
            this.intentManager = null;
        }
    }

    @Override
    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    @Override
    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

