/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.MplsPathIntent;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(immediate=true)
public class MplsPathIntentCompiler
implements IntentCompiler<MplsPathIntent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentExtensionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    protected ApplicationId appId;

    public List<Intent> compile(MplsPathIntent intent, List<Intent> installable) {
        Map<LinkKey, MplsLabel> labels = this.assignMplsLabel(intent);
        List<FlowRule> rules = this.generateRules(intent, labels);
        return Collections.singletonList(new FlowRuleIntent(this.appId, intent.key(), rules, intent.resources()));
    }

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.net.intent");
        this.intentExtensionService.registerCompiler(MplsPathIntent.class, (IntentCompiler)this);
    }

    @Deactivate
    public void deactivate() {
        this.intentExtensionService.unregisterCompiler(MplsPathIntent.class);
    }

    private Map<LinkKey, MplsLabel> assignMplsLabel(MplsPathIntent intent) {
        HashSet linkRequest = Sets.newHashSetWithExpectedSize((int)(intent.path().links().size() - 2));
        for (int i = 1; i <= intent.path().links().size() - 2; ++i) {
            LinkKey link = LinkKey.linkKey((Link)((Link)intent.path().links().get(i)));
            linkRequest.add(link);
            linkRequest.add(LinkKey.linkKey((ConnectPoint)link.dst(), (ConnectPoint)link.src()));
        }
        Map<LinkKey, MplsLabel> labels = this.findMplsLabels(linkRequest);
        if (labels.isEmpty()) {
            return Collections.emptyMap();
        }
        Set resources = labels.entrySet().stream().flatMap(x -> Stream.of(Resources.discrete((DeviceId)((LinkKey)x.getKey()).src().deviceId(), (PortNumber)((LinkKey)x.getKey()).src().port(), (Object[])new Object[]{x.getValue()}).resource(), Resources.discrete((DeviceId)((LinkKey)x.getKey()).dst().deviceId(), (PortNumber)((LinkKey)x.getKey()).dst().port(), (Object[])new Object[]{x.getValue()}).resource())).collect(Collectors.toSet());
        List allocations = this.resourceService.allocate((ResourceConsumer)intent.id(), (List)ImmutableList.copyOf(resources));
        if (allocations.isEmpty()) {
            Collections.emptyMap();
        }
        return labels;
    }

    private Map<LinkKey, MplsLabel> findMplsLabels(Set<LinkKey> links) {
        HashMap<LinkKey, MplsLabel> labels = new HashMap<LinkKey, MplsLabel>();
        for (LinkKey link : links) {
            Set<MplsLabel> backward;
            Set<MplsLabel> forward = this.findMplsLabel(link.src());
            Sets.SetView common = Sets.intersection(forward, backward = this.findMplsLabel(link.dst()));
            if (common.isEmpty()) continue;
            labels.put(link, (MplsLabel)common.iterator().next());
        }
        return labels;
    }

    private Set<MplsLabel> findMplsLabel(ConnectPoint cp) {
        return this.resourceService.getAvailableResourceValues(Resources.discrete((DeviceId)cp.deviceId(), (PortNumber)cp.port(), (Object[])new Object[0]).id(), MplsLabel.class);
    }

    private MplsLabel getMplsLabel(Map<LinkKey, MplsLabel> labels, LinkKey link) {
        return labels.get(link);
    }

    private List<FlowRule> generateRules(MplsPathIntent intent, Map<LinkKey, MplsLabel> labels) {
        Iterator links = intent.path().links().iterator();
        Link srcLink = (Link)links.next();
        ConnectPoint prev = srcLink.dst();
        Link link = (Link)links.next();
        LinkedList<FlowRule> rules = new LinkedList<FlowRule>();
        MplsLabel mpls = this.getMplsLabel(labels, LinkKey.linkKey((Link)link));
        Preconditions.checkNotNull((Object)mpls);
        MplsLabel prevLabel = mpls;
        rules.add(this.ingressFlow(prev.port(), link, intent, mpls));
        prev = link.dst();
        while (links.hasNext()) {
            link = (Link)links.next();
            if (links.hasNext()) {
                mpls = this.getMplsLabel(labels, LinkKey.linkKey((Link)link));
                Preconditions.checkNotNull((Object)mpls);
                rules.add(this.transitFlow(prev.port(), link, intent, prevLabel, mpls));
                prevLabel = mpls;
            } else {
                rules.add(this.egressFlow(prev.port(), link, intent, prevLabel));
            }
            prev = link.dst();
        }
        return rules;
    }

    private FlowRule ingressFlow(PortNumber inPort, Link link, MplsPathIntent intent, MplsLabel label) {
        TrafficSelector.Builder ingressSelector = DefaultTrafficSelector.builder((TrafficSelector)intent.selector());
        TrafficTreatment.Builder treat = DefaultTrafficTreatment.builder();
        ingressSelector.matchInPort(inPort);
        if (intent.ingressLabel().isPresent()) {
            ingressSelector.matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel((MplsLabel)intent.ingressLabel().get());
            treat.setMpls(label);
        } else {
            treat.pushMpls().setMpls(label);
        }
        treat.setOutput(link.src().port());
        return this.createFlowRule(intent, link.src().deviceId(), ingressSelector.build(), treat.build());
    }

    private FlowRule transitFlow(PortNumber inPort, Link link, MplsPathIntent intent, MplsLabel prevLabel, MplsLabel outLabel) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchInPort(inPort).matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel(prevLabel);
        TrafficTreatment.Builder treat = DefaultTrafficTreatment.builder();
        if (!prevLabel.equals((Object)outLabel)) {
            treat.setMpls(outLabel);
        }
        treat.setOutput(link.src().port());
        return this.createFlowRule(intent, link.src().deviceId(), selector.build(), treat.build());
    }

    private FlowRule egressFlow(PortNumber inPort, Link link, MplsPathIntent intent, MplsLabel prevLabel) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchInPort(inPort).matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel(prevLabel);
        TrafficTreatment.Builder treat = DefaultTrafficTreatment.builder((TrafficTreatment)intent.treatment());
        for (Instruction instruct : intent.treatment().allInstructions()) {
            if (!(instruct instanceof L2ModificationInstruction)) continue;
            L2ModificationInstruction l2Mod = (L2ModificationInstruction)instruct;
            if (l2Mod.subtype() == L2ModificationInstruction.L2SubType.VLAN_PUSH) break;
            if (l2Mod.subtype() != L2ModificationInstruction.L2SubType.VLAN_POP && l2Mod.subtype() != L2ModificationInstruction.L2SubType.VLAN_ID) continue;
            selector.matchVlanId(VlanId.ANY);
        }
        if (intent.egressLabel().isPresent()) {
            treat.setMpls((MplsLabel)intent.egressLabel().get());
        } else {
            treat.popMpls(this.outputEthType(intent.selector()));
        }
        treat.setOutput(link.src().port());
        return this.createFlowRule(intent, link.src().deviceId(), selector.build(), treat.build());
    }

    protected FlowRule createFlowRule(MplsPathIntent intent, DeviceId deviceId, TrafficSelector selector, TrafficTreatment treat) {
        return DefaultFlowRule.builder().forDevice(deviceId).withSelector(selector).withTreatment(treat).withPriority(intent.priority()).fromApp(this.appId).makePermanent().build();
    }

    private EthType outputEthType(TrafficSelector selector) {
        Criterion c = selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (c != null && c instanceof EthTypeCriterion) {
            EthTypeCriterion ethertype = (EthTypeCriterion)c;
            return ethertype.ethType();
        }
        return EthType.EtherType.IPV4.ethType();
    }

    protected void bindIntentExtensionService(IntentExtensionService intentExtensionService) {
        this.intentExtensionService = intentExtensionService;
    }

    protected void unbindIntentExtensionService(IntentExtensionService intentExtensionService) {
        if (this.intentExtensionService == intentExtensionService) {
            this.intentExtensionService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }
}

