/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.Identifier;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.PortNumber;
import org.onosproject.net.domain.DomainId;
import org.onosproject.net.domain.DomainService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.intent.FlowObjectiveIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.constraint.EncapsulationConstraint;
import org.onosproject.net.intent.impl.compiler.IntentConfigurableRegistrator;
import org.onosproject.net.intent.impl.compiler.LinkCollectionCompiler;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.impl.LabelAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class LinkCollectionIntentObjectiveCompiler
extends LinkCollectionCompiler<Objective>
implements IntentCompiler<LinkCollectionIntent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentConfigurableRegistrator registrator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DomainService domainService;
    private ApplicationId appId;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.net.intent");
        this.registrator.registerCompiler(LinkCollectionIntent.class, this, true);
        if (labelAllocator == null) {
            labelAllocator = new LabelAllocator(this.resourceService);
        }
    }

    @Deactivate
    public void deactivate() {
        this.registrator.unregisterCompiler(LinkCollectionIntent.class, true);
    }

    public List<Intent> compile(LinkCollectionIntent intent, List<Intent> installable) {
        HashMultimap inputPorts = HashMultimap.create();
        HashMultimap outputPorts = HashMultimap.create();
        Object labels = ImmutableMap.of();
        Optional<EncapsulationConstraint> encapConstraint = this.getIntentEncapConstraint(intent);
        this.computePorts(intent, (SetMultimap<DeviceId, PortNumber>)inputPorts, (SetMultimap<DeviceId, PortNumber>)outputPorts);
        if (encapConstraint.isPresent()) {
            labels = labelAllocator.assignLabelToPorts(intent.links(), (ResourceConsumer)intent.key(), encapConstraint.get().encapType());
        }
        ImmutableList.Builder intentList = ImmutableList.builder();
        if (this.isDomainProcessingEnabled(intent)) {
            intentList.addAll(this.getDomainIntents(intent, this.domainService));
        }
        ArrayList objectives = new ArrayList();
        ArrayList devices = new ArrayList();
        for (DeviceId deviceId : outputPorts.keySet()) {
            if (!DomainId.LOCAL.equals((Object)this.domainService.getDomain(deviceId))) continue;
            List<Objective> deviceObjectives = this.createRules(intent, deviceId, inputPorts.get((Object)deviceId), outputPorts.get((Object)deviceId), (Map<ConnectPoint, Identifier<?>>)labels);
            deviceObjectives.forEach(objective -> {
                objectives.add(objective);
                devices.add(deviceId);
            });
        }
        if (!objectives.isEmpty()) {
            intentList.add((Object)new FlowObjectiveIntent(this.appId, intent.key(), devices, objectives, intent.resources(), intent.resourceGroup()));
        }
        return intentList.build();
    }

    @Override
    boolean optimizeTreatments() {
        return false;
    }

    @Override
    protected List<Objective> createRules(LinkCollectionIntent intent, DeviceId deviceId, Set<PortNumber> inPorts, Set<PortNumber> outPorts, Map<ConnectPoint, Identifier<?>> labels) {
        ArrayList<Objective> objectives = new ArrayList<Objective>(inPorts.size() * 2);
        Optional<EncapsulationConstraint> encapConstraint = this.getIntentEncapConstraint(intent);
        inPorts.forEach(inPort -> {
            LinkCollectionCompiler.ForwardingInstructions instructions = this.createForwardingInstruction(encapConstraint, intent, (PortNumber)inPort, outPorts, deviceId, labels);
            HashSet treatmentsWithDifferentPort = Sets.newHashSet();
            TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
            for (Instruction inst : instructions.treatment().allInstructions()) {
                if (inst.type() == Instruction.Type.OUTPUT) {
                    treatmentBuilder.add(inst);
                    treatmentsWithDifferentPort.add(treatmentBuilder.build());
                    treatmentBuilder = DefaultTrafficTreatment.builder();
                    continue;
                }
                treatmentBuilder.add(inst);
            }
            EthCriterion ethDst = (EthCriterion)intent.selector().getCriterion(Criterion.Type.ETH_DST);
            boolean broadcastObjective = ethDst != null && (ethDst.mac().isBroadcast() || ethDst.mac().isMulticast());
            FilteringObjective filteringObjective = this.buildFilteringObjective(intent, instructions.selector(), deviceId, (PortNumber)inPort);
            if (filteringObjective != null) {
                objectives.add((Objective)filteringObjective);
            }
            if (treatmentsWithDifferentPort.size() < 2 && !broadcastObjective) {
                objectives.addAll(this.createSimpleNextObjective(instructions, intent));
            } else {
                objectives.addAll(this.createBroadcastObjective(instructions, treatmentsWithDifferentPort, intent));
            }
        });
        return objectives;
    }

    private List<Objective> createBroadcastObjective(LinkCollectionCompiler.ForwardingInstructions instructions, Set<TrafficTreatment> treatmentsWithDifferentPort, LinkCollectionIntent intent) {
        ArrayList objectives = Lists.newArrayList();
        Integer nextId = this.flowObjectiveService.allocateNextId();
        ForwardingObjective forwardingObjective = this.buildForwardingObjective(instructions.selector(), nextId, intent.priority());
        DefaultNextObjective.Builder nxBuilder = DefaultNextObjective.builder();
        nxBuilder.withId(nextId.intValue()).withMeta(instructions.selector()).withType(NextObjective.Type.BROADCAST).fromApp(this.appId).withPriority(intent.priority()).makePermanent();
        treatmentsWithDifferentPort.forEach(arg_0 -> ((DefaultNextObjective.Builder)nxBuilder).addTreatment(arg_0));
        NextObjective nextObjective = nxBuilder.add();
        objectives.add(forwardingObjective);
        objectives.add(nextObjective);
        return objectives;
    }

    private List<Objective> createSimpleNextObjective(LinkCollectionCompiler.ForwardingInstructions instructions, LinkCollectionIntent intent) {
        ArrayList objectives = Lists.newArrayList();
        Integer nextId = this.flowObjectiveService.allocateNextId();
        ForwardingObjective forwardingObjective = this.buildForwardingObjective(instructions.selector(), nextId, intent.priority());
        DefaultNextObjective.Builder nxBuilder = DefaultNextObjective.builder();
        NextObjective nextObjective = nxBuilder.withId(nextId.intValue()).withMeta(instructions.selector()).addTreatment(instructions.treatment()).withType(NextObjective.Type.SIMPLE).fromApp(this.appId).makePermanent().withPriority(intent.priority()).add();
        objectives.add(forwardingObjective);
        objectives.add(nextObjective);
        return objectives;
    }

    private ForwardingObjective buildForwardingObjective(TrafficSelector selector, Integer nextId, int priority) {
        return DefaultForwardingObjective.builder().withMeta(selector).withSelector(selector).nextStep(nextId.intValue()).fromApp(this.appId).withPriority(priority).withFlag(ForwardingObjective.Flag.SPECIFIC).makePermanent().add();
    }

    private FilteringObjective buildFilteringObjective(LinkCollectionIntent intent, TrafficSelector selector, DeviceId deviceId, PortNumber inPort) {
        DefaultFilteringObjective.Builder builder = DefaultFilteringObjective.builder();
        builder.fromApp(this.appId).permit().makePermanent().withPriority(intent.priority());
        Criterion inPortCriterion = selector.getCriterion(Criterion.Type.IN_PORT);
        if (inPortCriterion != null) {
            builder.withKey(inPortCriterion);
        }
        FilteredConnectPoint ingressPoint = intent.filteredIngressPoints().stream().filter(fcp -> fcp.connectPoint().equals((Object)new ConnectPoint((ElementId)deviceId, inPort))).filter(fcp -> selector.criteria().containsAll(fcp.trafficSelector().criteria())).findFirst().orElse(null);
        AtomicBoolean emptyCondition = new AtomicBoolean(true);
        if (ingressPoint != null) {
            ingressPoint.trafficSelector().criteria().forEach(arg_0 -> LinkCollectionIntentObjectiveCompiler.lambda$buildFilteringObjective$4((FilteringObjective.Builder)builder, emptyCondition, arg_0));
            if (emptyCondition.get()) {
                return null;
            }
            return builder.add();
        }
        Optional<EncapsulationConstraint> encapConstraint = this.getIntentEncapConstraint(intent);
        if (encapConstraint.isPresent() && !encapConstraint.get().encapType().equals((Object)EncapsulationType.NONE)) {
            EncapsulationConstraint encap = encapConstraint.get();
            switch (encap.encapType()) {
                case VLAN: {
                    builder.addCondition(selector.getCriterion(Criterion.Type.VLAN_VID));
                    emptyCondition.set(false);
                    break;
                }
                case MPLS: {
                    builder.addCondition(selector.getCriterion(Criterion.Type.MPLS_LABEL));
                    emptyCondition.set(false);
                    break;
                }
                default: {
                    this.log.warn("No filtering rule found because of unknown encapsulation type.");
                    break;
                }
            }
        } else if (intent.applyTreatmentOnEgress()) {
            ingressPoint = intent.filteredIngressPoints().stream().findFirst().orElse(null);
            if (ingressPoint == null) {
                this.log.warn("No filtering rule found because no ingress point in the Intent");
            } else {
                ingressPoint.trafficSelector().criteria().stream().filter(criterion -> !criterion.type().equals((Object)Criterion.Type.IN_PORT)).forEach(arg_0 -> LinkCollectionIntentObjectiveCompiler.lambda$buildFilteringObjective$6((FilteringObjective.Builder)builder, emptyCondition, arg_0));
            }
        } else {
            FilteredConnectPoint egressPoint = intent.filteredEgressPoints().stream().findFirst().orElse(null);
            if (egressPoint == null) {
                this.log.warn("No filtering rule found because no egress point in the Intent");
            } else {
                egressPoint.trafficSelector().criteria().stream().filter(criterion -> !criterion.type().equals((Object)Criterion.Type.IN_PORT)).forEach(arg_0 -> LinkCollectionIntentObjectiveCompiler.lambda$buildFilteringObjective$8((FilteringObjective.Builder)builder, emptyCondition, arg_0));
            }
        }
        if (emptyCondition.get()) {
            return null;
        }
        return builder.add();
    }

    private static /* synthetic */ void lambda$buildFilteringObjective$8(FilteringObjective.Builder builder, AtomicBoolean emptyCondition, Criterion criterion) {
        builder.addCondition(criterion);
        emptyCondition.set(false);
    }

    private static /* synthetic */ void lambda$buildFilteringObjective$6(FilteringObjective.Builder builder, AtomicBoolean emptyCondition, Criterion criterion) {
        builder.addCondition(criterion);
        emptyCondition.set(false);
    }

    private static /* synthetic */ void lambda$buildFilteringObjective$4(FilteringObjective.Builder builder, AtomicBoolean emptyCondition, Criterion criterion) {
        builder.addCondition(criterion);
        emptyCondition.set(false);
    }

    protected void bindRegistrator(IntentConfigurableRegistrator intentConfigurableRegistrator) {
        this.registrator = intentConfigurableRegistrator;
    }

    protected void unbindRegistrator(IntentConfigurableRegistrator intentConfigurableRegistrator) {
        if (this.registrator == intentConfigurableRegistrator) {
            this.registrator = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }

    protected void bindDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    protected void unbindDomainService(DomainService domainService) {
        if (this.domainService == domainService) {
            this.domainService = null;
        }
    }
}

