/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.Identifier;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.intent.FlowObjectiveIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.constraint.EncapsulationConstraint;
import org.onosproject.net.intent.impl.compiler.IntentConfigurableRegistrator;
import org.onosproject.net.intent.impl.compiler.LinkCollectionCompiler;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.impl.LabelAllocator;

@Deprecated
@Component(immediate=true)
public class LinkCollectionIntentFlowObjectiveCompiler
extends LinkCollectionCompiler<Objective>
implements IntentCompiler<LinkCollectionIntent> {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentConfigurableRegistrator registrator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    private ApplicationId appId;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.net.intent");
        this.registrator.registerCompiler(LinkCollectionIntent.class, this, true);
        if (labelAllocator == null) {
            labelAllocator = new LabelAllocator(this.resourceService);
        }
    }

    @Deactivate
    public void deactivate() {
        this.registrator.unregisterCompiler(LinkCollectionIntent.class, true);
    }

    public List<Intent> compile(LinkCollectionIntent intent, List<Intent> installable) {
        HashMultimap inputPorts = HashMultimap.create();
        HashMultimap outputPorts = HashMultimap.create();
        Object labels = ImmutableMap.of();
        Optional<EncapsulationConstraint> encapConstraint = this.getIntentEncapConstraint(intent);
        this.computePorts(intent, (SetMultimap<DeviceId, PortNumber>)inputPorts, (SetMultimap<DeviceId, PortNumber>)outputPorts);
        if (encapConstraint.isPresent()) {
            labels = labelAllocator.assignLabelToPorts(intent.links(), (ResourceConsumer)intent.key(), encapConstraint.get().encapType());
        }
        ArrayList objectives = new ArrayList();
        ArrayList devices = new ArrayList();
        for (DeviceId deviceId : outputPorts.keys()) {
            List<Objective> deviceObjectives = this.createRules(intent, deviceId, inputPorts.get((Object)deviceId), outputPorts.get((Object)deviceId), (Map<ConnectPoint, Identifier<?>>)labels);
            deviceObjectives.forEach(objective -> {
                objectives.add(objective);
                devices.add(deviceId);
            });
        }
        return Collections.singletonList(new FlowObjectiveIntent(this.appId, intent.key(), devices, objectives, intent.resources(), intent.resourceGroup()));
    }

    @Override
    boolean optimizeTreatments() {
        return false;
    }

    @Override
    protected List<Objective> createRules(LinkCollectionIntent intent, DeviceId deviceId, Set<PortNumber> inPorts, Set<PortNumber> outPorts, Map<ConnectPoint, Identifier<?>> labels) {
        ArrayList<Objective> objectives = new ArrayList<Objective>(inPorts.size());
        Optional<EncapsulationConstraint> encapConstraint = this.getIntentEncapConstraint(intent);
        inPorts.forEach(inport -> {
            LinkCollectionCompiler.ForwardingInstructions instructions = this.createForwardingInstruction(encapConstraint, intent, (PortNumber)inport, outPorts, deviceId, labels);
            NextObjective nextObjective = DefaultNextObjective.builder().withId(this.flowObjectiveService.allocateNextId()).addTreatment(instructions.treatment()).withType(NextObjective.Type.SIMPLE).fromApp(this.appId).makePermanent().add();
            objectives.add((Objective)nextObjective);
            objectives.add((Objective)DefaultForwardingObjective.builder().withSelector(instructions.selector()).nextStep(nextObjective.id()).withPriority(intent.priority()).fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.SPECIFIC).add());
        });
        return objectives;
    }

    protected void bindRegistrator(IntentConfigurableRegistrator intentConfigurableRegistrator) {
        this.registrator = intentConfigurableRegistrator;
    }

    protected void unbindRegistrator(IntentConfigurableRegistrator intentConfigurableRegistrator) {
        if (this.registrator == intentConfigurableRegistrator) {
            this.registrator = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }
}

