/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.Identifier;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.domain.DomainId;
import org.onosproject.net.domain.DomainService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompilationException;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.constraint.EncapsulationConstraint;
import org.onosproject.net.intent.impl.compiler.IntentConfigurableRegistrator;
import org.onosproject.net.intent.impl.compiler.LinkCollectionCompiler;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.impl.LabelAllocator;

@Component(immediate=true)
public class LinkCollectionIntentCompiler
extends LinkCollectionCompiler<FlowRule>
implements IntentCompiler<LinkCollectionIntent> {
    private static final String UNKNOWN_INSTRUCTION = "Unknown instruction type";
    private static final String UNSUPPORTED_INSTRUCTION = "Unsupported %s instruction";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentConfigurableRegistrator registrator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DomainService domainService;
    private ApplicationId appId;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.net.intent");
        this.registrator.registerCompiler(LinkCollectionIntent.class, this, false);
        if (labelAllocator == null) {
            labelAllocator = new LabelAllocator(this.resourceService);
        }
    }

    @Deactivate
    public void deactivate() {
        this.registrator.unregisterCompiler(LinkCollectionIntent.class, false);
    }

    public List<Intent> compile(LinkCollectionIntent intent, List<Intent> installable) {
        HashMultimap inputPorts = HashMultimap.create();
        HashMultimap outputPorts = HashMultimap.create();
        Object labels = ImmutableMap.of();
        Optional<EncapsulationConstraint> encapConstraint = this.getIntentEncapConstraint(intent);
        this.computePorts(intent, (SetMultimap<DeviceId, PortNumber>)inputPorts, (SetMultimap<DeviceId, PortNumber>)outputPorts);
        if (encapConstraint.isPresent()) {
            labels = labelAllocator.assignLabelToPorts(intent.links(), (ResourceConsumer)intent.key(), encapConstraint.get().encapType());
        }
        ImmutableList.Builder intentList = ImmutableList.builder();
        if (this.isDomainProcessingEnabled(intent)) {
            intentList.addAll(this.getDomainIntents(intent, this.domainService));
        }
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        for (DeviceId deviceId : outputPorts.keySet()) {
            if (!DomainId.LOCAL.equals((Object)this.domainService.getDomain(deviceId))) continue;
            rules.addAll(this.createRules(intent, deviceId, inputPorts.get((Object)deviceId), outputPorts.get((Object)deviceId), (Map<ConnectPoint, Identifier<?>>)labels));
        }
        if (!rules.isEmpty()) {
            intentList.add((Object)new FlowRuleIntent(this.appId, intent.key(), rules, intent.resources()));
        }
        return intentList.build();
    }

    @Override
    boolean optimizeTreatments() {
        return true;
    }

    @Override
    protected List<FlowRule> createRules(LinkCollectionIntent intent, DeviceId deviceId, Set<PortNumber> inPorts, Set<PortNumber> outPorts, Map<ConnectPoint, Identifier<?>> labels) {
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>(inPorts.size());
        Optional<EncapsulationConstraint> encapConstraint = this.getIntentEncapConstraint(intent);
        inPorts.forEach(inport -> {
            LinkCollectionCompiler.ForwardingInstructions instructions = this.createForwardingInstruction(encapConstraint, intent, (PortNumber)inport, outPorts, deviceId, labels);
            if (optimizeInstructions) {
                TrafficTreatment compactedTreatment = this.compactActions(instructions.treatment());
                instructions = new LinkCollectionCompiler.ForwardingInstructions(compactedTreatment, instructions.selector());
            }
            FlowRule rule = DefaultFlowRule.builder().forDevice(deviceId).withSelector(instructions.selector()).withTreatment(instructions.treatment()).withPriority(intent.priority()).fromApp(this.appId).makePermanent().build();
            rules.add(rule);
        });
        return rules;
    }

    private TrafficTreatment compactActions(TrafficTreatment oldTreatment) {
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        for (int index = 0; index < oldTreatment.allInstructions().size(); ++index) {
            Instruction instruction = (Instruction)oldTreatment.allInstructions().get(index);
            if (this.checkInstruction(instruction)) {
                treatmentBuilder.add(instruction);
                continue;
            }
            Instruction newInstruction = this.optimizeInstruction(index, instruction, oldTreatment.allInstructions());
            if (newInstruction.type().equals((Object)Instruction.Type.NOACTION)) continue;
            treatmentBuilder.add(newInstruction);
        }
        return treatmentBuilder.build();
    }

    private boolean checkL2Instructions(L2ModificationInstruction l2instruction) {
        switch (l2instruction.subtype()) {
            case ETH_SRC: 
            case ETH_DST: 
            case VLAN_ID: 
            case VLAN_PCP: 
            case MPLS_LABEL: 
            case MPLS_BOS: 
            case TUNNEL_ID: 
            case VLAN_PUSH: 
            case VLAN_POP: 
            case MPLS_PUSH: 
            case MPLS_POP: {
                return true;
            }
            case DEC_MPLS_TTL: {
                return false;
            }
        }
        throw new IntentCompilationException(String.format(UNSUPPORTED_INSTRUCTION, "L2"));
    }

    private boolean checkL3Instructions(L3ModificationInstruction l3instruction) {
        switch (l3instruction.subtype()) {
            case IPV4_SRC: 
            case IPV4_DST: 
            case IPV6_SRC: 
            case IPV6_DST: 
            case IPV6_FLABEL: 
            case ARP_SPA: 
            case ARP_SHA: 
            case ARP_OP: 
            case TTL_OUT: 
            case TTL_IN: {
                return true;
            }
            case DEC_TTL: {
                return false;
            }
        }
        throw new IntentCompilationException(String.format(UNSUPPORTED_INSTRUCTION, "L3"));
    }

    private Instruction optimizeTtlInstructions(int index, Instruction instruction, List<Instruction> instructions) {
        for (int i = index - 1; i >= 0; --i) {
            Instruction currentInstruction = instructions.get(i);
            if (!currentInstruction.equals(instruction)) continue;
            return Instructions.createNoAction();
        }
        return instruction;
    }

    private Instruction optimizeInstruction(int index, Instruction instruction, List<Instruction> instructions) {
        switch (instruction.type()) {
            case L2MODIFICATION: 
            case L3MODIFICATION: {
                return this.optimizeTtlInstructions(index, instruction, instructions);
            }
        }
        throw new IntentCompilationException(UNKNOWN_INSTRUCTION);
    }

    private boolean checkInstruction(Instruction instruction) {
        switch (instruction.type()) {
            case L0MODIFICATION: 
            case L1MODIFICATION: 
            case L4MODIFICATION: 
            case NOACTION: 
            case OUTPUT: 
            case GROUP: 
            case QUEUE: 
            case TABLE: 
            case METER: 
            case METADATA: 
            case EXTENSION: {
                return true;
            }
            case L2MODIFICATION: {
                return this.checkL2Instructions((L2ModificationInstruction)instruction);
            }
            case L3MODIFICATION: {
                return this.checkL3Instructions((L3ModificationInstruction)instruction);
            }
        }
        throw new IntentCompilationException(UNKNOWN_INSTRUCTION);
    }

    protected void bindRegistrator(IntentConfigurableRegistrator intentConfigurableRegistrator) {
        this.registrator = intentConfigurableRegistrator;
    }

    protected void unbindRegistrator(IntentConfigurableRegistrator intentConfigurableRegistrator) {
        if (this.registrator == intentConfigurableRegistrator) {
            this.registrator = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }

    protected void bindDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    protected void unbindDomainService(DomainService domainService) {
        if (this.domainService == domainService) {
            this.domainService = null;
        }
    }
}

