/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onlab.util.Identifier;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.domain.DomainId;
import org.onosproject.net.domain.DomainPointToPointIntent;
import org.onosproject.net.domain.DomainService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.TunnelIdCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L1ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flow.instructions.L4ModificationInstruction;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompilationException;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.constraint.DomainConstraint;
import org.onosproject.net.intent.constraint.EncapsulationConstraint;
import org.onosproject.net.resource.impl.LabelAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LinkCollectionCompiler<T> {
    static LabelAllocator labelAllocator;
    static boolean optimizeInstructions;
    static boolean copyTtl;
    private static final Set<Criterion.Type> TAG_CRITERION_TYPES;
    private static final String WRONG_EGRESS = "Egress points not equal to 1 and apply treatment at ingress, which treatments should I apply ???";
    private static final String WRONG_INGRESS = "Ingress points not equal to 1 and apply treatment at egress, how can I match in the core ???";
    private static final String WRONG_ENCAPSULATION = "Wrong scenario - 1 hop with encapsualtion";
    private static final String NO_LABELS = "No available label for %s";
    private static final String UNKNOWN_ENCAPSULATION = "Unknown encapsulation type";
    private static final String UNSUPPORTED_L0 = "L0 not supported";
    private static final String UNSUPPORTED_L1 = "L1 not supported";
    private static final String UNSUPPORTED_ETH_SUBTYPE = "Bad eth subtype";
    private static final String UNSUPPORTED_POP_ACTION = "Can't handle pop label";
    private static final String UNSUPPORTED_L2 = "Unknown L2 Modification instruction";
    private static final String UNSUPPORTED_IP_SUBTYPE = "Bad ip subtype";
    private static final String UNSUPPORTED_ARP = "IPv6 not supported for ARP";
    private static final String UNSUPPORTED_L3 = "Unknown L3 Modification instruction";
    private static final String UNSUPPORTED_L4_SUBTYPE = "Unknown L4 subtype";
    private static final String UNSUPPORTED_L4 = "Unknown L4 Modification instruction";
    private static final String UNSUPPORTED_INSTRUCTION = "Unknown instruction type";
    private static Logger log;

    abstract boolean optimizeTreatments();

    protected List<T> createRules(LinkCollectionIntent intent, DeviceId deviceId, Set<PortNumber> inPorts, Set<PortNumber> outPorts, Map<ConnectPoint, Identifier<?>> labels) {
        return null;
    }

    protected ForwardingInstructions createForwardingInstruction(Optional<EncapsulationConstraint> encapConstraint, LinkCollectionIntent intent, PortNumber inPort, Set<PortNumber> outPorts, DeviceId deviceId, Map<ConnectPoint, Identifier<?>> labels) {
        ForwardingInstructions instructions = null;
        if (!encapConstraint.isPresent() || intent.links().isEmpty()) {
            instructions = this.createForwardingInstructions(intent, inPort, deviceId, outPorts);
        } else {
            Identifier<?> inLabel = labels.get(new ConnectPoint((ElementId)deviceId, inPort));
            HashMap outLabels = Maps.newHashMap();
            outPorts.forEach(outPort -> {
                ConnectPoint key = new ConnectPoint((ElementId)deviceId, outPort);
                outLabels.put(key, labels.get(key));
            });
            instructions = this.createForwardingInstructions(intent, inPort, inLabel, deviceId, outPorts, outLabels, encapConstraint.get().encapType());
        }
        return instructions;
    }

    private void manageOutputPorts(Set<PortNumber> outPorts, DeviceId deviceId, LinkCollectionIntent intent, Map<ConnectPoint, Identifier<?>> outLabels, EncapsulationType type, TrafficSelector.Builder preCondition, TrafficTreatment.Builder treatmentBuilder) {
        List<Object> egressPoints = Lists.newArrayList();
        for (PortNumber outPort : outPorts) {
            Optional<FilteredConnectPoint> filteredEgressPoint = this.getFilteredConnectPointFromIntent(deviceId, outPort, intent);
            if (!filteredEgressPoint.isPresent()) {
                TrafficSelector.Builder encapBuilder = DefaultTrafficSelector.builder();
                ConnectPoint cp = new ConnectPoint((ElementId)deviceId, outPort);
                Identifier<?> outLabel = outLabels.get(cp);
                if (outLabel == null) {
                    throw new IntentCompilationException(String.format(NO_LABELS, cp));
                }
                this.updateSelectorFromEncapsulation(encapBuilder, type, outLabel);
                TrafficTreatment forwardingTreatment = this.forwardingTreatment(preCondition.build(), encapBuilder.build(), this.getEthType(intent.selector()));
                forwardingTreatment.allInstructions().stream().filter(inst -> inst.type() != Instruction.Type.NOACTION).forEach(arg_0 -> ((TrafficTreatment.Builder)treatmentBuilder).add(arg_0));
                treatmentBuilder.setOutput(outPort);
                if (!this.optimizeTreatments()) continue;
                preCondition = encapBuilder;
                continue;
            }
            egressPoints.add(filteredEgressPoint.get());
        }
        TrafficSelector prevState = preCondition.build();
        if (this.optimizeTreatments()) {
            egressPoints = this.orderedEgressPoints(prevState, (List<FilteredConnectPoint>)egressPoints);
        }
        this.generateEgressActions(treatmentBuilder, (List<FilteredConnectPoint>)egressPoints, prevState, intent);
    }

    private void generateEgressActions(TrafficTreatment.Builder treatmentBuilder, List<FilteredConnectPoint> egressPoints, TrafficSelector initialState, LinkCollectionIntent intent) {
        TrafficSelector prevState = initialState;
        for (FilteredConnectPoint egressPoint : egressPoints) {
            intent.treatment().allInstructions().stream().filter(inst -> inst.type() != Instruction.Type.NOACTION).forEach(arg_0 -> ((TrafficTreatment.Builder)treatmentBuilder).add(arg_0));
            TrafficTreatment forwardingTreatment = this.forwardingTreatment(prevState, egressPoint.trafficSelector(), this.getEthType(intent.selector()));
            forwardingTreatment.allInstructions().stream().filter(inst -> inst.type() != Instruction.Type.NOACTION).forEach(arg_0 -> ((TrafficTreatment.Builder)treatmentBuilder).add(arg_0));
            treatmentBuilder.setOutput(egressPoint.connectPoint().port());
            if (!this.optimizeTreatments()) continue;
            prevState = egressPoint.trafficSelector();
        }
    }

    private List<FilteredConnectPoint> orderedEgressPoints(TrafficSelector orderCriteria, List<FilteredConnectPoint> pointsToOrder) {
        Criterion vlanIdCriterion = orderCriteria.getCriterion(Criterion.Type.VLAN_VID);
        Criterion mplsLabelCriterion = orderCriteria.getCriterion(Criterion.Type.MPLS_LABEL);
        List untaggedEgressPoints = pointsToOrder.stream().filter(pointToOrder -> {
            TrafficSelector selector = pointToOrder.trafficSelector();
            return selector.getCriterion(Criterion.Type.VLAN_VID) == null && selector.getCriterion(Criterion.Type.MPLS_LABEL) == null;
        }).collect(Collectors.toList());
        List vlanEgressPoints = pointsToOrder.stream().filter(pointToOrder -> {
            TrafficSelector selector = pointToOrder.trafficSelector();
            return selector.getCriterion(Criterion.Type.VLAN_VID) != null && selector.getCriterion(Criterion.Type.MPLS_LABEL) == null;
        }).collect(Collectors.toList());
        List mplsEgressPoints = pointsToOrder.stream().filter(pointToOrder -> {
            TrafficSelector selector = pointToOrder.trafficSelector();
            return selector.getCriterion(Criterion.Type.VLAN_VID) == null && selector.getCriterion(Criterion.Type.MPLS_LABEL) != null;
        }).collect(Collectors.toList());
        ArrayList orderedList = Lists.newArrayList();
        if (vlanIdCriterion != null && mplsLabelCriterion == null) {
            orderedList.addAll(vlanEgressPoints);
            orderedList.addAll(untaggedEgressPoints);
            orderedList.addAll(mplsEgressPoints);
            return orderedList;
        }
        if (vlanIdCriterion == null && mplsLabelCriterion != null) {
            orderedList.addAll(mplsEgressPoints);
            orderedList.addAll(untaggedEgressPoints);
            orderedList.addAll(vlanEgressPoints);
            return orderedList;
        }
        if (vlanIdCriterion == null && mplsLabelCriterion == null) {
            orderedList.addAll(untaggedEgressPoints);
            orderedList.addAll(vlanEgressPoints);
            orderedList.addAll(mplsEgressPoints);
            return orderedList;
        }
        orderedList.addAll(vlanEgressPoints);
        orderedList.addAll(mplsEgressPoints);
        orderedList.addAll(untaggedEgressPoints);
        return orderedList;
    }

    private void manageSpIntent(TrafficSelector.Builder selectorBuilder, TrafficTreatment.Builder treatmentBuilder, LinkCollectionIntent intent, DeviceId deviceId, Set<PortNumber> outPorts) {
        if (intent.filteredIngressPoints().size() != 1) {
            throw new IntentCompilationException(WRONG_INGRESS);
        }
        Optional filteredIngressPoint = intent.filteredIngressPoints().stream().findFirst();
        ((FilteredConnectPoint)filteredIngressPoint.get()).trafficSelector().criteria().forEach(arg_0 -> ((TrafficSelector.Builder)selectorBuilder).add(arg_0));
        List<Object> egressPoints = Lists.newArrayList();
        for (PortNumber outPort : outPorts) {
            Optional<FilteredConnectPoint> filteredEgressPoint = this.getFilteredConnectPointFromIntent(deviceId, outPort, intent);
            if (!filteredEgressPoint.isPresent()) {
                treatmentBuilder.setOutput(outPort);
                continue;
            }
            egressPoints.add(filteredEgressPoint.get());
        }
        TrafficSelector prevState = ((FilteredConnectPoint)filteredIngressPoint.get()).trafficSelector();
        if (this.optimizeTreatments()) {
            egressPoints = this.orderedEgressPoints(prevState, (List<FilteredConnectPoint>)egressPoints);
        }
        this.generateEgressActions(treatmentBuilder, (List<FilteredConnectPoint>)egressPoints, prevState, intent);
    }

    private void manageMpIntent(TrafficSelector.Builder selectorBuilder, TrafficTreatment.Builder treatmentBuilder, LinkCollectionIntent intent, PortNumber inPort, DeviceId deviceId, Set<PortNumber> outPorts) {
        if (intent.filteredEgressPoints().size() != 1) {
            throw new IntentCompilationException(WRONG_EGRESS);
        }
        Optional<FilteredConnectPoint> filteredIngressPoint = this.getFilteredConnectPointFromIntent(deviceId, inPort, intent);
        Optional filteredEgressPoint = intent.filteredEgressPoints().stream().findFirst();
        if (filteredIngressPoint.isPresent()) {
            intent.treatment().allInstructions().stream().filter(inst -> inst.type() != Instruction.Type.NOACTION).forEach(arg_0 -> ((TrafficTreatment.Builder)treatmentBuilder).add(arg_0));
            filteredIngressPoint.get().trafficSelector().criteria().forEach(arg_0 -> ((TrafficSelector.Builder)selectorBuilder).add(arg_0));
            TrafficTreatment forwardingTreatment = this.forwardingTreatment(filteredIngressPoint.get().trafficSelector(), ((FilteredConnectPoint)filteredEgressPoint.get()).trafficSelector(), this.getEthType(intent.selector()));
            forwardingTreatment.allInstructions().stream().filter(inst -> inst.type() != Instruction.Type.NOACTION).forEach(arg_0 -> ((TrafficTreatment.Builder)treatmentBuilder).add(arg_0));
        } else {
            this.updateBuilder(selectorBuilder, intent.treatment());
            ((FilteredConnectPoint)filteredEgressPoint.get()).trafficSelector().criteria().forEach(arg_0 -> ((TrafficSelector.Builder)selectorBuilder).add(arg_0));
        }
        outPorts.forEach(arg_0 -> ((TrafficTreatment.Builder)treatmentBuilder).setOutput(arg_0));
    }

    protected ForwardingInstructions createForwardingInstructions(LinkCollectionIntent intent, PortNumber inPort, DeviceId deviceId, Set<PortNumber> outPorts) {
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder((TrafficSelector)intent.selector()).matchInPort(inPort);
        if (!intent.applyTreatmentOnEgress()) {
            this.manageMpIntent(selectorBuilder, treatmentBuilder, intent, inPort, deviceId, outPorts);
        } else {
            this.manageSpIntent(selectorBuilder, treatmentBuilder, intent, deviceId, outPorts);
        }
        return new ForwardingInstructions(treatmentBuilder.build(), selectorBuilder.build());
    }

    private void manageEncapAtIngress(TrafficSelector.Builder selectorBuilder, TrafficTreatment.Builder treatmentBuilder, LinkCollectionIntent intent, PortNumber inPort, DeviceId deviceId, Set<PortNumber> outPorts, Map<ConnectPoint, Identifier<?>> outLabels, EncapsulationType type) {
        Optional<FilteredConnectPoint> filteredIngressPoint = this.getFilteredConnectPointFromIntent(deviceId, inPort, intent);
        intent.selector().criteria().forEach(arg_0 -> ((TrafficSelector.Builder)selectorBuilder).add(arg_0));
        filteredIngressPoint.get().trafficSelector().criteria().forEach(arg_0 -> ((TrafficSelector.Builder)selectorBuilder).add(arg_0));
        TrafficSelector.Builder preCondition = DefaultTrafficSelector.builder((TrafficSelector)filteredIngressPoint.get().trafficSelector());
        this.manageOutputPorts(outPorts, deviceId, intent, outLabels, type, preCondition, treatmentBuilder);
    }

    private void manageEncapAtCoreAndEgress(TrafficSelector.Builder selectorBuilder, TrafficTreatment.Builder treatmentBuilder, LinkCollectionIntent intent, PortNumber inPort, Identifier<?> inLabel, DeviceId deviceId, Set<PortNumber> outPorts, Map<ConnectPoint, Identifier<?>> outLabels, EncapsulationType type) {
        ConnectPoint inCp = new ConnectPoint((ElementId)deviceId, inPort);
        if (inLabel == null) {
            throw new IntentCompilationException(String.format(NO_LABELS, inCp));
        }
        this.updateSelectorFromEncapsulation(selectorBuilder, type, inLabel);
        this.manageOutputPorts(outPorts, deviceId, intent, outLabels, type, selectorBuilder, treatmentBuilder);
    }

    protected ForwardingInstructions createForwardingInstructions(LinkCollectionIntent intent, PortNumber inPort, Identifier<?> inLabel, DeviceId deviceId, Set<PortNumber> outPorts, Map<ConnectPoint, Identifier<?>> outLabels, EncapsulationType type) {
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchInPort(inPort);
        Optional<FilteredConnectPoint> filteredIngressPoint = this.getFilteredConnectPointFromIntent(deviceId, inPort, intent);
        if (filteredIngressPoint.isPresent()) {
            this.manageEncapAtIngress(selectorBuilder, treatmentBuilder, intent, inPort, deviceId, outPorts, outLabels, type);
        } else {
            this.manageEncapAtCoreAndEgress(selectorBuilder, treatmentBuilder, intent, inPort, inLabel, deviceId, outPorts, outLabels, type);
        }
        return new ForwardingInstructions(treatmentBuilder.build(), selectorBuilder.build());
    }

    protected void computePorts(LinkCollectionIntent intent, SetMultimap<DeviceId, PortNumber> inputPorts, SetMultimap<DeviceId, PortNumber> outputPorts) {
        for (Link link : intent.links()) {
            inputPorts.put((Object)link.dst().deviceId(), (Object)link.dst().port());
            outputPorts.put((Object)link.src().deviceId(), (Object)link.src().port());
        }
        for (ConnectPoint ingressPoint : intent.ingressPoints()) {
            inputPorts.put((Object)ingressPoint.deviceId(), (Object)ingressPoint.port());
        }
        for (ConnectPoint egressPoint : intent.egressPoints()) {
            outputPorts.put((Object)egressPoint.deviceId(), (Object)egressPoint.port());
        }
    }

    protected Optional<EncapsulationConstraint> getIntentEncapConstraint(LinkCollectionIntent intent) {
        return intent.constraints().stream().filter(constraint -> constraint instanceof EncapsulationConstraint).map(x -> (EncapsulationConstraint)x).findAny();
    }

    protected boolean isDomainProcessingEnabled(LinkCollectionIntent intent) {
        return intent.constraints().contains(DomainConstraint.domain());
    }

    protected List<Intent> getDomainIntents(LinkCollectionIntent intent, DomainService domainService) {
        FilteredConnectPoint egress;
        ImmutableList.Builder intentList = ImmutableList.builder();
        if (intent.filteredIngressPoints().size() != 1 || intent.filteredEgressPoints().size() != 1) {
            log.warn("Multiple ingress or egress ports not supported!");
            return intentList.build();
        }
        ImmutableList.Builder domainLinks = ImmutableList.builder();
        FilteredConnectPoint ingress = (FilteredConnectPoint)intent.filteredIngressPoints().iterator().next();
        DeviceId currentDevice = ingress.connectPoint().deviceId();
        DomainId currentDomain = domainService.getDomain(currentDevice);
        FilteredConnectPoint domainIngress = DomainId.LOCAL.equals((Object)currentDomain) ? null : ingress;
        for (int i = 0; i < intent.links().size(); ++i) {
            List<Link> nextLinks = this.getEgressLinks(intent.links(), currentDevice);
            if (nextLinks.isEmpty()) {
                throw new IntentCompilationException("No matching link starting at " + ingress.connectPoint().deviceId());
            }
            Link nextLink = nextLinks.get(0);
            ingress = new FilteredConnectPoint(nextLink.src());
            egress = new FilteredConnectPoint(nextLink.dst());
            DomainId dstDomain = domainService.getDomain(egress.connectPoint().deviceId());
            if (!currentDomain.equals((Object)dstDomain)) {
                log.debug("Domain transition from {} to {}.", (Object)currentDomain, (Object)dstDomain);
                if (!DomainId.LOCAL.equals((Object)currentDomain)) {
                    intentList.add((Object)LinkCollectionCompiler.createDomainP2PIntent((Intent)intent, domainIngress, ingress, (List<Link>)domainLinks.build()));
                    domainLinks = ImmutableList.builder();
                }
                domainIngress = DomainId.LOCAL.equals((Object)(currentDomain = dstDomain)) ? null : egress;
            } else if (!DomainId.LOCAL.equals((Object)currentDomain)) {
                domainLinks.add((Object)nextLink);
                log.debug("{} belongs to the same domain.", (Object)egress.connectPoint().deviceId());
            }
            currentDevice = egress.connectPoint().deviceId();
        }
        egress = (FilteredConnectPoint)intent.filteredEgressPoints().iterator().next();
        if (!DomainId.LOCAL.equals((Object)currentDomain) && currentDomain.equals((Object)domainService.getDomain(egress.connectPoint().deviceId()))) {
            intentList.add((Object)LinkCollectionCompiler.createDomainP2PIntent((Intent)intent, domainIngress, egress, (List<Link>)domainLinks.build()));
        }
        return intentList.build();
    }

    private static DomainPointToPointIntent createDomainP2PIntent(Intent originalIntent, FilteredConnectPoint ingress, FilteredConnectPoint egress, List<Link> domainLinks) {
        return DomainPointToPointIntent.builder().appId(originalIntent.appId()).filteredIngressPoint(ingress).filteredEgressPoint(egress).key(originalIntent.key()).links(domainLinks).build();
    }

    private List<Link> getEgressLinks(Set<Link> links, DeviceId source) {
        return links.stream().filter(link -> link.src().deviceId().equals((Object)source)).collect(Collectors.toList());
    }

    private Optional<FilteredConnectPoint> getFilteredConnectPointFromIntent(DeviceId deviceId, PortNumber portNumber, LinkCollectionIntent intent) {
        Sets.SetView filteredConnectPoints = Sets.union((Set)intent.filteredIngressPoints(), (Set)intent.filteredEgressPoints());
        return filteredConnectPoints.stream().filter(port -> port.connectPoint().deviceId().equals((Object)deviceId)).filter(port -> port.connectPoint().port().equals((Object)portNumber)).findFirst();
    }

    private Criterion getTagCriterion(TrafficSelector selector) {
        return selector.criteria().stream().filter(criterion -> TAG_CRITERION_TYPES.contains(criterion.type())).findFirst().orElse(Criteria.dummy());
    }

    private TrafficTreatment forwardingTreatment(TrafficSelector ingress, TrafficSelector egress, EthType ethType) {
        if (ingress.equals(egress)) {
            return DefaultTrafficTreatment.emptyTreatment();
        }
        TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
        Criterion ingressTagCriterion = this.getTagCriterion(ingress);
        Criterion egressTagCriterion = this.getTagCriterion(egress);
        if (ingressTagCriterion.type() != egressTagCriterion.type()) {
            switch (ingressTagCriterion.type()) {
                case VLAN_VID: {
                    builder.popVlan();
                    break;
                }
                case MPLS_LABEL: {
                    if (copyTtl) {
                        builder.copyTtlIn();
                    }
                    builder.popMpls(ethType);
                    break;
                }
            }
            switch (egressTagCriterion.type()) {
                case VLAN_VID: {
                    builder.pushVlan();
                    break;
                }
                case MPLS_LABEL: {
                    builder.pushMpls();
                    if (!copyTtl) break;
                    builder.copyTtlOut();
                    break;
                }
            }
        }
        switch (egressTagCriterion.type()) {
            case VLAN_VID: {
                VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)egressTagCriterion;
                builder.setVlanId(vlanIdCriterion.vlanId());
                break;
            }
            case MPLS_LABEL: {
                MplsCriterion mplsCriterion = (MplsCriterion)egressTagCriterion;
                builder.setMpls(mplsCriterion.label());
                break;
            }
            case TUNNEL_ID: {
                TunnelIdCriterion tunnelIdCriterion = (TunnelIdCriterion)egressTagCriterion;
                builder.setTunnelId(tunnelIdCriterion.tunnelId());
                break;
            }
        }
        return builder.build();
    }

    private void updateBuilder(TrafficSelector.Builder builder, L0ModificationInstruction l0instruction) {
        throw new IntentCompilationException(UNSUPPORTED_L0);
    }

    private void updateBuilder(TrafficSelector.Builder builder, L1ModificationInstruction l1instruction) {
        throw new IntentCompilationException(UNSUPPORTED_L1);
    }

    private void updateBuilder(TrafficSelector.Builder builder, L2ModificationInstruction l2instruction) {
        block0 : switch (l2instruction.subtype()) {
            case ETH_SRC: 
            case ETH_DST: {
                L2ModificationInstruction.ModEtherInstruction ethInstr = (L2ModificationInstruction.ModEtherInstruction)l2instruction;
                switch (ethInstr.subtype()) {
                    case ETH_SRC: {
                        builder.matchEthSrc(ethInstr.mac());
                        break block0;
                    }
                    case ETH_DST: {
                        builder.matchEthDst(ethInstr.mac());
                        break block0;
                    }
                }
                throw new IntentCompilationException(UNSUPPORTED_ETH_SUBTYPE);
            }
            case VLAN_ID: {
                L2ModificationInstruction.ModVlanIdInstruction vlanIdInstr = (L2ModificationInstruction.ModVlanIdInstruction)l2instruction;
                builder.matchVlanId(vlanIdInstr.vlanId());
                break;
            }
            case VLAN_PUSH: {
                break;
            }
            case VLAN_POP: {
                throw new IntentCompilationException(UNSUPPORTED_POP_ACTION);
            }
            case VLAN_PCP: {
                L2ModificationInstruction.ModVlanPcpInstruction vlanPcpInstruction = (L2ModificationInstruction.ModVlanPcpInstruction)l2instruction;
                builder.matchVlanPcp(vlanPcpInstruction.vlanPcp());
                break;
            }
            case MPLS_LABEL: 
            case MPLS_PUSH: {
                L2ModificationInstruction.ModMplsLabelInstruction mplsInstr = (L2ModificationInstruction.ModMplsLabelInstruction)l2instruction;
                builder.matchMplsLabel(mplsInstr.label());
                break;
            }
            case MPLS_POP: {
                throw new IntentCompilationException(UNSUPPORTED_POP_ACTION);
            }
            case DEC_MPLS_TTL: {
                break;
            }
            case MPLS_BOS: {
                L2ModificationInstruction.ModMplsBosInstruction mplsBosInstr = (L2ModificationInstruction.ModMplsBosInstruction)l2instruction;
                builder.matchMplsBos(mplsBosInstr.mplsBos());
                break;
            }
            case TUNNEL_ID: {
                L2ModificationInstruction.ModTunnelIdInstruction tunInstr = (L2ModificationInstruction.ModTunnelIdInstruction)l2instruction;
                builder.matchTunnelId(tunInstr.tunnelId());
                break;
            }
            default: {
                throw new IntentCompilationException(UNSUPPORTED_L2);
            }
        }
    }

    private void updateBuilder(TrafficSelector.Builder builder, L3ModificationInstruction l3instruction) {
        block0 : switch (l3instruction.subtype()) {
            case IPV4_SRC: 
            case IPV4_DST: 
            case IPV6_SRC: 
            case IPV6_DST: {
                L3ModificationInstruction.ModIPInstruction ipInstr = (L3ModificationInstruction.ModIPInstruction)l3instruction;
                IpPrefix prefix = ipInstr.ip().toIpPrefix();
                switch (ipInstr.subtype()) {
                    case IPV4_SRC: {
                        builder.matchIPSrc(prefix);
                        break block0;
                    }
                    case IPV4_DST: {
                        builder.matchIPSrc(prefix);
                        break block0;
                    }
                    case IPV6_SRC: {
                        builder.matchIPv6Src(prefix);
                        break block0;
                    }
                    case IPV6_DST: {
                        builder.matchIPv6Dst(prefix);
                        break block0;
                    }
                }
                throw new IntentCompilationException(UNSUPPORTED_IP_SUBTYPE);
            }
            case IPV6_FLABEL: {
                L3ModificationInstruction.ModIPv6FlowLabelInstruction ipFlowInstr = (L3ModificationInstruction.ModIPv6FlowLabelInstruction)l3instruction;
                builder.matchIPv6FlowLabel(ipFlowInstr.flowLabel());
                break;
            }
            case DEC_TTL: {
                break;
            }
            case TTL_OUT: {
                break;
            }
            case TTL_IN: {
                break;
            }
            case ARP_SPA: {
                L3ModificationInstruction.ModArpIPInstruction arpIpInstr = (L3ModificationInstruction.ModArpIPInstruction)l3instruction;
                if (arpIpInstr.ip().isIp4()) {
                    builder.matchArpSpa((Ip4Address)arpIpInstr.ip());
                    break;
                }
                throw new IntentCompilationException(UNSUPPORTED_ARP);
            }
            case ARP_SHA: {
                L3ModificationInstruction.ModArpEthInstruction arpEthInstr = (L3ModificationInstruction.ModArpEthInstruction)l3instruction;
                builder.matchArpSha(arpEthInstr.mac());
                break;
            }
            case ARP_OP: {
                L3ModificationInstruction.ModArpOpInstruction arpOpInstr = (L3ModificationInstruction.ModArpOpInstruction)l3instruction;
                builder.matchArpOp((int)arpOpInstr.op());
                break;
            }
            default: {
                throw new IntentCompilationException(UNSUPPORTED_L3);
            }
        }
    }

    private void updateBuilder(TrafficSelector.Builder builder, L4ModificationInstruction l4instruction) {
        if (l4instruction instanceof L4ModificationInstruction.ModTransportPortInstruction) {
            L4ModificationInstruction.ModTransportPortInstruction l4mod = (L4ModificationInstruction.ModTransportPortInstruction)l4instruction;
            switch (l4mod.subtype()) {
                case TCP_SRC: {
                    builder.matchTcpSrc(l4mod.port());
                    break;
                }
                case TCP_DST: {
                    builder.matchTcpDst(l4mod.port());
                    break;
                }
                case UDP_SRC: {
                    builder.matchUdpSrc(l4mod.port());
                    break;
                }
                case UDP_DST: {
                    builder.matchUdpDst(l4mod.port());
                    break;
                }
                default: {
                    throw new IntentCompilationException(UNSUPPORTED_L4_SUBTYPE);
                }
            }
        } else {
            throw new IntentCompilationException(UNSUPPORTED_L4);
        }
    }

    private void updateBuilder(TrafficSelector.Builder builder, TrafficTreatment treatment) {
        treatment.allInstructions().forEach(instruction -> {
            switch (instruction.type()) {
                case L0MODIFICATION: {
                    this.updateBuilder(builder, (L0ModificationInstruction)instruction);
                    break;
                }
                case L1MODIFICATION: {
                    this.updateBuilder(builder, (L1ModificationInstruction)instruction);
                    break;
                }
                case L2MODIFICATION: {
                    this.updateBuilder(builder, (L2ModificationInstruction)instruction);
                    break;
                }
                case L3MODIFICATION: {
                    this.updateBuilder(builder, (L3ModificationInstruction)instruction);
                    break;
                }
                case L4MODIFICATION: {
                    this.updateBuilder(builder, (L4ModificationInstruction)instruction);
                    break;
                }
                case NOACTION: 
                case OUTPUT: 
                case GROUP: 
                case QUEUE: 
                case TABLE: 
                case METER: 
                case METADATA: 
                case EXTENSION: {
                    break;
                }
                default: {
                    throw new IntentCompilationException(UNSUPPORTED_INSTRUCTION);
                }
            }
        });
    }

    private void updateSelectorFromEncapsulation(TrafficSelector.Builder selectorBuilder, EncapsulationType type, Identifier<?> identifier) {
        switch (type) {
            case MPLS: {
                MplsLabel label = (MplsLabel)identifier;
                selectorBuilder.matchMplsLabel(label);
                selectorBuilder.matchEthType(Ethernet.MPLS_UNICAST);
                break;
            }
            case VLAN: {
                VlanId id = (VlanId)identifier;
                selectorBuilder.matchVlanId(id);
                break;
            }
            default: {
                throw new IntentCompilationException(UNKNOWN_ENCAPSULATION);
            }
        }
    }

    private EthType getEthType(TrafficSelector selector) {
        Criterion c = selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (c != null && c instanceof EthTypeCriterion) {
            EthTypeCriterion ethertype = (EthTypeCriterion)c;
            return ethertype.ethType();
        }
        return EthType.EtherType.IPV4.ethType();
    }

    static {
        TAG_CRITERION_TYPES = Sets.immutableEnumSet((Enum)Criterion.Type.VLAN_VID, (Enum[])new Criterion.Type[]{Criterion.Type.MPLS_LABEL, Criterion.Type.TUNNEL_ID});
        log = LoggerFactory.getLogger(LinkCollectionCompiler.class);
    }

    protected class ForwardingInstructions {
        private TrafficTreatment trafficTreatment;
        private TrafficSelector trafficSelector;

        public ForwardingInstructions(TrafficTreatment treatment, TrafficSelector selector) {
            this.trafficTreatment = treatment;
            this.trafficSelector = selector;
        }

        public TrafficTreatment treatment() {
            return this.trafficTreatment;
        }

        public TrafficSelector selector() {
            return this.trafficSelector;
        }
    }
}

