/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.impl.compiler.LinkCollectionCompiler;
import org.onosproject.net.resource.impl.LabelAllocator;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={IntentConfigurableRegistrator.class})
public class IntentConfigurableRegistrator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService extensionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private static final boolean DEFAULT_FLOW_OBJECTIVES = false;
    @Property(name="useFlowObjectives", boolValue={false}, label="Indicates whether or not to use flow objective-based compilers")
    private boolean useFlowObjectives = false;
    private static final String DEFAULT_LABEL_SELECTION = "RANDOM";
    @Property(name="labelSelection", value={"RANDOM"}, label="Defines the label selection algorithm - RANDOM or FIRST_FIT")
    private String labelSelection = "RANDOM";
    private static final String DEFAULT_OPT_LABEL_SELECTION = "NONE";
    @Property(name="optLabelSelection", value={"NONE"}, label="Defines the optimization for label selection algorithm - NONE, NO_SWAP, MIN_SWAP")
    private String optLabelSelection = "NONE";
    private static final boolean DEFAULT_FLOW_OPTIMIZATION = false;
    @Property(name="optimizeInstructions", boolValue={false}, label="Indicates whether or not to optimize the flows in the link collection compiler")
    private boolean optimizeInstructions = false;
    private static final boolean DEFAULT_COPY_TTL = false;
    @Property(name="useCopyTtl", boolValue={false}, label="Indicates whether or not to use copy ttl in the link collection compiler")
    private boolean useCopyTtl = false;
    private static final String DEFAULT_FLOW_OBJECTIVE_COMPILER = "org.onosproject.net.intent.impl.compiler.LinkCollectionIntentFlowObjectiveCompiler";
    @Deprecated
    @Property(name="defaultFlowObjectiveCompiler", value={"org.onosproject.net.intent.impl.compiler.LinkCollectionIntentFlowObjectiveCompiler"}, label="Default compiler to generate flow objective")
    private String defaultFlowObjectiveCompiler = "org.onosproject.net.intent.impl.compiler.LinkCollectionIntentFlowObjectiveCompiler";
    private final Map<Class<Intent>, IntentCompiler<Intent>> flowRuleBased = Maps.newConcurrentMap();
    private final Map<Class<Intent>, Set<IntentCompiler<Intent>>> flowObjectiveBased = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.cfgService.registerProperties(this.getClass());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        boolean newCopyTtl;
        boolean newFlowOptimization;
        String newOptLabelSelection;
        String newLabelSelection;
        String newDefaultFlowObjectiveCompiler;
        boolean newFlowObjectives;
        if (context == null) {
            this.log.info("Settings: useFlowObjectives={}", (Object)this.useFlowObjectives);
            this.log.info("Settings: labelSelection={}", (Object)this.labelSelection);
            this.log.info("Settings: useFlowOptimization={}", (Object)this.optimizeInstructions);
            this.log.info("Settings: useCopyTtl={}", (Object)this.useCopyTtl);
            this.log.info("Settings: optLabelSelection={}", (Object)this.optLabelSelection);
            this.log.info("Settings: defaultFlowObjectiveCompiler={}", (Object)this.defaultFlowObjectiveCompiler);
            return;
        }
        try {
            String s = Tools.get((Dictionary)context.getProperties(), (String)"useFlowObjectives");
            newFlowObjectives = Strings.isNullOrEmpty((String)s) ? this.useFlowObjectives : Boolean.parseBoolean(s.trim());
        }
        catch (ClassCastException e) {
            newFlowObjectives = this.useFlowObjectives;
        }
        if (this.useFlowObjectives != newFlowObjectives) {
            this.useFlowObjectives = newFlowObjectives;
            this.changeCompilers();
            this.log.info("Settings: useFlowObjectives={}", (Object)this.useFlowObjectives);
        }
        try {
            String s = Tools.get((Dictionary)context.getProperties(), (String)"defaultFlowObjectiveCompiler");
            newDefaultFlowObjectiveCompiler = Strings.isNullOrEmpty((String)s) ? this.defaultFlowObjectiveCompiler : s.trim();
        }
        catch (ClassCastException e) {
            newDefaultFlowObjectiveCompiler = this.defaultFlowObjectiveCompiler;
        }
        if (!this.defaultFlowObjectiveCompiler.equals(newDefaultFlowObjectiveCompiler)) {
            this.defaultFlowObjectiveCompiler = newDefaultFlowObjectiveCompiler;
            this.changeCompilers();
            this.log.info("Settings: defaultFlowObjectiveCompiler={}", (Object)this.defaultFlowObjectiveCompiler);
        }
        try {
            String s = Tools.get((Dictionary)context.getProperties(), (String)"labelSelection");
            newLabelSelection = Strings.isNullOrEmpty((String)s) ? this.labelSelection : s.trim();
        }
        catch (ClassCastException e) {
            newLabelSelection = this.labelSelection;
        }
        if (!this.labelSelection.equals(newLabelSelection) && LabelAllocator.isInSelEnum(newLabelSelection)) {
            this.labelSelection = newLabelSelection;
            this.changeLabelSelections();
            this.log.info("Settings: labelSelection={}", (Object)this.labelSelection);
        }
        try {
            String optLabelSelected = Tools.get((Dictionary)context.getProperties(), (String)"optLabelSelection");
            newOptLabelSelection = Strings.isNullOrEmpty((String)optLabelSelected) ? this.optLabelSelection : optLabelSelected.trim();
        }
        catch (ClassCastException e) {
            newOptLabelSelection = this.optLabelSelection;
        }
        if (!this.optLabelSelection.equals(newOptLabelSelection) && LabelAllocator.isInOptEnum(newOptLabelSelection)) {
            this.optLabelSelection = newOptLabelSelection;
            this.changeOptLabelSelections();
            this.log.info("Settings: optLabelSelection={}", (Object)this.optLabelSelection);
        }
        try {
            String s = Tools.get((Dictionary)context.getProperties(), (String)"useFlowOptimization");
            newFlowOptimization = Strings.isNullOrEmpty((String)s) ? this.optimizeInstructions : Boolean.parseBoolean(s.trim());
        }
        catch (ClassCastException e) {
            newFlowOptimization = this.optimizeInstructions;
        }
        if (this.optimizeInstructions != newFlowOptimization) {
            this.optimizeInstructions = newFlowOptimization;
            this.changeFlowOptimization();
            this.log.info("Settings: useFlowOptimization={}", (Object)this.optimizeInstructions);
        }
        try {
            String s = Tools.get((Dictionary)context.getProperties(), (String)"useCopyTtl");
            newCopyTtl = Strings.isNullOrEmpty((String)s) ? this.useCopyTtl : Boolean.parseBoolean(s.trim());
        }
        catch (ClassCastException e) {
            newCopyTtl = this.useCopyTtl;
        }
        if (this.useCopyTtl != newCopyTtl) {
            this.useCopyTtl = newCopyTtl;
            this.changeCopyTtl();
            this.log.info("Settings: useCopyTtl={}", (Object)this.useCopyTtl);
        }
    }

    <T extends Intent> void registerCompiler(Class<T> cls, IntentCompiler<T> compiler, boolean flowBased) {
        if (flowBased) {
            this.flowObjectiveBased.compute(cls, (clz, compilers) -> {
                if (compilers == null) {
                    compilers = Sets.newHashSet();
                }
                compilers.add(compiler);
                return compilers;
            });
        } else {
            this.flowRuleBased.put(cls, compiler);
        }
        if (flowBased == this.useFlowObjectives) {
            this.extensionService.registerCompiler(cls, compiler);
        }
    }

    <T extends Intent> void unregisterCompiler(Class<T> cls, boolean flowBased) {
        if (flowBased) {
            this.flowObjectiveBased.remove(cls);
        } else {
            this.flowRuleBased.remove(cls);
        }
        if (flowBased == this.useFlowObjectives) {
            this.extensionService.unregisterCompiler(cls);
        }
    }

    private void changeCompilers() {
        if (this.useFlowObjectives) {
            this.flowRuleBased.forEach((cls, compiler) -> this.extensionService.unregisterCompiler(cls));
            this.flowObjectiveBased.forEach((cls, compilers) -> compilers.forEach(compiler -> {
                if (compiler.getClass().getName().equals(this.defaultFlowObjectiveCompiler)) {
                    this.extensionService.registerCompiler(cls, compiler);
                }
            }));
        } else {
            this.flowObjectiveBased.forEach((cls, compiler) -> this.extensionService.unregisterCompiler(cls));
            this.flowRuleBased.forEach((cls, compiler) -> this.extensionService.registerCompiler(cls, compiler));
        }
    }

    private void changeLabelSelections() {
        LinkCollectionCompiler.labelAllocator.setLabelSelection(this.labelSelection);
    }

    private void changeOptLabelSelections() {
        LinkCollectionCompiler.labelAllocator.setOptLabelSelection(this.optLabelSelection);
    }

    private void changeFlowOptimization() {
        LinkCollectionCompiler.optimizeInstructions = this.optimizeInstructions;
    }

    private void changeCopyTtl() {
        LinkCollectionCompiler.copyTtl = this.useCopyTtl;
    }

    protected void bindExtensionService(IntentExtensionService intentExtensionService) {
        this.extensionService = intentExtensionService;
    }

    protected void unbindExtensionService(IntentExtensionService intentExtensionService) {
        if (this.extensionService == intentExtensionService) {
            this.extensionService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }
}

