/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompilationException;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.constraint.AsymmetricPathConstraint;
import org.onosproject.net.intent.impl.compiler.ConnectivityIntentCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class HostToHostIntentCompiler
extends ConnectivityIntentCompiler<HostToHostIntent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEVICE_ID_NOT_FOUND = "Didn't find device id in the link";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;

    @Activate
    public void activate() {
        this.intentManager.registerCompiler(HostToHostIntent.class, (IntentCompiler)this);
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(HostToHostIntent.class);
    }

    public List<Intent> compile(HostToHostIntent intent, List<Intent> installable) {
        if (Objects.equals(intent.one(), intent.two())) {
            return ImmutableList.of();
        }
        boolean isAsymmetric = intent.constraints().contains(new AsymmetricPathConstraint());
        Path pathOne = this.getPathOrException((ConnectivityIntent)intent, (ElementId)intent.one(), (ElementId)intent.two());
        Path pathTwo = isAsymmetric ? this.getPathOrException((ConnectivityIntent)intent, (ElementId)intent.two(), (ElementId)intent.one()) : this.invertPath(pathOne);
        Host one = this.hostService.getHost(intent.one());
        Host two = this.hostService.getHost(intent.two());
        return Arrays.asList(this.createLinkCollectionIntent(pathOne, one, two, intent), this.createLinkCollectionIntent(pathTwo, two, one, intent));
    }

    private Path invertPath(Path path) {
        ArrayList<Link> reverseLinks = new ArrayList<Link>(path.links().size());
        for (Link link : path.links()) {
            reverseLinks.add(0, this.reverseLink(link));
        }
        return new DefaultPath(path.providerId(), reverseLinks, path.cost(), new Annotations[0]);
    }

    private Link reverseLink(Link link) {
        return DefaultLink.builder().providerId(link.providerId()).src(link.dst()).dst(link.src()).type(link.type()).state(link.state()).isExpected(link.isExpected()).build();
    }

    private FilteredConnectPoint getFilteredPointFromLink(Link link) {
        FilteredConnectPoint filteredConnectPoint;
        if (link.src().elementId() instanceof DeviceId) {
            filteredConnectPoint = new FilteredConnectPoint(link.src());
        } else if (link.dst().elementId() instanceof DeviceId) {
            filteredConnectPoint = new FilteredConnectPoint(link.dst());
        } else {
            throw new IntentCompilationException(DEVICE_ID_NOT_FOUND);
        }
        return filteredConnectPoint;
    }

    private Intent createLinkCollectionIntent(Path path, Host src, Host dst, HostToHostIntent intent) {
        List<ConnectPoint> pathCPs = path.links().stream().flatMap(l -> Stream.of(l.src(), l.dst())).collect(Collectors.toList());
        this.allocateBandwidth((ConnectivityIntent)intent, pathCPs);
        Link ingressLink = (Link)path.links().get(0);
        Link egressLink = (Link)path.links().get(path.links().size() - 1);
        FilteredConnectPoint ingressPoint = this.getFilteredPointFromLink(ingressLink);
        FilteredConnectPoint egressPoint = this.getFilteredPointFromLink(egressLink);
        TrafficSelector selector = DefaultTrafficSelector.builder((TrafficSelector)intent.selector()).matchEthSrc(src.mac()).matchEthDst(dst.mac()).build();
        Set coreLinks = path.links().stream().filter(link -> !link.type().equals((Object)Link.Type.EDGE)).collect(Collectors.toSet());
        return LinkCollectionIntent.builder().key(intent.key()).appId(intent.appId()).selector(selector).treatment(intent.treatment()).links(coreLinks).filteredIngressPoints((Set)ImmutableSet.of((Object)ingressPoint)).filteredEgressPoints((Set)ImmutableSet.of((Object)egressPoint)).applyTreatmentOnEgress(true).constraints(intent.constraints()).priority(intent.priority()).resourceGroup(intent.resourceGroup()).build();
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }
}

