/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl.compiler;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.graph.DefaultEdgeWeigher;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.Weight;
import org.onlab.util.Bandwidth;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.ElementId;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.intent.constraint.HashedPathSelectionConstraint;
import org.onosproject.net.intent.constraint.MarkerConstraint;
import org.onosproject.net.intent.constraint.PathViabilityConstraint;
import org.onosproject.net.intent.impl.PathNotFoundException;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public abstract class ConnectivityIntentCompiler<T extends ConnectivityIntent>
implements IntentCompiler<T> {
    private static final ProviderId PID = new ProviderId("core", "org.onosproject.core", true);
    private static final Logger log = LoggerFactory.getLogger(ConnectivityIntentCompiler.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PathService pathService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;

    protected LinkWeigher weigher(List<Constraint> constraints) {
        return new ConstraintBasedLinkWeigher(constraints);
    }

    protected boolean checkPath(Path path, List<Constraint> constraints) {
        if (path == null) {
            return false;
        }
        for (Constraint constraint : constraints) {
            if (constraint.validate(path, arg_0 -> ((ResourceService)this.resourceService).isAvailable(arg_0))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    protected Path getPathOrException(ConnectivityIntent intent, ElementId one, ElementId two) {
        Path path = this.getPath(intent, one, two);
        if (path == null) {
            throw new PathNotFoundException(one, two);
        }
        return path;
    }

    protected Path getPath(ConnectivityIntent intent, ElementId one, ElementId two) {
        Set paths = this.pathService.getPaths(one, two, this.weigher(intent.constraints()));
        List constraints = intent.constraints();
        ImmutableList filtered = FluentIterable.from((Iterable)paths).filter(path -> this.checkPath((Path)path, constraints)).toList();
        if (filtered.isEmpty()) {
            return null;
        }
        if (constraints.stream().anyMatch(c -> c instanceof HashedPathSelectionConstraint)) {
            return (Path)filtered.get(intent.hashCode() % filtered.size());
        }
        return (Path)filtered.iterator().next();
    }

    protected DisjointPath getDisjointPath(ConnectivityIntent intent, ElementId one, ElementId two) {
        Set paths = this.pathService.getDisjointPaths(one, two, this.weigher(intent.constraints()));
        List constraints = intent.constraints();
        ImmutableList filtered = FluentIterable.from((Iterable)paths).filter(path -> this.checkPath((Path)path, constraints)).filter(path -> this.checkPath(path.backup(), constraints)).toList();
        if (filtered.isEmpty()) {
            throw new PathNotFoundException(one, two);
        }
        if (constraints.stream().anyMatch(c -> c instanceof HashedPathSelectionConstraint)) {
            return (DisjointPath)filtered.get(intent.hashCode() % filtered.size());
        }
        return (DisjointPath)filtered.iterator().next();
    }

    protected void allocateBandwidth(ConnectivityIntent intent, List<ConnectPoint> connectPoints) {
        List constraints = intent.constraints();
        if (constraints == null) {
            return;
        }
        Optional<Constraint> constraint = constraints.stream().filter(c -> c instanceof BandwidthConstraint).findAny();
        if (!constraint.isPresent()) {
            return;
        }
        BandwidthConstraint bwConstraint = (BandwidthConstraint)constraint.get();
        double bw = bwConstraint.bandwidth().bps();
        ResourceGroup newResourceConsumer = intent.resourceGroup() != null ? intent.resourceGroup() : intent.key();
        Collection resourceAllocations = this.resourceService.getResourceAllocations((ResourceConsumer)newResourceConsumer);
        List<Resource> resourcesAllocated = ConnectivityIntentCompiler.resourcesFromAllocations(resourceAllocations);
        List<ResourceId> idsResourcesAllocated = ConnectivityIntentCompiler.resourceIds(resourcesAllocated);
        List incomingResources = ConnectivityIntentCompiler.resources(connectPoints, bw).stream().filter(r -> !resourcesAllocated.contains(r)).collect(Collectors.toList());
        if (incomingResources.isEmpty()) {
            return;
        }
        List resourcesToAdd = incomingResources.stream().filter(r -> !idsResourcesAllocated.contains(r.id())).collect(Collectors.toList());
        ArrayList resourcesToUpdate = Lists.newArrayList(incomingResources);
        resourcesToUpdate.removeAll(resourcesToAdd);
        if (!resourcesToUpdate.isEmpty()) {
            List resourceAllocationsToUpdate = resourceAllocations.stream().filter(rA -> ConnectivityIntentCompiler.resourceIds(resourcesToUpdate).contains(rA.resource().id())).collect(Collectors.toList());
            log.debug("Releasing bandwidth for intent {}: {} bps", (Object)newResourceConsumer, (Object)resourcesToUpdate);
            this.resourceService.release(resourceAllocationsToUpdate);
            resourcesToAdd.addAll(resourcesToUpdate);
        }
        if (intent.resourceGroup() != null) {
            Collection resourceAllocationsByKey = this.resourceService.getResourceAllocations((ResourceConsumer)intent.key());
            this.resourceService.release((List)Lists.newArrayList((Iterable)resourceAllocationsByKey));
        }
        log.debug("Allocating bandwidth for intent {}: {} bps", (Object)newResourceConsumer, resourcesToAdd);
        List allocations = this.resourceService.allocate((ResourceConsumer)newResourceConsumer, resourcesToAdd);
        if (allocations.isEmpty()) {
            log.debug("No resources allocated for intent {}", (Object)newResourceConsumer);
        }
        log.debug("Done allocating bandwidth for intent {}", (Object)newResourceConsumer);
    }

    private static List<Resource> resourcesFromAllocations(Collection<ResourceAllocation> rAs) {
        return rAs.stream().map(ResourceAllocation::resource).collect(Collectors.toList());
    }

    private static List<Resource> resources(List<ConnectPoint> cps, double bw) {
        return cps.stream().filter(cp -> cp.elementId() instanceof DeviceId).map(cp -> Resources.continuous((DeviceId)cp.deviceId(), (PortNumber)cp.port(), Bandwidth.class).resource(bw)).collect(Collectors.toList());
    }

    private static List<ResourceId> resourceIds(List<Resource> resources) {
        return resources.stream().map(Resource::id).collect(Collectors.toList());
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindIntentManager(IntentExtensionService intentExtensionService) {
        this.intentManager = intentExtensionService;
    }

    protected void unbindIntentManager(IntentExtensionService intentExtensionService) {
        if (this.intentManager == intentExtensionService) {
            this.intentManager = null;
        }
    }

    protected void bindPathService(PathService pathService) {
        this.pathService = pathService;
    }

    protected void unbindPathService(PathService pathService) {
        if (this.pathService == pathService) {
            this.pathService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }

    protected class ConstraintBasedLinkWeigher
    extends DefaultEdgeWeigher<TopologyVertex, TopologyEdge>
    implements LinkWeigher {
        private final List<Constraint> constraints;

        ConstraintBasedLinkWeigher(List<Constraint> constraints) {
            this.constraints = constraints == null ? Collections.emptyList() : ImmutableList.copyOf(constraints);
        }

        public Weight weight(TopologyEdge edge) {
            Iterator it = this.constraints.stream().filter(c -> !(c instanceof MarkerConstraint)).filter(c -> !(c instanceof PathViabilityConstraint)).iterator();
            if (!it.hasNext()) {
                return DEFAULT_HOP_WEIGHT;
            }
            double cost = ((Constraint)it.next()).cost(edge.link(), arg_0 -> ((ResourceService)ConnectivityIntentCompiler.this.resourceService).isAvailable(arg_0));
            while (it.hasNext() && cost > 0.0) {
                if (!(((Constraint)it.next()).cost(edge.link(), arg_0 -> ((ResourceService)ConnectivityIntentCompiler.this.resourceService).isAvailable(arg_0)) < 0.0)) continue;
                cost = -1.0;
            }
            return ScalarWeight.toWeight((double)cost);
        }
    }
}

