/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointDescription;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointState;
import org.onosproject.net.behaviour.protection.ProtectionConfig;
import org.onosproject.net.behaviour.protection.ProtectionConfigBehaviour;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={ProtectionConfigMonitor.class})
@Component(immediate=true)
public class ProtectionConfigMonitor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgRegistry;
    private final List<ConfigFactory<?, ?>> factories = ImmutableList.of((Object)new ConfigFactory<DeviceId, ProtectionConfig>(SubjectFactories.DEVICE_SUBJECT_FACTORY, ProtectionConfig.class, "protection"){

        public ProtectionConfig createConfig() {
            return new ProtectionConfig();
        }
    });
    private final ProtectionConfigListener listener = new ProtectionConfigListener();
    private ExecutorService worker;

    @Activate
    public void activate() {
        this.worker = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/protection", (String)"installer", (Logger)this.log));
        this.networkConfigService.addListener((EventListener)this.listener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgRegistry).registerConfigFactory(arg_0));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.networkConfigService.removeListener((EventListener)this.listener);
        this.worker.shutdown();
        try {
            this.worker.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgRegistry).unregisterConfigFactory(arg_0));
        this.log.info("Stopped");
    }

    private ProtectionConfigBehaviour getBehaviour(DeviceId did) {
        DriverHandler handler = this.driverService.createHandler(did, new String[0]);
        if (!handler.hasBehaviour(ProtectionConfigBehaviour.class)) {
            this.log.error("{} does not support protection", (Object)did);
            throw new UnsupportedOperationException(did + " does not support protection");
        }
        return (ProtectionConfigBehaviour)handler.behaviour(ProtectionConfigBehaviour.class);
    }

    private Optional<ConnectPoint> findFirstVirtualPort(ProtectionConfigBehaviour behaviour, String fingerprint) {
        Map map;
        CompletableFuture states = behaviour.getProtectionEndpointStates();
        try {
            map = (Map)states.get();
        }
        catch (InterruptedException e1) {
            this.log.error("Interrupted.", (Throwable)e1);
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
        catch (ExecutionException e1) {
            this.log.error("Exception caught.", (Throwable)e1);
            return Optional.empty();
        }
        return map.entrySet().stream().filter(e -> fingerprint.equals(((ProtectedTransportEndpointState)e.getValue()).description().fingerprint())).map(Map.Entry::getKey).findFirst();
    }

    private void addProtection(DeviceId did, ProtectionConfig added) {
        ProtectedTransportEndpointDescription description = added.asDescription();
        this.log.info("adding protection {}-{}", (Object)did, (Object)description);
        ProtectionConfigBehaviour behaviour = this.getBehaviour(did);
        CompletableFuture result = behaviour.createProtectionEndpoint(description);
        result.handle((vPort, e) -> {
            if (vPort != null) {
                this.log.info("Virtual Port {} created for {}", vPort, (Object)description);
                this.log.debug("{}", (Object)this.deviceService.getPort(vPort));
            } else {
                this.log.error("Protection {} exceptionally failed.", (Object)added, e);
            }
            return vPort;
        });
    }

    private void updateProtection(DeviceId did, ProtectionConfig before, ProtectionConfig after) {
        ProtectedTransportEndpointDescription description = after.asDescription();
        this.log.info("updating protection {}-{}", (Object)did, (Object)description);
        ProtectionConfigBehaviour behaviour = this.getBehaviour(did);
        Optional<ConnectPoint> existing = this.findFirstVirtualPort(behaviour, after.fingerprint());
        if (!existing.isPresent()) {
            this.log.warn("Update requested, but not found, falling back as add");
            this.addProtection(did, after);
            return;
        }
        ConnectPoint vPort = existing.get();
        this.log.info("updating protection virtual Port {} : {}", (Object)vPort, (Object)description);
        behaviour.updateProtectionEndpoint(vPort, description).handle((vPortNew, e) -> {
            if (vPort != null) {
                this.log.info("Virtual Port {} updated for {}", (Object)vPort, (Object)description);
                this.log.debug("{}", (Object)this.deviceService.getPort(vPort));
            } else {
                this.log.error("Protection {} -> {} exceptionally failed.", new Object[]{before, after, e});
            }
            return vPort;
        });
    }

    private void removeProtection(DeviceId did, ProtectionConfig removed) {
        ProtectedTransportEndpointDescription description = removed.asDescription();
        this.log.info("removing protection {}-{}", (Object)did, (Object)description);
        ProtectionConfigBehaviour behaviour = this.getBehaviour(did);
        Optional<ConnectPoint> existing = this.findFirstVirtualPort(behaviour, removed.fingerprint());
        if (!existing.isPresent()) {
            this.log.warn("Remove requested, but not found, ignoring");
            return;
        }
        ConnectPoint vPort = existing.get();
        this.log.info("removing protection virtual port {} : {}", (Object)vPort, (Object)description);
        behaviour.deleteProtectionEndpoint(vPort).handle((result, ex) -> {
            if (ex != null) {
                this.log.info("removed protection {} : {}", (Object)vPort, result);
            } else {
                this.log.warn("removed protection {} failed.", (Object)vPort, ex);
            }
            return result;
        });
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected void bindCfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgRegistry = networkConfigRegistry;
    }

    protected void unbindCfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgRegistry == networkConfigRegistry) {
            this.cfgRegistry = null;
        }
    }

    public class ProtectionConfigListener
    implements NetworkConfigListener {
        private final Set<NetworkConfigEvent.Type> relevant = ImmutableSet.copyOf(EnumSet.of(NetworkConfigEvent.Type.CONFIG_ADDED, NetworkConfigEvent.Type.CONFIG_UPDATED, NetworkConfigEvent.Type.CONFIG_REMOVED));

        public boolean isRelevant(NetworkConfigEvent event) {
            return event.configClass() == ProtectionConfig.class && this.relevant.contains(event.type());
        }

        public void event(NetworkConfigEvent event) {
            ProtectionConfigMonitor.this.worker.execute(() -> this.processEvent(event));
        }

        protected void processEvent(NetworkConfigEvent event) {
            DeviceId did = (DeviceId)event.subject();
            ProtectionConfigMonitor.this.log.debug("{} to {}: {}", new Object[]{event.type(), did, event});
            if (ProtectionConfigMonitor.this.deviceService.getRole(did) != MastershipRole.MASTER) {
                ProtectionConfigMonitor.this.log.debug("Not the master, ignoring. {}", (Object)event);
                return;
            }
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_ADDED: {
                    ProtectionConfigMonitor.this.addProtection(did, (ProtectionConfig)event.config().get());
                    break;
                }
                case CONFIG_UPDATED: {
                    ProtectionConfigMonitor.this.updateProtection(did, (ProtectionConfig)event.prevConfig().get(), (ProtectionConfig)event.config().get());
                    break;
                }
                case CONFIG_REMOVED: {
                    ProtectionConfigMonitor.this.removeProtection(did, (ProtectionConfig)event.prevConfig().get());
                    break;
                }
                default: {
                    ProtectionConfigMonitor.this.log.warn("Ignoring unexpected event: {}", (Object)event);
                }
            }
        }
    }
}

