/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.ObjectiveTrackerService;
import org.onosproject.net.intent.TopologyChangeDelegate;
import org.onosproject.net.intent.WorkPartitionEvent;
import org.onosproject.net.intent.WorkPartitionEventListener;
import org.onosproject.net.intent.WorkPartitionService;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceEvent;
import org.onosproject.net.resource.ResourceListener;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyListener;
import org.onosproject.net.topology.TopologyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ObjectiveTracker
implements ObjectiveTrackerService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SetMultimap<LinkKey, Key> intentsByLink = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final SetMultimap<ElementId, Key> intentsByDevice = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected WorkPartitionService partitionService;
    private ExecutorService executorService = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/intent", (String)"objectivetracker", (Logger)this.log));
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, Tools.groupedThreads((String)"onos/intent", (String)"scheduledIntentUpdate", (Logger)this.log));
    private TopologyListener listener = new InternalTopologyListener();
    private ResourceListener resourceListener = new InternalResourceListener();
    private DeviceListener deviceListener = new InternalDeviceListener();
    private HostListener hostListener = new InternalHostListener();
    private WorkPartitionEventListener partitionListener = new InternalPartitionListener();
    private TopologyChangeDelegate delegate;
    protected final AtomicBoolean updateScheduled = new AtomicBoolean(false);

    @Activate
    public void activate() {
        this.topologyService.addListener((EventListener)this.listener);
        this.resourceService.addListener((EventListener)this.resourceListener);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.hostService.addListener((EventListener)this.hostListener);
        this.partitionService.addListener((EventListener)this.partitionListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.topologyService.removeListener((EventListener)this.listener);
        this.resourceService.removeListener((EventListener)this.resourceListener);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.hostService.removeListener((EventListener)this.hostListener);
        this.partitionService.removeListener((EventListener)this.partitionListener);
        this.log.info("Stopped");
    }

    protected void bindIntentService(IntentService service) {
        if (this.intentService == null) {
            this.intentService = service;
        }
    }

    protected void unbindIntentService(IntentService service) {
        if (this.intentService == service) {
            this.intentService = null;
        }
    }

    public void setDelegate(TopologyChangeDelegate delegate) {
        Preconditions.checkNotNull((Object)delegate, (Object)"Delegate cannot be null");
        Preconditions.checkArgument((this.delegate == null || this.delegate == delegate ? 1 : 0) != 0, (Object)"Another delegate already set");
        this.delegate = delegate;
    }

    public void unsetDelegate(TopologyChangeDelegate delegate) {
        Preconditions.checkArgument((this.delegate == delegate ? 1 : 0) != 0, (Object)"Not the current delegate");
        this.delegate = null;
    }

    public void addTrackedResources(Key intentKey, Collection<NetworkResource> resources) {
        for (NetworkResource resource : resources) {
            if (resource instanceof Link) {
                this.intentsByLink.put((Object)LinkKey.linkKey((Link)((Link)resource)), (Object)intentKey);
                continue;
            }
            if (!(resource instanceof ElementId)) continue;
            this.intentsByDevice.put((Object)((ElementId)resource), (Object)intentKey);
        }
    }

    public void removeTrackedResources(Key intentKey, Collection<NetworkResource> resources) {
        for (NetworkResource resource : resources) {
            if (resource instanceof Link) {
                this.intentsByLink.remove((Object)LinkKey.linkKey((Link)((Link)resource)), (Object)intentKey);
                continue;
            }
            if (!(resource instanceof ElementId)) continue;
            this.intentsByDevice.remove((Object)resource, (Object)intentKey);
        }
    }

    public void trackIntent(IntentData intentData) {
        Key key = intentData.key();
        Intent intent = intentData.intent();
        boolean isLocal = this.intentService.isLocal(key);
        boolean isInstalled = intentData.state() == IntentState.INSTALLING || intentData.state() == IntentState.INSTALLED;
        List installables = intentData.installables();
        if (this.log.isTraceEnabled()) {
            this.log.trace("intent {}, old: {}, new: {}, installableCount: {}, resourceCount: {}", new Object[]{key, this.intentsByDevice.values().contains(key), isLocal && isInstalled, installables.size(), (long)intent.resources().size() + installables.stream().mapToLong(i -> i.resources().size()).sum()});
        }
        if (Tools.isNullOrEmpty((Collection)installables) && intentData.state() == IntentState.INSTALLED) {
            this.log.warn("Intent {} is INSTALLED with no installables", (Object)key);
        }
        if (isLocal && isInstalled) {
            this.addTrackedResources(key, intent.resources());
            for (Intent installable : installables) {
                this.addTrackedResources(key, installable.resources());
            }
        } else {
            this.removeTrackedResources(key, intent.resources());
            for (Intent installable : installables) {
                this.removeTrackedResources(key, installable.resources());
            }
        }
    }

    private void doIntentUpdate() {
        this.updateScheduled.set(false);
        if (this.intentService == null) {
            this.log.warn("Intent service is not bound yet");
            return;
        }
        try {
            for (IntentData intentData : this.intentService.getIntentData()) {
                try {
                    this.trackIntent(intentData);
                }
                catch (NullPointerException npe) {
                    this.log.warn("intent error {}", (Object)intentData.key(), (Object)npe);
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Exception caught during update task", (Throwable)e);
        }
    }

    private void scheduleIntentUpdate(int afterDelaySec) {
        if (this.updateScheduled.compareAndSet(false, true)) {
            this.executor.schedule(this::doIntentUpdate, (long)afterDelaySec, TimeUnit.SECONDS);
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindPartitionService(WorkPartitionService workPartitionService) {
        this.partitionService = workPartitionService;
    }

    protected void unbindPartitionService(WorkPartitionService workPartitionService) {
        if (this.partitionService == workPartitionService) {
            this.partitionService = null;
        }
    }

    private final class InternalPartitionListener
    implements WorkPartitionEventListener {
        private InternalPartitionListener() {
        }

        public void event(WorkPartitionEvent event) {
            ObjectiveTracker.this.log.debug("got message {}", event.subject());
            ObjectiveTracker.this.scheduleIntentUpdate(1);
        }
    }

    private class InternalHostListener
    implements HostListener {
        private InternalHostListener() {
        }

        public void event(HostEvent event) {
            HostId id = ((Host)event.subject()).id();
            switch ((HostEvent.Type)event.type()) {
                case HOST_ADDED: 
                case HOST_MOVED: 
                case HOST_REMOVED: {
                    ObjectiveTracker.this.executorService.execute(new DeviceAvailabilityHandler((ElementId)id, false));
                    break;
                }
            }
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            DeviceEvent.Type type = (DeviceEvent.Type)event.type();
            switch (type) {
                case DEVICE_ADDED: 
                case DEVICE_AVAILABILITY_CHANGED: 
                case DEVICE_REMOVED: 
                case DEVICE_SUSPENDED: 
                case DEVICE_UPDATED: {
                    DeviceId id = ((Device)event.subject()).id();
                    boolean available = type == DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED || type == DeviceEvent.Type.DEVICE_ADDED || type == DeviceEvent.Type.DEVICE_UPDATED;
                    ObjectiveTracker.this.executorService.execute(new DeviceAvailabilityHandler((ElementId)id, available));
                    break;
                }
            }
        }
    }

    private class DeviceAvailabilityHandler
    implements Runnable {
        private final ElementId id;
        private final boolean available;

        DeviceAvailabilityHandler(ElementId id, boolean available) {
            this.id = (ElementId)Preconditions.checkNotNull((Object)id);
            this.available = available;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImmutableSet snapshot;
            if (ObjectiveTracker.this.delegate == null) {
                return;
            }
            SetMultimap setMultimap = ObjectiveTracker.this.intentsByDevice;
            synchronized (setMultimap) {
                snapshot = ImmutableSet.copyOf((Collection)ObjectiveTracker.this.intentsByDevice.get((Object)this.id));
            }
            ObjectiveTracker.this.delegate.triggerCompile((Iterable)snapshot, this.available);
        }
    }

    private class InternalResourceListener
    implements ResourceListener {
        private InternalResourceListener() {
        }

        public void event(ResourceEvent event) {
            if (((Resource)event.subject()).isSubTypeOf(PortNumber.class)) {
                ObjectiveTracker.this.executorService.execute(() -> {
                    if (ObjectiveTracker.this.delegate == null) {
                        return;
                    }
                    ObjectiveTracker.this.delegate.triggerCompile(Collections.emptySet(), true);
                });
            }
        }
    }

    private class TopologyChangeHandler
    implements Runnable {
        private final TopologyEvent event;

        TopologyChangeHandler(TopologyEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ObjectiveTracker.this.delegate == null) {
                return;
            }
            if (this.event.reasons() == null || this.event.reasons().isEmpty()) {
                ObjectiveTracker.this.delegate.triggerCompile(Collections.emptySet(), true);
            } else {
                HashSet intentsToRecompile = new HashSet();
                boolean dontRecompileAllFailedIntents = true;
                for (Event reason : this.event.reasons()) {
                    if (!(reason instanceof LinkEvent)) continue;
                    LinkEvent linkEvent = (LinkEvent)reason;
                    LinkKey linkKey = LinkKey.linkKey((Link)((Link)linkEvent.subject()));
                    SetMultimap setMultimap = ObjectiveTracker.this.intentsByLink;
                    synchronized (setMultimap) {
                        Set intentKeys = ObjectiveTracker.this.intentsByLink.get((Object)linkKey);
                        ObjectiveTracker.this.log.debug("recompile triggered by LinkEvent {} ({}) for {}", new Object[]{linkKey, linkEvent.type(), intentKeys});
                        intentsToRecompile.addAll(intentKeys);
                    }
                    dontRecompileAllFailedIntents = dontRecompileAllFailedIntents && (linkEvent.type() == LinkEvent.Type.LINK_REMOVED || linkEvent.type() == LinkEvent.Type.LINK_UPDATED && ((Link)linkEvent.subject()).isDurable());
                }
                ObjectiveTracker.this.delegate.triggerCompile(intentsToRecompile, !dontRecompileAllFailedIntents);
            }
        }
    }

    private class InternalTopologyListener
    implements TopologyListener {
        private InternalTopologyListener() {
        }

        public void event(TopologyEvent event) {
            ObjectiveTracker.this.executorService.execute(new TopologyChangeHandler(event));
        }
    }
}

