/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.domain.DomainIntentService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentBatchDelegate;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.IntentInstallCoordinator;
import org.onosproject.net.intent.IntentInstaller;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentOperationContext;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentStore;
import org.onosproject.net.intent.IntentStoreDelegate;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.ObjectiveTrackerService;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.TopologyChangeDelegate;
import org.onosproject.net.intent.constraint.PartialFailureConstraint;
import org.onosproject.net.intent.impl.CompilerRegistry;
import org.onosproject.net.intent.impl.InstallCoordinator;
import org.onosproject.net.intent.impl.InstallerRegistry;
import org.onosproject.net.intent.impl.IntentAccumulator;
import org.onosproject.net.intent.impl.IntentProcessor;
import org.onosproject.net.intent.impl.compiler.PointToPointIntentCompiler;
import org.onosproject.net.intent.impl.phase.FinalIntentProcessPhase;
import org.onosproject.net.intent.impl.phase.IntentProcessPhase;
import org.onosproject.net.intent.impl.phase.Skipped;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class IntentManager
extends AbstractListenerManager<IntentEvent, IntentListener>
implements IntentService,
IntentExtensionService,
IntentInstallCoordinator {
    private static final Logger log = LoggerFactory.getLogger(IntentManager.class);
    private static final String INTENT_NULL = "Intent cannot be null";
    private static final String INTENT_ID_NULL = "Intent key cannot be null";
    private static final EnumSet<IntentState> RECOMPILE = EnumSet.of(IntentState.INSTALL_REQ, IntentState.FAILED, IntentState.WITHDRAW_REQ);
    private static final EnumSet<IntentState> WITHDRAW = EnumSet.of(IntentState.WITHDRAW_REQ, IntentState.WITHDRAWING, IntentState.WITHDRAWN);
    private static final boolean DEFAULT_SKIP_RELEASE_RESOURCES_ON_WITHDRAWAL = false;
    @Property(name="skipReleaseResourcesOnWithdrawal", boolValue={false}, label="Indicates whether skipping resource releases on withdrawal is enabled or not")
    private boolean skipReleaseResourcesOnWithdrawal = false;
    private static final int DEFAULT_NUM_THREADS = 12;
    @Property(name="numThreads", intValue={12}, label="Number of worker threads")
    private int numThreads = 12;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ObjectiveTrackerService trackerService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DomainIntentService domainIntentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected GroupService groupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private NetworkConfigService networkConfigService;
    private ExecutorService batchExecutor;
    private ExecutorService workerExecutor;
    private final CompilerRegistry compilerRegistry = new CompilerRegistry();
    private final InstallerRegistry installerRegistry = new InstallerRegistry();
    private final InternalIntentProcessor processor = new InternalIntentProcessor();
    private final IntentStoreDelegate delegate = new InternalStoreDelegate();
    private final IntentStoreDelegate testOnlyDelegate = new TestOnlyIntentStoreDelegate();
    private final TopologyChangeDelegate topoDelegate = new InternalTopoChangeDelegate();
    private final IntentBatchDelegate batchDelegate = new InternalBatchDelegate();
    private InstallCoordinator installCoordinator;
    private IdGenerator idGenerator;
    private final IntentAccumulator accumulator = new IntentAccumulator(this.batchDelegate);

    @Activate
    public void activate() {
        this.configService.registerProperties(((Object)((Object)this)).getClass());
        if (this.skipReleaseResourcesOnWithdrawal) {
            this.store.setDelegate((StoreDelegate)this.testOnlyDelegate);
        } else {
            this.store.setDelegate((StoreDelegate)this.delegate);
        }
        this.trackerService.setDelegate(this.topoDelegate);
        this.eventDispatcher.addSink(IntentEvent.class, (EventSink)this.listenerRegistry);
        this.batchExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/intent", (String)"batch", (Logger)log));
        this.workerExecutor = Executors.newFixedThreadPool(this.numThreads, Tools.groupedThreads((String)"onos/intent", (String)"worker-%d", (Logger)log));
        this.idGenerator = this.coreService.getIdGenerator("intent-ids");
        Intent.unbindIdGenerator((IdGenerator)this.idGenerator);
        Intent.bindIdGenerator((IdGenerator)this.idGenerator);
        this.installCoordinator = new InstallCoordinator(this.installerRegistry, this.store);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        if (this.skipReleaseResourcesOnWithdrawal) {
            this.store.unsetDelegate((StoreDelegate)this.testOnlyDelegate);
        } else {
            this.store.unsetDelegate((StoreDelegate)this.delegate);
        }
        this.configService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.trackerService.unsetDelegate(this.topoDelegate);
        this.eventDispatcher.removeSink(IntentEvent.class);
        this.batchExecutor.shutdown();
        this.workerExecutor.shutdown();
        Intent.unbindIdGenerator((IdGenerator)this.idGenerator);
        log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        int newNumThreads;
        boolean newTestEnabled;
        if (context == null) {
            this.skipReleaseResourcesOnWithdrawal = false;
            this.logConfig("Default config");
            return;
        }
        String s = Tools.get((Dictionary)context.getProperties(), (String)"skipReleaseResourcesOnWithdrawal");
        boolean bl = newTestEnabled = Strings.isNullOrEmpty((String)s) ? this.skipReleaseResourcesOnWithdrawal : Boolean.parseBoolean(s.trim());
        if (this.skipReleaseResourcesOnWithdrawal && !newTestEnabled) {
            this.store.unsetDelegate((StoreDelegate)this.testOnlyDelegate);
            this.store.setDelegate((StoreDelegate)this.delegate);
            this.skipReleaseResourcesOnWithdrawal = false;
            this.logConfig("Reconfigured skip release resources on withdrawal");
        } else if (!this.skipReleaseResourcesOnWithdrawal && newTestEnabled) {
            this.store.unsetDelegate((StoreDelegate)this.delegate);
            this.store.setDelegate((StoreDelegate)this.testOnlyDelegate);
            this.skipReleaseResourcesOnWithdrawal = true;
            this.logConfig("Reconfigured skip release resources on withdrawal");
        }
        s = Tools.get((Dictionary)context.getProperties(), (String)"numThreads");
        int n = newNumThreads = Strings.isNullOrEmpty((String)s) ? this.numThreads : Integer.parseInt(s);
        if (newNumThreads != this.numThreads) {
            this.numThreads = newNumThreads;
            ExecutorService oldWorkerExecutor = this.workerExecutor;
            this.workerExecutor = Executors.newFixedThreadPool(this.numThreads, Tools.groupedThreads((String)"onos/intent", (String)"worker-%d", (Logger)log));
            if (oldWorkerExecutor != null) {
                oldWorkerExecutor.shutdown();
            }
            this.logConfig("Reconfigured number of worker threads");
        }
    }

    private void logConfig(String prefix) {
        log.info("{} with skipReleaseResourcesOnWithdrawal = {}", (Object)prefix, (Object)this.skipReleaseResourcesOnWithdrawal);
    }

    public void submit(Intent intent) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_WRITE);
        Preconditions.checkNotNull((Object)intent, (Object)INTENT_NULL);
        IntentData data = IntentData.submit((Intent)intent);
        this.store.addPending(data);
    }

    public void withdraw(Intent intent) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_WRITE);
        Preconditions.checkNotNull((Object)intent, (Object)INTENT_NULL);
        IntentData data = IntentData.withdraw((Intent)intent);
        this.store.addPending(data);
    }

    public void purge(Intent intent) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_WRITE);
        Preconditions.checkNotNull((Object)intent, (Object)INTENT_NULL);
        IntentData data = IntentData.purge((Intent)intent);
        this.store.addPending(data);
        if (intent instanceof PointToPointIntent) {
            PointToPointIntent pointIntent = (PointToPointIntent)intent;
            DeviceId deviceId = pointIntent.ingressPoint().deviceId();
            GroupKey groupKey = PointToPointIntentCompiler.makeGroupKey(intent.id());
            this.groupService.removeGroup(deviceId, groupKey, intent.appId());
        }
    }

    public Intent getIntent(Key key) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_READ);
        return this.store.getIntent(key);
    }

    public Iterable<Intent> getIntents() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_READ);
        return this.store.getIntents();
    }

    public void addPending(IntentData intentData) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_WRITE);
        Preconditions.checkNotNull((Object)intentData, (Object)INTENT_NULL);
        this.store.addPending(intentData);
    }

    public Iterable<IntentData> getIntentData() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_READ);
        return this.store.getIntentData(false, 0L);
    }

    public long getIntentCount() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_READ);
        return this.store.getIntentCount();
    }

    public IntentState getIntentState(Key intentKey) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_READ);
        Preconditions.checkNotNull((Object)intentKey, (Object)INTENT_ID_NULL);
        return this.store.getIntentState(intentKey);
    }

    public List<Intent> getInstallableIntents(Key intentKey) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_READ);
        Preconditions.checkNotNull((Object)intentKey, (Object)INTENT_ID_NULL);
        return this.store.getInstallableIntents(intentKey);
    }

    public boolean isLocal(Key intentKey) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_READ);
        return this.store.isMaster(intentKey);
    }

    public <T extends Intent> void registerCompiler(Class<T> cls, IntentCompiler<T> compiler) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_WRITE);
        this.compilerRegistry.registerCompiler(cls, compiler);
    }

    public <T extends Intent> void unregisterCompiler(Class<T> cls) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_WRITE);
        this.compilerRegistry.unregisterCompiler(cls);
    }

    public Map<Class<? extends Intent>, IntentCompiler<? extends Intent>> getCompilers() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_READ);
        return this.compilerRegistry.getCompilers();
    }

    public <T extends Intent> void registerInstaller(Class<T> cls, IntentInstaller<T> installer) {
        this.installerRegistry.registerInstaller(cls, installer);
    }

    public <T extends Intent> void unregisterInstaller(Class<T> cls) {
        this.installerRegistry.unregisterInstaller(cls);
    }

    public Map<Class<? extends Intent>, IntentInstaller<? extends Intent>> getInstallers() {
        return this.installerRegistry.getInstallers();
    }

    public <T extends Intent> IntentInstaller<T> getInstaller(Class<T> cls) {
        return this.installerRegistry.getInstallers().get(cls);
    }

    public Iterable<Intent> getPending() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.INTENT_READ);
        return this.store.getPending();
    }

    public void intentInstallSuccess(IntentOperationContext context) {
        this.installCoordinator.success(context);
    }

    public void intentInstallFailed(IntentOperationContext context) {
        this.installCoordinator.failed(context);
    }

    private void buildAndSubmitBatches(Iterable<Key> intentKeys, boolean compileAllFailed) {
        for (Key key : intentKeys) {
            Intent intent;
            if (!this.store.isMaster(key) || (intent = this.store.getIntent(key)) == null) continue;
            this.submit(intent);
        }
        if (compileAllFailed) {
            for (Intent intent : this.getIntents()) {
                IntentState state;
                if (!this.store.isMaster(intent.key()) || !RECOMPILE.contains(state = this.getIntentState(intent.key())) && !PartialFailureConstraint.intentAllowsPartialFailure((Intent)intent)) continue;
                if (WITHDRAW.contains(state)) {
                    this.withdraw(intent);
                    continue;
                }
                this.submit(intent);
            }
        }
    }

    private IntentProcessPhase createInitialPhase(IntentData data) {
        IntentData pending = this.store.getPendingData(data.key());
        if (pending == null || pending.version().isNewerThan(data.version())) {
            return Skipped.getPhase();
        }
        IntentData current = this.store.getIntentData(data.key());
        return IntentProcessPhase.newInitialPhase(this.processor, data, current);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindStore(IntentStore intentStore) {
        this.store = intentStore;
    }

    protected void unbindStore(IntentStore intentStore) {
        if (this.store == intentStore) {
            this.store = null;
        }
    }

    protected void bindTrackerService(ObjectiveTrackerService objectiveTrackerService) {
        this.trackerService = objectiveTrackerService;
    }

    protected void unbindTrackerService(ObjectiveTrackerService objectiveTrackerService) {
        if (this.trackerService == objectiveTrackerService) {
            this.trackerService = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindDomainIntentService(DomainIntentService domainIntentService) {
        this.domainIntentService = domainIntentService;
    }

    protected void unbindDomainIntentService(DomainIntentService domainIntentService) {
        if (this.domainIntentService == domainIntentService) {
            this.domainIntentService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }

    protected void bindGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    protected void unbindGroupService(GroupService groupService) {
        if (this.groupService == groupService) {
            this.groupService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    private class InternalIntentProcessor
    implements IntentProcessor {
        private InternalIntentProcessor() {
        }

        @Override
        public List<Intent> compile(Intent intent, List<Intent> previousInstallables) {
            return IntentManager.this.compilerRegistry.compile(intent, previousInstallables);
        }

        @Override
        public void apply(Optional<IntentData> toUninstall, Optional<IntentData> toInstall) {
            IntentManager.this.installCoordinator.installIntents(toUninstall, toInstall);
        }
    }

    private class InternalBatchDelegate
    implements IntentBatchDelegate {
        private InternalBatchDelegate() {
        }

        public void execute(Collection<IntentData> operations) {
            log.debug("Execute {} operation(s).", (Object)operations.size());
            log.trace("Execute operations: {}", operations);
            ((CompletableFuture)CompletableFuture.runAsync(() -> {
                List futures = operations.stream().map(data -> {
                    log.debug("Start processing of {} {}@{}", new Object[]{data.request(), data.key(), data.version()});
                    return data;
                }).map(x -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(x).thenApply(x$0 -> IntentManager.this.createInitialPhase(x$0))).thenApplyAsync(IntentProcessPhase::process, (Executor)IntentManager.this.workerExecutor)).thenApply(FinalIntentProcessPhase::data)).exceptionally(e -> {
                    log.warn("Future failed", e);
                    log.warn("Intent {} - state {} - request {}", new Object[]{x.key(), x.state(), x.request()});
                    switch (x.state()) {
                        case INSTALL_REQ: 
                        case INSTALLING: 
                        case WITHDRAW_REQ: 
                        case WITHDRAWING: {
                            IntentData current = IntentManager.this.store.getIntentData(x.key());
                            return IntentData.nextState((IntentData)current, (IntentState)IntentState.FAILED);
                        }
                    }
                    return null;
                })).collect(Collectors.toList());
                IntentManager.this.store.batchWrite((Iterable)((List)Tools.allOf(futures).join()).stream().filter(Objects::nonNull).collect(Collectors.toList()));
            }, IntentManager.this.batchExecutor).exceptionally(e -> {
                log.error("Error submitting batches:", e);
                log.error("Walk the plank, matey...");
                return null;
            })).thenRun(IntentManager.this.accumulator::ready);
        }
    }

    private class InternalTopoChangeDelegate
    implements TopologyChangeDelegate {
        private InternalTopoChangeDelegate() {
        }

        public void triggerCompile(Iterable<Key> intentKeys, boolean compileAllFailed) {
            log.trace("submitting {} + all?:{}", intentKeys, (Object)compileAllFailed);
            IntentManager.this.buildAndSubmitBatches(intentKeys, compileAllFailed);
        }
    }

    private class TestOnlyIntentStoreDelegate
    implements IntentStoreDelegate {
        private TestOnlyIntentStoreDelegate() {
        }

        public void process(IntentData data) {
            IntentManager.this.accumulator.add(data);
        }

        public void onUpdate(IntentData data) {
            IntentManager.this.trackerService.trackIntent(data);
        }

        public void notify(IntentEvent event) {
            IntentManager.this.post((Event)event);
        }
    }

    private class InternalStoreDelegate
    implements IntentStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(IntentEvent event) {
            IntentManager.this.post((Event)event);
            switch ((IntentEvent.Type)event.type()) {
                case WITHDRAWN: {
                    if (IntentManager.this.skipReleaseResourcesOnWithdrawal) break;
                    this.releaseResources((Intent)event.subject());
                    break;
                }
            }
        }

        public void process(IntentData data) {
            IntentManager.this.accumulator.add(data);
        }

        public void onUpdate(IntentData intentData) {
            IntentManager.this.trackerService.trackIntent(intentData);
        }

        private void releaseResources(Intent intent) {
            ResourceGroup resourceConsumer = intent.resourceGroup() != null ? intent.resourceGroup() : intent.key();
            boolean removeResource = false;
            if (intent.resourceGroup() == null) {
                removeResource = true;
            } else {
                Long remainingIntents = Tools.stream((Iterable)IntentManager.this.store.getIntents()).filter(i -> i.resourceGroup() != null && i.resourceGroup().equals((Object)intent.resourceGroup())).count();
                if (remainingIntents == 0L) {
                    removeResource = true;
                }
            }
            if (removeResource && !IntentManager.this.resourceService.release((ResourceConsumer)resourceConsumer)) {
                log.error("Failed to release resources allocated to {}", (Object)resourceConsumer);
            }
        }
    }
}

