/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl;

import com.google.common.base.Strings;
import java.util.Dictionary;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.event.EventListener;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentStore;
import org.onosproject.net.intent.Key;
import org.onosproject.store.Timestamp;
import org.onosproject.store.service.WallClockTimestamp;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class IntentCleanup
implements Runnable,
IntentListener {
    private static final Logger log = LoggerFactory.getLogger(IntentCleanup.class);
    private static final int INSTALLING_WITHDRAWING_PERIOD = 120;
    private static final int DEFAULT_PERIOD = 5;
    private static final int DEFAULT_THRESHOLD = 5;
    @Property(name="enabled", boolValue={true}, label="Enables/disables the intent cleanup component")
    private boolean enabled = true;
    @Property(name="period", intValue={5}, label="Frequency in ms between cleanup runs")
    protected int period = 5;
    private long periodMs;
    private long periodMsForStuck;
    @Property(name="retryThreshold", intValue={5}, label="Number of times to retry CORRUPT intent without delay")
    protected int retryThreshold = 5;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService service;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private ExecutorService executor;
    private Timer timer;
    private TimerTask timerTask;

    @Activate
    public void activate() {
        this.cfgService.registerProperties(this.getClass());
        this.executor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/intent", (String)"cleanup", (Logger)log));
        this.timer = new Timer("onos-intent-cleanup-timer");
        this.service.addListener((EventListener)this);
        this.adjustRate();
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.service.removeListener((EventListener)this);
        this.timer.cancel();
        this.timerTask = null;
        this.executor.shutdown();
        log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        boolean newEnabled;
        int newPeriod;
        Dictionary properties = context != null ? context.getProperties() : new Properties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"period");
            newPeriod = Strings.isNullOrEmpty((String)s) ? this.period : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"retryThreshold");
            this.retryThreshold = Strings.isNullOrEmpty((String)s) ? this.retryThreshold : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"enabled");
            newEnabled = Strings.isNullOrEmpty((String)s) ? this.enabled : Boolean.parseBoolean(s.trim());
        }
        catch (NumberFormatException e) {
            log.warn(e.getMessage());
            newPeriod = this.period;
            newEnabled = this.enabled;
        }
        if (newPeriod != this.period || this.enabled != newEnabled || newPeriod <= 120) {
            this.period = newPeriod;
            this.enabled = newEnabled;
            this.adjustRate();
        }
        log.info("Settings: enabled={}, period={}, retryThreshold={}", new Object[]{this.enabled, this.period, this.retryThreshold});
    }

    protected void adjustRate() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.enabled) {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    IntentCleanup.this.executor.execute(IntentCleanup.this);
                }
            };
            this.periodMs = this.period * 1000;
            this.periodMsForStuck = 120000L;
            this.timer.scheduleAtFixedRate(this.timerTask, this.periodMs, this.periodMs);
        }
    }

    @Override
    public void run() {
        try {
            this.cleanup();
        }
        catch (Exception e) {
            log.warn("Caught exception during Intent cleanup", (Throwable)e);
        }
    }

    private void resubmitCorrupt(IntentData intentData, boolean checkThreshold) {
        if (checkThreshold && intentData.errorCount() >= this.retryThreshold) {
            return;
        }
        switch (intentData.request()) {
            case INSTALL_REQ: {
                this.service.submit(intentData.intent());
                break;
            }
            case WITHDRAW_REQ: {
                this.service.withdraw(intentData.intent());
                break;
            }
            default: {
                log.warn("Trying to resubmit corrupt/failed intent {} in state {} with request {}", new Object[]{intentData.key(), intentData.state(), intentData.request()});
            }
        }
    }

    private void resubmitPendingRequest(IntentData intentData) {
        switch (intentData.request()) {
            case INSTALL_REQ: 
            case WITHDRAW_REQ: 
            case PURGE_REQ: {
                this.service.addPending(intentData);
                break;
            }
            default: {
                log.warn("Failed to resubmit pending intent {} in state {} with request {}", new Object[]{intentData.key(), intentData.state(), intentData.request()});
            }
        }
    }

    private void cleanup() {
        int corruptCount = 0;
        int failedCount = 0;
        int stuckCount = 0;
        int pendingCount = 0;
        int skipped = 0;
        for (IntentData intentData : this.store.getPendingData(true, this.periodMs)) {
            log.debug("Resubmit Pending Intent: key {}, state {}, request {}", new Object[]{intentData.key(), intentData.state(), intentData.request()});
            this.resubmitPendingRequest(intentData);
            ++pendingCount;
        }
        for (IntentData intentData : this.store.getIntentData(true, this.periodMs)) {
            switch (intentData.state()) {
                case FAILED: {
                    log.debug("Resubmit Failed Intent: key {}, state {}, request {}", new Object[]{intentData.key(), intentData.state(), intentData.request()});
                    this.resubmitCorrupt(intentData, false);
                    ++failedCount;
                    break;
                }
                case CORRUPT: {
                    log.debug("Resubmit Corrupt Intent: key {}, state {}, request {}", new Object[]{intentData.key(), intentData.state(), intentData.request()});
                    this.resubmitCorrupt(intentData, false);
                    ++corruptCount;
                    break;
                }
                case INSTALLING: 
                case WITHDRAWING: {
                    WallClockTimestamp time = new WallClockTimestamp(System.currentTimeMillis() - this.periodMsForStuck);
                    if (intentData.version().isOlderThan((Timestamp)time)) {
                        this.resubmitPendingRequest(intentData);
                        ++stuckCount;
                        break;
                    }
                    ++skipped;
                    break;
                }
            }
        }
        if (corruptCount + failedCount + stuckCount + pendingCount > 0) {
            log.debug("Intent cleanup ran and resubmitted {} corrupt, {} failed, {} stuck, and {} pending intents", new Object[]{corruptCount, failedCount, stuckCount, pendingCount});
        }
        if (skipped > 0) {
            log.debug("Intent cleanup skipped {} intents", (Object)skipped);
        }
    }

    public void event(IntentEvent event) {
        Key key;
        if (this.enabled && event.type() == IntentEvent.Type.CORRUPT && this.store.isMaster(key = ((Intent)event.subject()).key())) {
            IntentData data = this.store.getIntentData(((Intent)event.subject()).key());
            this.resubmitCorrupt(data, true);
        }
    }

    protected void bindService(IntentService intentService) {
        this.service = intentService;
    }

    protected void unbindService(IntentService intentService) {
        if (this.service == intentService) {
            this.service = null;
        }
    }

    protected void bindStore(IntentStore intentStore) {
        this.store = intentStore;
    }

    protected void unbindStore(IntentStore intentStore) {
        if (this.store == intentStore) {
            this.store = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }
}

