/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import org.onlab.util.AbstractAccumulator;
import org.onosproject.net.intent.IntentBatchDelegate;
import org.onosproject.net.intent.IntentData;

public class IntentAccumulator
extends AbstractAccumulator<IntentData> {
    private static final int DEFAULT_MAX_EVENTS = 1000;
    private static final int DEFAULT_MAX_IDLE_MS = 10;
    private static final int DEFAULT_MAX_BATCH_MS = 50;
    private static final Timer TIMER = new Timer("onos-intent-op-batching");
    private final IntentBatchDelegate delegate;
    private volatile boolean ready;

    protected IntentAccumulator(IntentBatchDelegate delegate) {
        super(TIMER, 1000, 50, 10);
        this.delegate = delegate;
        this.ready = true;
    }

    public void processItems(List<IntentData> items) {
        this.ready = false;
        this.delegate.execute(this.reduce(items));
    }

    private Collection<IntentData> reduce(List<IntentData> ops) {
        HashMap map = Maps.newHashMap();
        for (IntentData op : ops) {
            map.put(op.key(), op);
        }
        return map.values();
    }

    public boolean isReady() {
        return this.ready;
    }

    public void ready() {
        this.ready = true;
    }
}

