/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentInstaller;

public class InstallerRegistry {
    private final Map<Class<? extends Intent>, IntentInstaller<? extends Intent>> installers = Maps.newConcurrentMap();

    public <T extends Intent> void registerInstaller(Class<T> cls, IntentInstaller<T> installer) {
        this.installers.put(cls, installer);
    }

    public <T extends Intent> void unregisterInstaller(Class<T> cls) {
        this.installers.remove(cls);
    }

    public Map<Class<? extends Intent>, IntentInstaller<? extends Intent>> getInstallers() {
        return ImmutableMap.copyOf(this.installers);
    }

    public <T extends Intent> IntentInstaller<T> getInstaller(Class<T> cls) {
        return this.installers.get(cls);
    }
}

