/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentInstallationContext;
import org.onosproject.net.intent.IntentInstaller;
import org.onosproject.net.intent.IntentOperationContext;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentStore;
import org.onosproject.net.intent.impl.InstallerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallCoordinator {
    private static final String INSTALLER_NOT_FOUND = "Intent installer not found, Intent: {}";
    private final Logger log = LoggerFactory.getLogger(InstallCoordinator.class);
    private InstallerRegistry installerRegistry;
    private IntentStore intentStore;

    public InstallCoordinator(InstallerRegistry installerRegistry, IntentStore intentStore) {
        this.installerRegistry = installerRegistry;
        this.intentStore = intentStore;
    }

    public void installIntents(Optional<IntentData> toUninstall, Optional<IntentData> toInstall) {
        ArrayListMultimap<IntentInstaller, Intent> installInstallers;
        ArrayListMultimap<IntentInstaller, Intent> uninstallInstallers;
        if (!toUninstall.isPresent() && !toInstall.isPresent()) {
            return;
        }
        HashSet allInstallers = Sets.newHashSet();
        if (toUninstall.isPresent()) {
            uninstallInstallers = this.getInstallers(toUninstall.get());
            allInstallers.addAll(uninstallInstallers.keySet());
        } else {
            uninstallInstallers = ArrayListMultimap.create();
        }
        if (toInstall.isPresent()) {
            installInstallers = this.getInstallers(toInstall.get());
            allInstallers.addAll(installInstallers.keySet());
        } else {
            installInstallers = ArrayListMultimap.create();
        }
        IntentInstallationContext installationContext = new IntentInstallationContext((IntentData)toUninstall.orElse(null), (IntentData)toInstall.orElse(null));
        HashMap contexts = Maps.newHashMap();
        allInstallers.forEach(installer -> {
            List intentsToUninstall = uninstallInstallers.get(installer);
            List intentsToInstall = installInstallers.get(installer);
            IntentOperationContext context = new IntentOperationContext(intentsToUninstall, intentsToInstall, installationContext);
            installationContext.addPendingContext(context);
            contexts.put(installer, context);
        });
        contexts.forEach((installer, context) -> installer.apply(context));
    }

    private ArrayListMultimap<IntentInstaller, Intent> getInstallers(IntentData intentData) {
        ArrayListMultimap intentInstallers = ArrayListMultimap.create();
        intentData.installables().forEach(intent -> {
            IntentInstaller<?> installer = this.installerRegistry.getInstaller(intent.getClass());
            if (installer != null) {
                intentInstallers.put(installer, intent);
            } else {
                this.log.warn(INSTALLER_NOT_FOUND, intent);
            }
        });
        return intentInstallers;
    }

    public void success(IntentOperationContext context) {
        IntentInstallationContext intentInstallationContext = context.intentInstallationContext();
        intentInstallationContext.removePendingContext(context);
        if (intentInstallationContext.isPendingContextsEmpty()) {
            this.finish(intentInstallationContext);
        }
    }

    public void failed(IntentOperationContext context) {
        IntentInstallationContext intentInstallationContext = context.intentInstallationContext();
        intentInstallationContext.addErrorContext(context);
        intentInstallationContext.removePendingContext(context);
        if (intentInstallationContext.isPendingContextsEmpty()) {
            this.finish(intentInstallationContext);
        }
    }

    private void finish(IntentInstallationContext intentInstallationContext) {
        Set errCtxs = intentInstallationContext.errorContexts();
        Optional toUninstall = intentInstallationContext.toUninstall();
        Optional toInstall = intentInstallationContext.toInstall();
        if (errCtxs == null || errCtxs.isEmpty()) {
            if (toInstall.isPresent()) {
                IntentData installData = (IntentData)toInstall.get();
                this.log.debug("Completed installing: {}:{}", (Object)installData.key(), (Object)installData.intent().id());
                installData = new IntentData(installData, installData.installables());
                installData.setState(IntentState.INSTALLED);
                this.intentStore.write(installData);
            } else if (toUninstall.isPresent()) {
                IntentData uninstallData = (IntentData)toUninstall.get();
                uninstallData = new IntentData(uninstallData, Collections.emptyList());
                this.log.debug("Completed withdrawing: {}:{}", (Object)uninstallData.key(), (Object)uninstallData.intent().id());
                switch (uninstallData.request()) {
                    case INSTALL_REQ: {
                        uninstallData.setState(IntentState.FAILED);
                        break;
                    }
                    default: {
                        uninstallData.setState(IntentState.WITHDRAWN);
                    }
                }
                this.intentStore.write(uninstallData);
            }
        } else {
            if (toInstall.isPresent()) {
                IntentData installData = (IntentData)toInstall.get();
                this.intentStore.write(IntentData.corrupt((IntentData)installData));
            }
            if (toUninstall.isPresent()) {
                IntentData uninstallData = (IntentData)toUninstall.get();
                this.intentStore.write(IntentData.corrupt((IntentData)uninstallData));
            }
        }
    }
}

