/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentException;

class CompilerRegistry {
    private final ConcurrentMap<Class<? extends Intent>, IntentCompiler<? extends Intent>> compilers = new ConcurrentHashMap<Class<? extends Intent>, IntentCompiler<? extends Intent>>();

    CompilerRegistry() {
    }

    public <T extends Intent> void registerCompiler(Class<T> cls, IntentCompiler<T> compiler) {
        this.compilers.put(cls, compiler);
    }

    public <T extends Intent> void unregisterCompiler(Class<T> cls) {
        this.compilers.remove(cls);
    }

    public Map<Class<? extends Intent>, IntentCompiler<? extends Intent>> getCompilers() {
        return ImmutableMap.copyOf(this.compilers);
    }

    List<Intent> compile(Intent intent, List<Intent> previousInstallables) {
        Intent compiling;
        if (intent.isInstallable()) {
            return ImmutableList.of((Object)intent);
        }
        ArrayList<Intent> installables = new ArrayList<Intent>();
        LinkedList<Intent> compileQueue = new LinkedList<Intent>();
        compileQueue.add(intent);
        while ((compiling = (Intent)compileQueue.poll()) != null) {
            this.registerSubclassCompilerIfNeeded(compiling);
            List compiled = this.getCompiler(compiling).compile(compiling, previousInstallables);
            compiled.forEach(i -> {
                if (i.isInstallable()) {
                    installables.add((Intent)i);
                } else {
                    compileQueue.add((Intent)i);
                }
            });
        }
        return installables;
    }

    private <T extends Intent> IntentCompiler<T> getCompiler(T intent) {
        IntentCompiler compiler = (IntentCompiler)this.compilers.get(intent.getClass());
        if (compiler == null) {
            throw new IntentException("no compiler for class " + intent.getClass());
        }
        return compiler;
    }

    private void registerSubclassCompilerIfNeeded(Intent intent) {
        if (!this.compilers.containsKey(intent.getClass())) {
            for (Class<?> cls = intent.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
                IntentCompiler compiler;
                if (!Intent.class.isAssignableFrom(cls) || (compiler = (IntentCompiler)this.compilers.get(cls)) == null) continue;
                this.compilers.put(intent.getClass(), (IntentCompiler<? extends Intent>)compiler);
                return;
            }
        }
    }
}

