/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host.impl;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.onlab.packet.ARP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.packet.ndp.NeighborSolicitation;
import org.onlab.util.Timer;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.impl.HostManager;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostMonitor
implements TimerTask {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private PacketService packetService;
    private HostManager hostManager;
    private InterfaceService interfaceService;
    private EdgePortService edgePortService;
    private final Set<IpAddress> monitoredAddresses;
    private final ConcurrentMap<ProviderId, HostProvider> hostProviders;
    private static final long DEFAULT_PROBE_RATE = 30000L;
    private static final byte[] ZERO_MAC_ADDRESS = MacAddress.ZERO.toBytes();
    private long probeRate = 30000L;
    private Timeout timeout;

    public HostMonitor(PacketService packetService, HostManager hostManager, InterfaceService interfaceService, EdgePortService edgePortService) {
        this.packetService = packetService;
        this.hostManager = hostManager;
        this.interfaceService = interfaceService;
        this.edgePortService = edgePortService;
        this.monitoredAddresses = Collections.newSetFromMap(new ConcurrentHashMap());
        this.hostProviders = new ConcurrentHashMap<ProviderId, HostProvider>();
    }

    void addMonitoringFor(IpAddress ip) {
        if (this.monitoredAddresses.add(ip)) {
            this.probe(ip);
        }
    }

    void stopMonitoring(IpAddress ip) {
        this.monitoredAddresses.remove(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        HostMonitor hostMonitor = this;
        synchronized (hostMonitor) {
            if (this.timeout == null) {
                this.timeout = Timer.getTimer().newTimeout((TimerTask)this, 0L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        HostMonitor hostMonitor = this;
        synchronized (hostMonitor) {
            this.timeout.cancel();
            this.timeout = null;
        }
    }

    void setProbeRate(long probeRate) {
        this.probeRate = probeRate;
    }

    void registerHostProvider(HostProvider provider) {
        this.hostProviders.put(provider.id(), provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Timeout timeout) throws Exception {
        this.monitoredAddresses.forEach(this::probe);
        HostMonitor hostMonitor = this;
        synchronized (hostMonitor) {
            this.timeout = Timer.getTimer().newTimeout((TimerTask)this, this.probeRate, TimeUnit.MILLISECONDS);
        }
    }

    private void probe(IpAddress ip) {
        Set<Host> hosts = this.hostManager.getHostsByIp(ip);
        if (hosts.isEmpty()) {
            this.sendRequest(ip);
        } else {
            for (Host host : hosts) {
                HostProvider provider = (HostProvider)this.hostProviders.get(host.providerId());
                if (provider == null) {
                    this.hostProviders.remove(host.providerId(), null);
                    continue;
                }
                provider.triggerProbe(host);
            }
        }
    }

    private void sendRequest(IpAddress targetIp) {
        this.interfaceService.getMatchingInterfaces(targetIp).forEach(intf -> {
            if (!this.edgePortService.isEdgePoint(intf.connectPoint())) {
                this.log.warn("Aborting attempt to send probe out non-edge port: {}", intf);
                return;
            }
            intf.ipAddressesList().stream().filter(ia -> ia.subnetAddress().contains(targetIp)).forEach(ia -> {
                this.log.debug("Sending probe for target:{} out of intf:{} vlan:{}", new Object[]{targetIp, intf.connectPoint(), intf.vlan()});
                this.sendProbe(intf.connectPoint(), targetIp, ia.ipAddress(), intf.mac(), intf.vlan());
                if (!intf.vlanTagged().isEmpty()) {
                    intf.vlanTagged().forEach(tag -> {
                        this.log.debug("Sending probe for target:{} out of intf:{} vlan:{}", new Object[]{targetIp, intf.connectPoint(), tag});
                        this.sendProbe(intf.connectPoint(), targetIp, ia.ipAddress(), intf.mac(), (VlanId)tag);
                    });
                }
            });
        });
    }

    public void sendProbe(ConnectPoint connectPoint, IpAddress targetIp, IpAddress sourceIp, MacAddress sourceMac, VlanId vlan) {
        Ethernet probePacket;
        if (targetIp.isIp4()) {
            probePacket = this.buildArpRequest(targetIp, sourceIp, sourceMac, vlan);
        } else {
            byte[] destIp = IPv6.getSolicitNodeAddress((byte[])targetIp.toOctets());
            probePacket = NeighborSolicitation.buildNdpSolicit((byte[])targetIp.toOctets(), (byte[])sourceIp.toOctets(), (byte[])destIp, (byte[])sourceMac.toBytes(), (byte[])IPv6.getMCastMacAddress((byte[])destIp), (VlanId)vlan);
        }
        if (probePacket == null) {
            this.log.warn("Not able to build the probe packet");
            return;
        }
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(connectPoint.port()).build();
        DefaultOutboundPacket outboundPacket = new DefaultOutboundPacket(connectPoint.deviceId(), treatment, ByteBuffer.wrap(probePacket.serialize()));
        this.packetService.emit((OutboundPacket)outboundPacket);
    }

    private Ethernet buildArpRequest(IpAddress targetIp, IpAddress sourceIp, MacAddress sourceMac, VlanId vlan) {
        ARP arp = new ARP();
        arp.setHardwareType((short)1).setHardwareAddressLength((byte)6).setProtocolType((short)2048).setProtocolAddressLength((byte)4).setOpCode((short)1);
        arp.setSenderHardwareAddress(sourceMac.toBytes()).setSenderProtocolAddress(sourceIp.toOctets()).setTargetHardwareAddress(ZERO_MAC_ADDRESS).setTargetProtocolAddress(targetIp.toOctets());
        Ethernet ethernet = new Ethernet();
        ethernet.setEtherType(Ethernet.TYPE_ARP).setDestinationMACAddress(MacAddress.BROADCAST).setSourceMACAddress(sourceMac).setPayload((IPacket)arp);
        if (!vlan.equals((Object)VlanId.NONE)) {
            ethernet.setVlanID(vlan.toShort());
        }
        ethernet.setPad(true);
        return ethernet;
    }
}

