/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host.impl;

import com.google.common.base.Preconditions;
import java.util.Dictionary;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicHostConfig;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.net.host.HostAdminService;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.HostStore;
import org.onosproject.net.host.HostStoreDelegate;
import org.onosproject.net.host.impl.BasicHostOperator;
import org.onosproject.net.host.impl.HostMonitor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class HostManager
extends AbstractListenerProviderRegistry<HostEvent, HostListener, HostProvider, HostProviderService>
implements HostService,
HostAdminService,
HostProviderRegistry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String HOST_ID_NULL = "Host ID cannot be null";
    private final NetworkConfigListener networkConfigListener = new InternalNetworkConfigListener();
    private HostStoreDelegate delegate = new InternalStoreDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EdgePortService edgePortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Property(name="allowDuplicateIps", boolValue={true}, label="Enable removal of duplicate ip address")
    private boolean allowDuplicateIps = true;
    @Property(name="monitorHosts", boolValue={false}, label="Enable/Disable monitoring of hosts")
    private boolean monitorHosts = false;
    @Property(name="probeRate", longValue={30000L}, label="Set the probe Rate in milli seconds")
    private long probeRate = 30000L;
    @Property(name="greedyLearningIpv6", boolValue={false}, label="Enable/Disable greedy learning of IPv6 link local address")
    private boolean greedyLearningIpv6 = false;
    private HostMonitor monitor;

    @Activate
    public void activate(ComponentContext context) {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(HostEvent.class, (EventSink)this.listenerRegistry);
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.networkConfigService.addListener((EventListener)this.networkConfigListener);
        this.monitor = new HostMonitor(this.packetService, this, this.interfaceService, this.edgePortService);
        this.monitor.setProbeRate(this.probeRate);
        this.monitor.start();
        this.modified(context);
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(HostEvent.class);
        this.networkConfigService.removeListener((EventListener)this.networkConfigListener);
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.monitor.shutdown();
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        boolean oldValue = this.monitorHosts;
        this.readComponentConfiguration(context);
        if (this.probeRate > 0L) {
            this.monitor.setProbeRate(this.probeRate);
        } else {
            this.log.warn("probeRate cannot be lessthan 0");
        }
        if (oldValue != this.monitorHosts) {
            if (this.monitorHosts) {
                this.startMonitoring();
            } else {
                this.stopMonitoring();
            }
        }
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Boolean flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"monitorHosts");
        if (flag == null) {
            this.log.info("monitorHosts is not enabled using current value of {}", (Object)this.monitorHosts);
        } else {
            this.monitorHosts = flag;
            this.log.info("Configured. monitorHosts {}", (Object)(this.monitorHosts ? "enabled" : "disabled"));
        }
        Long longValue = Tools.getLongProperty((Dictionary)properties, (String)"probeRate");
        if (longValue == null || longValue == 0L) {
            this.log.info("probeRate is not set sing default value of {}", (Object)this.probeRate);
        } else {
            this.probeRate = longValue;
            this.log.info("Configured. probeRate {}", (Object)this.probeRate);
        }
        flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"allowDuplicateIps");
        if (flag == null) {
            this.log.info("Removal of duplicate ip address is not configured");
        } else {
            this.allowDuplicateIps = flag;
            this.log.info("Removal of duplicate ip address is {}", (Object)(this.allowDuplicateIps ? "disabled" : "enabled"));
        }
        flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"greedyLearningIpv6");
        if (flag == null) {
            this.log.info("greedy learning is not enabled using current value of {}", (Object)this.greedyLearningIpv6);
        } else {
            this.greedyLearningIpv6 = flag;
            this.log.info("Configured. greedyLearningIpv6 {}", (Object)(this.greedyLearningIpv6 ? "enabled" : "disabled"));
        }
    }

    private void startMonitoring() {
        this.store.getHosts().forEach(host -> host.ipAddresses().forEach(ip -> this.monitor.addMonitoringFor((IpAddress)ip)));
    }

    private void stopMonitoring() {
        this.store.getHosts().forEach(host -> host.ipAddresses().forEach(ip -> this.monitor.stopMonitoring((IpAddress)ip)));
    }

    protected HostProviderService createProviderService(HostProvider provider) {
        this.monitor.registerHostProvider(provider);
        return new InternalHostProviderService(provider);
    }

    public int getHostCount() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.HOST_READ);
        return this.store.getHostCount();
    }

    public Iterable<Host> getHosts() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.HOST_READ);
        return this.store.getHosts();
    }

    public Host getHost(HostId hostId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.HOST_READ);
        Preconditions.checkNotNull((Object)hostId, (Object)HOST_ID_NULL);
        return this.store.getHost(hostId);
    }

    public Set<Host> getHostsByVlan(VlanId vlanId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.HOST_READ);
        return this.store.getHosts(vlanId);
    }

    public Set<Host> getHostsByMac(MacAddress mac) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.HOST_READ);
        Preconditions.checkNotNull((Object)mac, (Object)"MAC address cannot be null");
        return this.store.getHosts(mac);
    }

    public Set<Host> getHostsByIp(IpAddress ip) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.HOST_READ);
        Preconditions.checkNotNull((Object)ip, (Object)"IP address cannot be null");
        return this.store.getHosts(ip);
    }

    public Set<Host> getConnectedHosts(ConnectPoint connectPoint) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.HOST_READ);
        Preconditions.checkNotNull((Object)connectPoint, (Object)"Connection point cannot be null");
        return this.store.getConnectedHosts(connectPoint);
    }

    public Set<Host> getConnectedHosts(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.HOST_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)"Device ID cannot be null");
        return this.store.getConnectedHosts(deviceId);
    }

    public void startMonitoringIp(IpAddress ip) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.HOST_EVENT);
        this.monitor.addMonitoringFor(ip);
    }

    public void stopMonitoringIp(IpAddress ip) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.HOST_EVENT);
        this.monitor.stopMonitoring(ip);
    }

    public void requestMac(IpAddress ip) {
    }

    public void removeHost(HostId hostId) {
        Preconditions.checkNotNull((Object)hostId, (Object)HOST_ID_NULL);
        this.store.removeHost(hostId);
    }

    private boolean isAllowed(BasicHostConfig cfg) {
        return cfg == null || cfg.isAllowed();
    }

    private void kickOutBadHost(HostId hostId) {
        Host badHost = this.getHost(hostId);
        if (badHost != null) {
            this.removeHost(hostId);
        }
    }

    protected void bindStore(HostStore hostStore) {
        this.store = hostStore;
    }

    protected void unbindStore(HostStore hostStore) {
        if (this.store == hostStore) {
            this.store = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindEdgePortService(EdgePortService edgePortService) {
        this.edgePortService = edgePortService;
    }

    protected void unbindEdgePortService(EdgePortService edgePortService) {
        if (this.edgePortService == edgePortService) {
            this.edgePortService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public boolean isRelevant(NetworkConfigEvent event) {
            return (event.type() == NetworkConfigEvent.Type.CONFIG_ADDED || event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED) && event.configClass().equals(BasicHostConfig.class);
        }

        public void event(NetworkConfigEvent event) {
            HostManager.this.log.debug("Detected host network config event {}", (Object)event.type());
            HostEvent he = null;
            HostId hostId = (HostId)event.subject();
            BasicHostConfig cfg = (BasicHostConfig)HostManager.this.networkConfigService.getConfig((Object)hostId, BasicHostConfig.class);
            if (!HostManager.this.isAllowed(cfg)) {
                HostManager.this.kickOutBadHost(hostId);
            } else {
                Host host = HostManager.this.getHost(hostId);
                HostDescription desc = host == null ? null : BasicHostOperator.descriptionOf(host);
                if ((desc = BasicHostOperator.combine(cfg, desc)) != null) {
                    he = HostManager.this.store.createOrUpdateHost(host.providerId(), hostId, desc, false);
                }
            }
            if (he != null) {
                HostManager.this.post(he);
            }
        }
    }

    private class InternalStoreDelegate
    implements HostStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(HostEvent event) {
            HostManager.this.post((Event)event);
        }
    }

    private class InternalHostProviderService
    extends AbstractProviderService<HostProvider>
    implements HostProviderService {
        InternalHostProviderService(HostProvider provider) {
            super((Provider)provider);
        }

        public void hostDetected(HostId hostId, HostDescription hostDescription, boolean replaceIps) {
            Preconditions.checkNotNull((Object)hostId, (Object)HostManager.HOST_ID_NULL);
            this.checkValidity();
            hostDescription = this.validateHost(hostDescription, hostId);
            if (!HostManager.this.allowDuplicateIps) {
                this.removeDuplicates(hostId, hostDescription);
            }
            HostManager.this.store.createOrUpdateHost(((HostProvider)this.provider()).id(), hostId, hostDescription, replaceIps);
            if (HostManager.this.monitorHosts) {
                hostDescription.ipAddress().forEach(ip -> HostManager.this.monitor.addMonitoringFor((IpAddress)ip));
            }
            if (HostManager.this.greedyLearningIpv6) {
                Ip6Address targetIp6Address = Ip6Address.valueOf((byte[])IPv6.getLinkLocalAddress((byte[])hostId.mac().toBytes()));
                if (!hostDescription.ipAddress().contains(targetIp6Address)) {
                    Host host = HostManager.this.store.getHost(hostId);
                    if (host != null && host.configured()) {
                        return;
                    }
                    if (host == null || !host.ipAddresses().contains(targetIp6Address)) {
                        MacAddress onosMacAddress = MacAddress.valueOf((String)"DE:AD:BE:EF:BA:11");
                        Ip6Address onosIp6Address = Ip6Address.valueOf((byte[])IPv6.getLinkLocalAddress((byte[])onosMacAddress.toBytes()));
                        HostManager.this.monitor.sendProbe((ConnectPoint)hostDescription.location(), (IpAddress)targetIp6Address, (IpAddress)onosIp6Address, onosMacAddress, hostId.vlanId());
                    }
                }
            }
        }

        public void removeDuplicates(HostId hostId, HostDescription desc) {
            desc.ipAddress().forEach(ip -> {
                Set allHosts = HostManager.this.store.getHosts(ip);
                allHosts.forEach(eachHost -> {
                    if (!eachHost.id().equals((Object)hostId)) {
                        HostManager.this.log.info("Duplicate ip {} found on host {} and {}", new Object[]{ip, hostId.toString(), eachHost.id().toString()});
                        HostManager.this.store.removeIp(eachHost.id(), ip);
                    }
                });
            });
        }

        private HostDescription validateHost(HostDescription hostDescription, HostId hostId) {
            BasicHostConfig cfg = (BasicHostConfig)HostManager.this.networkConfigService.getConfig((Object)hostId, BasicHostConfig.class);
            Preconditions.checkState((cfg == null || cfg.isAllowed() ? 1 : 0) != 0, (String)"Host {} is not allowed", (Object)hostId);
            return BasicHostOperator.combine(cfg, hostDescription);
        }

        public void hostVanished(HostId hostId) {
            Preconditions.checkNotNull((Object)hostId, (Object)HostManager.HOST_ID_NULL);
            this.checkValidity();
            Host host = HostManager.this.store.getHost(hostId);
            if (host == null || !host.providerId().equals((Object)((HostProvider)this.provider()).id())) {
                return;
            }
            if (HostManager.this.monitorHosts) {
                host.ipAddresses().forEach(ip -> HostManager.this.monitor.stopMonitoring((IpAddress)ip));
            }
            HostManager.this.store.removeHost(hostId);
        }

        public void removeIpFromHost(HostId hostId, IpAddress ipAddress) {
            Preconditions.checkNotNull((Object)hostId, (Object)HostManager.HOST_ID_NULL);
            this.checkValidity();
            HostManager.this.store.removeIp(hostId, ipAddress);
        }
    }
}

