/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host.impl;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Host;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.basics.BasicElementConfig;
import org.onosproject.net.config.basics.BasicHostConfig;
import org.onosproject.net.device.impl.BasicElementOperator;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;

public final class BasicHostOperator
extends BasicElementOperator {
    private BasicHostOperator() {
    }

    public static HostDescription combine(BasicHostConfig cfg, HostDescription descr) {
        if (cfg == null || descr == null) {
            return descr;
        }
        HostLocation location = descr.location();
        ConnectPoint cfgLocation = cfg.location();
        if (cfgLocation != null) {
            location = new HostLocation(cfgLocation, System.currentTimeMillis());
        }
        Set ipAddresses = descr.ipAddress();
        Set cfgIpAddresses = cfg.ipAddresses();
        if (cfgIpAddresses != null) {
            ipAddresses = cfgIpAddresses;
        }
        SparseAnnotations sa = BasicHostOperator.combine(cfg, descr.annotations());
        return new DefaultHostDescription(descr.hwAddress(), descr.vlan(), location, ipAddresses, descr.configured(), new SparseAnnotations[]{sa});
    }

    public static SparseAnnotations combine(BasicHostConfig cfg, SparseAnnotations an) {
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        BasicHostOperator.combineElementAnnotations((BasicElementConfig)cfg, builder);
        return DefaultAnnotations.union((SparseAnnotations)an, (SparseAnnotations)builder.build());
    }

    public static HostDescription descriptionOf(Host host) {
        Preconditions.checkNotNull((Object)host, (Object)"Must supply a non-null Host");
        return new DefaultHostDescription(host.mac(), host.vlan(), host.location(), host.ipAddresses(), host.configured(), new SparseAnnotations[]{(SparseAnnotations)host.annotations()});
    }
}

