/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupOperations;
import org.onosproject.net.group.GroupProvider;
import org.onosproject.net.group.GroupProviderRegistry;
import org.onosproject.net.group.GroupProviderService;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.group.GroupStore;
import org.onosproject.net.group.GroupStoreDelegate;
import org.onosproject.net.group.impl.GroupDriverProvider;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class GroupManager
extends AbstractListenerProviderRegistry<GroupEvent, GroupListener, GroupProvider, GroupProviderService>
implements GroupService,
GroupProviderRegistry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final GroupStoreDelegate delegate = new InternalGroupStoreDelegate();
    private final DeviceListener deviceListener = new InternalDeviceListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected GroupStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Property(name="purgeOnDisconnection", boolValue={false}, label="Purge entries associated with a device when the device goes offline")
    private boolean purgeOnDisconnection = false;
    private final GroupDriverProvider defaultProvider = new GroupDriverProvider();

    @Activate
    public void activate(ComponentContext context) {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(GroupEvent.class, (EventSink)this.listenerRegistry);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.modified(context);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(GroupEvent.class);
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        if (context != null) {
            this.readComponentConfiguration(context);
        }
        this.defaultProvider.init(this.deviceService);
    }

    protected GroupProvider defaultProvider() {
        return this.defaultProvider;
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Boolean flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"purgeOnDisconnection");
        if (flag == null) {
            this.log.info("PurgeOnDisconnection is not configured, using current value of {}", (Object)this.purgeOnDisconnection);
        } else {
            this.purgeOnDisconnection = flag;
            this.log.info("Configured. PurgeOnDisconnection is {}", (Object)(this.purgeOnDisconnection ? "enabled" : "disabled"));
        }
    }

    public void addGroup(GroupDescription groupDesc) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.GROUP_WRITE);
        this.store.storeGroupDescription(groupDesc);
    }

    public Group getGroup(DeviceId deviceId, GroupKey appCookie) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.GROUP_READ);
        return this.store.getGroup(deviceId, appCookie);
    }

    public void addBucketsToGroup(DeviceId deviceId, GroupKey oldCookie, GroupBuckets buckets, GroupKey newCookie, ApplicationId appId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.GROUP_WRITE);
        this.store.updateGroupDescription(deviceId, oldCookie, GroupStore.UpdateType.ADD, buckets, newCookie);
    }

    public void removeBucketsFromGroup(DeviceId deviceId, GroupKey oldCookie, GroupBuckets buckets, GroupKey newCookie, ApplicationId appId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.GROUP_WRITE);
        this.store.updateGroupDescription(deviceId, oldCookie, GroupStore.UpdateType.REMOVE, buckets, newCookie);
    }

    public void setBucketsForGroup(DeviceId deviceId, GroupKey oldCookie, GroupBuckets buckets, GroupKey newCookie, ApplicationId appId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.GROUP_WRITE);
        this.store.updateGroupDescription(deviceId, oldCookie, GroupStore.UpdateType.SET, buckets, newCookie);
    }

    public void purgeGroupEntries(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.GROUP_WRITE);
        this.store.purgeGroupEntry(deviceId);
    }

    public void purgeGroupEntries() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.GROUP_WRITE);
        this.store.purgeGroupEntries();
    }

    public void removeGroup(DeviceId deviceId, GroupKey appCookie, ApplicationId appId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.GROUP_WRITE);
        this.store.deleteGroupDescription(deviceId, appCookie);
    }

    public Iterable<Group> getGroups(DeviceId deviceId, ApplicationId appId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.GROUP_READ);
        return this.store.getGroups(deviceId);
    }

    public Iterable<Group> getGroups(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.GROUP_READ);
        return this.store.getGroups(deviceId);
    }

    protected GroupProviderService createProviderService(GroupProvider provider) {
        return new InternalGroupProviderService(provider);
    }

    protected void bindStore(GroupStore groupStore) {
        this.store = groupStore;
    }

    protected void unbindStore(GroupStore groupStore) {
        if (this.store == groupStore) {
            this.store = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_REMOVED: 
                case DEVICE_AVAILABILITY_CHANGED: {
                    DeviceId deviceId = ((Device)event.subject()).id();
                    if (GroupManager.this.deviceService.isAvailable(deviceId)) break;
                    GroupManager.this.log.debug("Device {} became un available; clearing initial audit status", (Object)event.type(), (Object)((Device)event.subject()).id());
                    GroupManager.this.store.deviceInitialAuditCompleted(((Device)event.subject()).id(), false);
                    if (!GroupManager.this.purgeOnDisconnection) break;
                    GroupManager.this.store.purgeGroupEntry(deviceId);
                    break;
                }
            }
        }
    }

    private class InternalGroupProviderService
    extends AbstractProviderService<GroupProvider>
    implements GroupProviderService {
        protected InternalGroupProviderService(GroupProvider provider) {
            super((Provider)provider);
        }

        public void groupOperationFailed(DeviceId deviceId, GroupOperation operation) {
            GroupManager.this.store.groupOperationFailed(deviceId, operation);
        }

        public void pushGroupMetrics(DeviceId deviceId, Collection<Group> groupEntries) {
            GroupManager.this.log.trace("Received group metrics from device {}", (Object)deviceId);
            this.checkValidity();
            GroupManager.this.store.pushGroupMetrics(deviceId, groupEntries);
        }

        public void notifyOfFailovers(Collection<Group> failoverGroups) {
            GroupManager.this.store.notifyOfFailovers(failoverGroups);
        }
    }

    private class InternalGroupStoreDelegate
    implements GroupStoreDelegate {
        private InternalGroupStoreDelegate() {
        }

        public void notify(GroupEvent event) {
            Group group = (Group)event.subject();
            GroupProvider groupProvider = (GroupProvider)GroupManager.this.getProvider(group.deviceId());
            GroupOperations groupOps = null;
            switch ((GroupEvent.Type)event.type()) {
                case GROUP_ADD_REQUESTED: {
                    GroupManager.this.log.debug("GROUP_ADD_REQUESTED for Group {} on device {}", (Object)group.id(), (Object)group.deviceId());
                    GroupOperation groupAddOp = GroupOperation.createAddGroupOperation((GroupId)group.id(), (GroupDescription.Type)group.type(), (GroupBuckets)group.buckets());
                    groupOps = new GroupOperations(Collections.singletonList(groupAddOp));
                    groupProvider.performGroupOperation(group.deviceId(), groupOps);
                    break;
                }
                case GROUP_UPDATE_REQUESTED: {
                    GroupManager.this.log.debug("GROUP_UPDATE_REQUESTED for Group {} on device {}", (Object)group.id(), (Object)group.deviceId());
                    GroupOperation groupModifyOp = GroupOperation.createModifyGroupOperation((GroupId)group.id(), (GroupDescription.Type)group.type(), (GroupBuckets)group.buckets());
                    groupOps = new GroupOperations(Collections.singletonList(groupModifyOp));
                    groupProvider.performGroupOperation(group.deviceId(), groupOps);
                    break;
                }
                case GROUP_REMOVE_REQUESTED: {
                    GroupManager.this.log.debug("GROUP_REMOVE_REQUESTED for Group {} on device {}", (Object)group.id(), (Object)group.deviceId());
                    GroupOperation groupDeleteOp = GroupOperation.createDeleteGroupOperation((GroupId)group.id(), (GroupDescription.Type)group.type());
                    groupOps = new GroupOperations(Collections.singletonList(groupDeleteOp));
                    groupProvider.performGroupOperation(group.deviceId(), groupOps);
                    break;
                }
                case GROUP_ADDED: 
                case GROUP_UPDATED: 
                case GROUP_REMOVED: 
                case GROUP_ADD_FAILED: 
                case GROUP_UPDATE_FAILED: 
                case GROUP_REMOVE_FAILED: 
                case GROUP_BUCKET_FAILOVER: {
                    GroupManager.this.post((Event)event);
                    break;
                }
            }
        }
    }
}

