/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group.impl;

import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.group.GroupOperations;
import org.onosproject.net.group.GroupProgrammable;
import org.onosproject.net.group.GroupProvider;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDriverProvider
extends AbstractProvider
implements GroupProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String SCHEME = "default";
    private static final String PROVIDER_NAME = "org.onosproject.provider";
    protected DeviceService deviceService;

    public GroupDriverProvider() {
        super(new ProviderId(SCHEME, PROVIDER_NAME));
    }

    void init(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    public void performGroupOperation(DeviceId deviceId, GroupOperations groupOps) {
        GroupProgrammable programmable = this.getGroupProgrammable(deviceId);
        if (programmable != null) {
            programmable.performGroupOperation(deviceId, groupOps);
        }
    }

    private GroupProgrammable getGroupProgrammable(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device.is(GroupProgrammable.class)) {
            return (GroupProgrammable)device.as(GroupProgrammable.class);
        }
        this.log.debug("Device {} is not group programmable", (Object)deviceId);
        return null;
    }
}

