/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective.impl.composition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.impl.composition.ForwardUpdateTable;

public class ForwardTable {
    protected Map<Integer, ForwardingObjective> forwardMap = new HashMap<Integer, ForwardingObjective>();
    protected Map<Integer, List<ForwardingObjective>> generatedParentForwardingObjectiveMap = new HashMap<Integer, List<ForwardingObjective>>();

    public ForwardUpdateTable updateForward(ForwardingObjective forwardingObjective) {
        ForwardUpdateTable updates = new ForwardUpdateTable();
        switch (forwardingObjective.op()) {
            case ADD: {
                this.forwardMap.put(ForwardTable.forwardingObjectiveHash(forwardingObjective), forwardingObjective);
                this.generatedParentForwardingObjectiveMap.put(ForwardTable.forwardingObjectiveHash(forwardingObjective), new ArrayList());
                updates.addObjectives.add(forwardingObjective);
                break;
            }
            case REMOVE: {
                if (this.forwardMap.remove(ForwardTable.forwardingObjectiveHash(forwardingObjective)) == null) break;
                updates.removeObjectives.add(forwardingObjective);
                break;
            }
        }
        return updates;
    }

    public ForwardUpdateTable updateForward(List<ForwardingObjective> forwardingObjectives) {
        ForwardUpdateTable updates = new ForwardUpdateTable();
        for (ForwardingObjective forwardingObjective : forwardingObjectives) {
            updates.addUpdateTable(this.updateForward(forwardingObjective));
        }
        return updates;
    }

    public void addGeneratedParentForwardingObjective(ForwardingObjective child, ForwardingObjective parent) {
        this.generatedParentForwardingObjectiveMap.get(ForwardTable.forwardingObjectiveHash(child)).add(parent);
    }

    public void deleteGeneratedParentForwardingObjective(List<ForwardingObjective> children) {
        for (ForwardingObjective fo : children) {
            this.generatedParentForwardingObjectiveMap.remove(ForwardTable.forwardingObjectiveHash(fo));
        }
    }

    private List<ForwardingObjective> getGeneratedParentForwardingObjective(ForwardingObjective child) {
        return this.generatedParentForwardingObjectiveMap.get(ForwardTable.forwardingObjectiveHash(child));
    }

    public List<ForwardingObjective> getGeneratedParentForwardingObjectiveForRemove(ForwardingObjective child) {
        List<ForwardingObjective> fos = this.generatedParentForwardingObjectiveMap.get(ForwardTable.forwardingObjectiveHash(child));
        ArrayList<ForwardingObjective> removeFos = new ArrayList<ForwardingObjective>();
        for (ForwardingObjective fo : fos) {
            removeFos.add(DefaultForwardingObjective.builder().fromApp(fo.appId()).makePermanent().withFlag(fo.flag()).withPriority(fo.priority()).withSelector(fo.selector()).withTreatment(fo.treatment()).remove());
        }
        return removeFos;
    }

    public Collection<ForwardingObjective> getForwardingObjectives() {
        return this.forwardMap.values();
    }

    public static int forwardingObjectiveHash(ForwardingObjective forwardingObjective) {
        return Objects.hash(forwardingObjective.selector(), forwardingObjective.flag(), forwardingObjective.permanent(), forwardingObjective.timeout(), forwardingObjective.appId(), forwardingObjective.priority(), forwardingObjective.nextId(), forwardingObjective.treatment());
    }
}

