/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective.impl.composition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.onlab.packet.IpPrefix;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPv6FlowLabelCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.OchSignalCriterion;
import org.onosproject.net.flow.criteria.OduSignalIdCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.criteria.VlanPcpCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L1ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.impl.composition.FlowObjectiveCompositionManager;
import org.onosproject.net.flowobjective.impl.composition.FlowObjectiveCompositionTree;

public final class FlowObjectiveCompositionUtil {
    private FlowObjectiveCompositionUtil() {
    }

    public static ForwardingObjective composeParallel(ForwardingObjective fo1, ForwardingObjective fo2) {
        TrafficSelector trafficSelector = FlowObjectiveCompositionUtil.intersectTrafficSelector(fo1.selector(), fo2.selector());
        if (trafficSelector == null) {
            return null;
        }
        TrafficTreatment trafficTreatment = FlowObjectiveCompositionUtil.unionTrafficTreatment(fo1.treatment(), fo2.treatment());
        return DefaultForwardingObjective.builder().fromApp(fo1.appId()).makePermanent().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(fo1.priority() + fo2.priority()).withSelector(trafficSelector).withTreatment(trafficTreatment).add();
    }

    public static ForwardingObjective composeSequential(ForwardingObjective fo1, ForwardingObjective fo2, int priorityMultiplier) {
        TrafficSelector revertTrafficSelector = FlowObjectiveCompositionUtil.revertTreatmentSelector(fo1.treatment(), fo2.selector());
        if (revertTrafficSelector == null) {
            return null;
        }
        TrafficSelector trafficSelector = FlowObjectiveCompositionUtil.intersectTrafficSelector(fo1.selector(), revertTrafficSelector);
        if (trafficSelector == null) {
            return null;
        }
        TrafficTreatment trafficTreatment = FlowObjectiveCompositionUtil.unionTrafficTreatment(fo1.treatment(), fo2.treatment());
        return DefaultForwardingObjective.builder().fromApp(fo1.appId()).makePermanent().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(fo1.priority() * priorityMultiplier + fo2.priority()).withSelector(trafficSelector).withTreatment(trafficTreatment).add();
    }

    public static ForwardingObjective composeOverride(ForwardingObjective fo, int priorityAddend) {
        return DefaultForwardingObjective.builder().fromApp(fo.appId()).makePermanent().withFlag(fo.flag()).withPriority(fo.priority() + priorityAddend).withSelector(fo.selector()).withTreatment(fo.treatment()).add();
    }

    public static TrafficSelector intersectTrafficSelector(TrafficSelector ts1, TrafficSelector ts2) {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        Set<Criterion.Type> ts1IntersectTs2 = FlowObjectiveCompositionUtil.getTypeSet(ts1);
        ts1IntersectTs2.retainAll(FlowObjectiveCompositionUtil.getTypeSet(ts2));
        for (Criterion.Type type : ts1IntersectTs2) {
            Criterion criterion = FlowObjectiveCompositionUtil.intersectCriterion(ts1.getCriterion(type), ts2.getCriterion(type));
            if (criterion == null) {
                return null;
            }
            selectorBuilder.add(criterion);
        }
        Set<Criterion.Type> ts1MinusTs2 = FlowObjectiveCompositionUtil.getTypeSet(ts1);
        ts1MinusTs2.removeAll(FlowObjectiveCompositionUtil.getTypeSet(ts2));
        for (Criterion.Type type : ts1MinusTs2) {
            selectorBuilder.add(ts1.getCriterion(type));
        }
        Set<Criterion.Type> set = FlowObjectiveCompositionUtil.getTypeSet(ts2);
        set.removeAll(FlowObjectiveCompositionUtil.getTypeSet(ts1));
        for (Criterion.Type type : set) {
            selectorBuilder.add(ts2.getCriterion(type));
        }
        return selectorBuilder.build();
    }

    public static TrafficTreatment unionTrafficTreatment(TrafficTreatment tt1, TrafficTreatment tt2) {
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        for (Instruction instruction : tt1.allInstructions()) {
            treatmentBuilder.add(instruction);
        }
        for (Instruction instruction : tt2.allInstructions()) {
            treatmentBuilder.add(instruction);
        }
        return treatmentBuilder.build();
    }

    public static TrafficSelector revertTreatmentSelector(TrafficTreatment trafficTreatment, TrafficSelector trafficSelector) {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        HashMap<Criterion.Type, Criterion> criterionMap = new HashMap<Criterion.Type, Criterion>();
        for (Criterion criterion : trafficSelector.criteria()) {
            criterionMap.put(criterion.type(), criterion);
        }
        for (Instruction instruction : trafficTreatment.allInstructions()) {
            block0 : switch (instruction.type()) {
                case OUTPUT: {
                    break;
                }
                case GROUP: {
                    break;
                }
                case L0MODIFICATION: {
                    L0ModificationInstruction l0 = (L0ModificationInstruction)instruction;
                    switch (l0.subtype()) {
                        case OCH: {
                            if (!criterionMap.containsKey(Criterion.Type.OCH_SIGID)) break;
                            if (((OchSignalCriterion)criterionMap.get(Criterion.Type.OCH_SIGID)).lambda().equals((Object)((L0ModificationInstruction.ModOchSignalInstruction)l0).lambda())) {
                                criterionMap.remove(Criterion.Type.OCH_SIGID);
                                break block0;
                            }
                            return null;
                        }
                    }
                    break;
                }
                case L1MODIFICATION: {
                    L1ModificationInstruction l1 = (L1ModificationInstruction)instruction;
                    switch (l1.subtype()) {
                        case ODU_SIGID: {
                            if (!criterionMap.containsKey(Criterion.Type.ODU_SIGID)) break;
                            if (((OduSignalIdCriterion)criterionMap.get(Criterion.Type.ODU_SIGID)).oduSignalId().equals((Object)((L1ModificationInstruction.ModOduSignalIdInstruction)l1).oduSignalId())) {
                                criterionMap.remove(Criterion.Type.ODU_SIGID);
                                break block0;
                            }
                            return null;
                        }
                    }
                    break;
                }
                case L2MODIFICATION: {
                    L2ModificationInstruction l2 = (L2ModificationInstruction)instruction;
                    switch (l2.subtype()) {
                        case ETH_SRC: {
                            if (!criterionMap.containsKey(Criterion.Type.ETH_SRC)) break block0;
                            if (((EthCriterion)criterionMap.get(Criterion.Type.ETH_SRC)).mac().equals((Object)((L2ModificationInstruction.ModEtherInstruction)l2).mac())) {
                                criterionMap.remove(Criterion.Type.ETH_SRC);
                            } else {
                                return null;
                            }
                        }
                        case ETH_DST: {
                            if (!criterionMap.containsKey(Criterion.Type.ETH_DST)) break block0;
                            if (((EthCriterion)criterionMap.get(Criterion.Type.ETH_DST)).mac().equals((Object)((L2ModificationInstruction.ModEtherInstruction)l2).mac())) {
                                criterionMap.remove(Criterion.Type.ETH_DST);
                            } else {
                                return null;
                            }
                        }
                        case VLAN_ID: {
                            if (!criterionMap.containsKey(Criterion.Type.VLAN_VID)) break block0;
                            if (((VlanIdCriterion)criterionMap.get(Criterion.Type.VLAN_VID)).vlanId().equals((Object)((L2ModificationInstruction.ModVlanIdInstruction)l2).vlanId())) {
                                criterionMap.remove(Criterion.Type.VLAN_VID);
                            } else {
                                return null;
                            }
                        }
                        case VLAN_PCP: {
                            if (!criterionMap.containsKey(Criterion.Type.VLAN_PCP)) break block0;
                            if (((VlanPcpCriterion)criterionMap.get(Criterion.Type.VLAN_PCP)).priority() == ((L2ModificationInstruction.ModVlanPcpInstruction)l2).vlanPcp()) {
                                criterionMap.remove(Criterion.Type.VLAN_PCP);
                            } else {
                                return null;
                            }
                        }
                        case MPLS_LABEL: {
                            if (!criterionMap.containsKey(Criterion.Type.MPLS_LABEL)) break block0;
                            if (((MplsCriterion)criterionMap.get(Criterion.Type.MPLS_LABEL)).label().equals((Object)((L2ModificationInstruction.ModMplsLabelInstruction)l2).label())) {
                                criterionMap.remove(Criterion.Type.ETH_DST);
                                break block0;
                            }
                            return null;
                        }
                    }
                    break;
                }
                case TABLE: {
                    break;
                }
                case L3MODIFICATION: {
                    L3ModificationInstruction l3 = (L3ModificationInstruction)instruction;
                    switch (l3.subtype()) {
                        case IPV4_SRC: {
                            if (!criterionMap.containsKey(Criterion.Type.IPV4_SRC)) break block0;
                            if (((IPCriterion)criterionMap.get(Criterion.Type.IPV4_SRC)).ip().contains(((L3ModificationInstruction.ModIPInstruction)l3).ip())) {
                                criterionMap.remove(Criterion.Type.IPV4_SRC);
                            } else {
                                return null;
                            }
                        }
                        case IPV4_DST: {
                            if (!criterionMap.containsKey(Criterion.Type.IPV4_DST)) break block0;
                            if (((IPCriterion)criterionMap.get(Criterion.Type.IPV4_DST)).ip().contains(((L3ModificationInstruction.ModIPInstruction)l3).ip())) {
                                criterionMap.remove(Criterion.Type.IPV4_DST);
                            } else {
                                return null;
                            }
                        }
                        case IPV6_SRC: {
                            if (!criterionMap.containsKey(Criterion.Type.IPV6_SRC)) break block0;
                            if (((IPCriterion)criterionMap.get(Criterion.Type.IPV6_SRC)).ip().contains(((L3ModificationInstruction.ModIPInstruction)l3).ip())) {
                                criterionMap.remove(Criterion.Type.IPV6_SRC);
                            } else {
                                return null;
                            }
                        }
                        case IPV6_DST: {
                            if (!criterionMap.containsKey(Criterion.Type.IPV6_DST)) break block0;
                            if (((IPCriterion)criterionMap.get(Criterion.Type.IPV6_DST)).ip().contains(((L3ModificationInstruction.ModIPInstruction)l3).ip())) {
                                criterionMap.remove(Criterion.Type.IPV6_DST);
                            } else {
                                return null;
                            }
                        }
                        case IPV6_FLABEL: {
                            if (!criterionMap.containsKey(Criterion.Type.IPV6_FLABEL)) break block0;
                            if (((IPv6FlowLabelCriterion)criterionMap.get(Criterion.Type.IPV6_FLABEL)).flowLabel() == ((L3ModificationInstruction.ModIPv6FlowLabelInstruction)l3).flowLabel()) {
                                criterionMap.remove(Criterion.Type.IPV4_SRC);
                                break block0;
                            }
                            return null;
                        }
                    }
                    break;
                }
                case METADATA: {
                    break;
                }
            }
        }
        for (Criterion criterion : criterionMap.values()) {
            selectorBuilder.add(criterion);
        }
        return selectorBuilder.build();
    }

    public static Set<Criterion.Type> getTypeSet(TrafficSelector trafficSelector) {
        HashSet<Criterion.Type> typeSet = new HashSet<Criterion.Type>();
        for (Criterion criterion : trafficSelector.criteria()) {
            typeSet.add(criterion.type());
        }
        return typeSet;
    }

    public static Criterion intersectCriterion(Criterion c1, Criterion c2) {
        switch (c1.type()) {
            case IPV4_SRC: {
                IpPrefix ipPrefix = FlowObjectiveCompositionUtil.intersectIpPrefix(((IPCriterion)c1).ip(), ((IPCriterion)c2).ip());
                if (ipPrefix == null) {
                    return null;
                }
                return Criteria.matchIPSrc((IpPrefix)ipPrefix);
            }
            case IPV4_DST: {
                IpPrefix ipPrefix = FlowObjectiveCompositionUtil.intersectIpPrefix(((IPCriterion)c1).ip(), ((IPCriterion)c2).ip());
                if (ipPrefix == null) {
                    return null;
                }
                return Criteria.matchIPDst((IpPrefix)ipPrefix);
            }
            case IPV6_SRC: {
                IpPrefix ipPrefix = FlowObjectiveCompositionUtil.intersectIpPrefix(((IPCriterion)c1).ip(), ((IPCriterion)c2).ip());
                if (ipPrefix == null) {
                    return null;
                }
                return Criteria.matchIPv6Src((IpPrefix)ipPrefix);
            }
            case IPV6_DST: {
                IpPrefix ipPrefix = FlowObjectiveCompositionUtil.intersectIpPrefix(((IPCriterion)c1).ip(), ((IPCriterion)c2).ip());
                if (ipPrefix == null) {
                    return null;
                }
                return Criteria.matchIPv6Dst((IpPrefix)ipPrefix);
            }
        }
        if (!c1.equals(c2)) {
            return null;
        }
        return c1;
    }

    public static IpPrefix intersectIpPrefix(IpPrefix ip1, IpPrefix ip2) {
        if (ip1.contains(ip2)) {
            return ip1;
        }
        if (ip2.contains(ip1)) {
            return ip2;
        }
        return null;
    }

    public static FlowObjectiveCompositionTree parsePolicyString(String policy) {
        List<FlowObjectiveCompositionTree> postfix = FlowObjectiveCompositionUtil.transformToPostfixForm(policy);
        return FlowObjectiveCompositionUtil.buildPolicyTree(postfix);
    }

    private static List<FlowObjectiveCompositionTree> transformToPostfixForm(String policy) {
        Stack<Character> stack = new Stack<Character>();
        ArrayList<FlowObjectiveCompositionTree> postfix = new ArrayList<FlowObjectiveCompositionTree>();
        for (int i = 0; i < policy.length(); ++i) {
            Character ch = Character.valueOf(policy.charAt(i));
            if (Character.isDigit(ch.charValue())) {
                int applicationId = ch.charValue() - 48;
                while (i + 1 < policy.length() && Character.isDigit(policy.charAt(i + 1))) {
                    applicationId = applicationId * 10 + policy.charAt(++i) - 48;
                }
                postfix.add(new FlowObjectiveCompositionTree((short)applicationId));
                continue;
            }
            if (ch.charValue() == '(') {
                stack.push(ch);
                continue;
            }
            if (ch.charValue() == ')') {
                while (((Character)stack.peek()).charValue() != '(') {
                    postfix.add(new FlowObjectiveCompositionTree((Character)stack.pop()));
                }
                stack.pop();
                continue;
            }
            while (!stack.isEmpty() && FlowObjectiveCompositionUtil.compareOperatorPriority(((Character)stack.peek()).charValue(), ch.charValue())) {
                postfix.add(new FlowObjectiveCompositionTree((Character)stack.pop()));
            }
            stack.push(ch);
        }
        while (!stack.isEmpty()) {
            postfix.add(new FlowObjectiveCompositionTree((Character)stack.pop()));
        }
        return postfix;
    }

    private static boolean compareOperatorPriority(char peek, char cur) {
        if (peek == '/' && (cur == '+' || cur == '>' || cur == '/')) {
            return true;
        }
        if (peek == '>' && (cur == '+' || cur == '>')) {
            return true;
        }
        return peek == '+' && cur == '+';
    }

    private static FlowObjectiveCompositionTree buildPolicyTree(List<FlowObjectiveCompositionTree> postfix) {
        Stack<FlowObjectiveCompositionTree> stack = new Stack<FlowObjectiveCompositionTree>();
        for (FlowObjectiveCompositionTree node : postfix) {
            if (node.operator == FlowObjectiveCompositionManager.PolicyOperator.Application) {
                stack.push(node);
                continue;
            }
            node.rightChild = (FlowObjectiveCompositionTree)stack.pop();
            node.leftChild = (FlowObjectiveCompositionTree)stack.pop();
            stack.push(node);
        }
        return (FlowObjectiveCompositionTree)stack.pop();
    }

    public static Collection<ForwardingObjective> minusForwardingObjectives(Collection<ForwardingObjective> fo1, Collection<ForwardingObjective> fo2) {
        HashMap<Integer, ForwardingObjective> map = new HashMap<Integer, ForwardingObjective>();
        for (ForwardingObjective fo : fo1) {
            map.put(fo.id(), fo);
        }
        for (ForwardingObjective fo : fo2) {
            map.remove(fo.id());
        }
        return map.values();
    }
}

