/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective.impl.composition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.impl.composition.FilterTable;
import org.onosproject.net.flowobjective.impl.composition.FlowObjectiveCompositionManager;
import org.onosproject.net.flowobjective.impl.composition.FlowObjectiveCompositionUtil;
import org.onosproject.net.flowobjective.impl.composition.ForwardTable;
import org.onosproject.net.flowobjective.impl.composition.ForwardUpdateTable;
import org.onosproject.net.flowobjective.impl.composition.NextTable;

public class FlowObjectiveCompositionTree {
    FlowObjectiveCompositionManager.PolicyOperator operator;
    FlowObjectiveCompositionTree leftChild;
    FlowObjectiveCompositionTree rightChild;
    protected short applicationId;
    protected FilterTable filterTable;
    protected ForwardTable forwardTable;
    protected NextTable nextTable;
    protected int priorityMultiplier;
    protected int priorityAddend;

    public FlowObjectiveCompositionTree(short applicationId) {
        this.operator = FlowObjectiveCompositionManager.PolicyOperator.Application;
        this.leftChild = null;
        this.rightChild = null;
        this.applicationId = applicationId;
        this.filterTable = new FilterTable();
        this.forwardTable = new ForwardTable();
        this.nextTable = new NextTable();
        this.priorityMultiplier = 10;
        this.priorityAddend = 10;
    }

    public FlowObjectiveCompositionTree(Character ch) {
        switch (ch.charValue()) {
            case '+': {
                this.operator = FlowObjectiveCompositionManager.PolicyOperator.Parallel;
                break;
            }
            case '>': {
                this.operator = FlowObjectiveCompositionManager.PolicyOperator.Sequential;
                break;
            }
            case '/': {
                this.operator = FlowObjectiveCompositionManager.PolicyOperator.Override;
                break;
            }
            default: {
                this.operator = FlowObjectiveCompositionManager.PolicyOperator.Application;
            }
        }
        this.leftChild = null;
        this.rightChild = null;
        this.applicationId = (short)-1;
        this.filterTable = new FilterTable();
        this.forwardTable = new ForwardTable();
        this.nextTable = new NextTable();
        this.priorityMultiplier = 10;
        this.priorityAddend = 10;
    }

    protected List<FilteringObjective> updateFilter(FilteringObjective filteringObjective) {
        switch (this.operator) {
            case Parallel: {
                return this.updateFilterParallel(filteringObjective);
            }
            case Sequential: {
                return this.updateFilterSequential(filteringObjective);
            }
            case Override: {
                return this.updateFilterOverride(filteringObjective);
            }
            case Application: {
                if (filteringObjective.appId().id() == this.applicationId) {
                    return this.filterTable.updateFilter(filteringObjective);
                }
                return new ArrayList<FilteringObjective>();
            }
        }
        return new ArrayList<FilteringObjective>();
    }

    protected List<FilteringObjective> updateFilterParallel(FilteringObjective filteringObjective) {
        List<FilteringObjective> leftUpdates = this.leftChild.updateFilter(filteringObjective);
        List<FilteringObjective> rightUpdates = this.rightChild.updateFilter(filteringObjective);
        ArrayList<FilteringObjective> updates = new ArrayList<FilteringObjective>();
        updates.addAll(leftUpdates);
        updates.addAll(rightUpdates);
        return this.filterTable.updateFilter(updates);
    }

    protected List<FilteringObjective> updateFilterSequential(FilteringObjective filteringObjective) {
        List<FilteringObjective> leftUpdates = this.leftChild.updateFilter(filteringObjective);
        List<FilteringObjective> rightUpdates = this.rightChild.updateFilter(filteringObjective);
        return this.filterTable.updateFilter(leftUpdates);
    }

    protected List<FilteringObjective> updateFilterOverride(FilteringObjective filteringObjective) {
        List<FilteringObjective> leftUpdates = this.leftChild.updateFilter(filteringObjective);
        List<FilteringObjective> rightUpdates = this.rightChild.updateFilter(filteringObjective);
        return this.filterTable.updateFilter(leftUpdates);
    }

    public List<ForwardingObjective> updateForward(ForwardingObjective forwardingObjective) {
        return this.updateForwardNode(forwardingObjective).toForwardingObjectiveList();
    }

    public ForwardUpdateTable updateForwardNode(ForwardingObjective forwardingObjective) {
        switch (this.operator) {
            case Parallel: 
            case Sequential: 
            case Override: {
                return this.updateForwardComposition(forwardingObjective);
            }
            case Application: {
                if (forwardingObjective.appId().id() == this.applicationId) {
                    return this.forwardTable.updateForward(forwardingObjective);
                }
                return new ForwardUpdateTable();
            }
        }
        return new ForwardUpdateTable();
    }

    protected ForwardUpdateTable updateForwardComposition(ForwardingObjective forwardingObjective) {
        List<ForwardingObjective> fos;
        ForwardUpdateTable leftUpdates = this.leftChild.updateForwardNode(forwardingObjective);
        ForwardUpdateTable rightUpdates = this.rightChild.updateForwardNode(forwardingObjective);
        ArrayList<ForwardingObjective> addUpdates = new ArrayList<ForwardingObjective>();
        ArrayList<ForwardingObjective> removeUpdates = new ArrayList<ForwardingObjective>();
        if (this.operator == FlowObjectiveCompositionManager.PolicyOperator.Parallel || this.operator == FlowObjectiveCompositionManager.PolicyOperator.Sequential) {
            for (ForwardingObjective forwardingObjective2 : leftUpdates.addObjectives) {
                for (ForwardingObjective fo2 : this.rightChild.forwardTable.getForwardingObjectives()) {
                    ForwardingObjective composedFo = null;
                    composedFo = this.operator == FlowObjectiveCompositionManager.PolicyOperator.Parallel ? FlowObjectiveCompositionUtil.composeParallel(forwardingObjective2, fo2) : FlowObjectiveCompositionUtil.composeSequential(forwardingObjective2, fo2, this.priorityMultiplier);
                    if (composedFo == null) continue;
                    addUpdates.add(composedFo);
                    this.leftChild.forwardTable.addGeneratedParentForwardingObjective(forwardingObjective2, composedFo);
                    this.rightChild.forwardTable.addGeneratedParentForwardingObjective(fo2, composedFo);
                }
            }
            Iterator<ForwardingObjective> leftTableWithoutAdd = FlowObjectiveCompositionUtil.minusForwardingObjectives(this.leftChild.forwardTable.getForwardingObjectives(), leftUpdates.addObjectives);
            Iterator iterator = leftTableWithoutAdd.iterator();
            while (iterator.hasNext()) {
                ForwardingObjective fo13 = (ForwardingObjective)iterator.next();
                for (ForwardingObjective fo2 : rightUpdates.addObjectives) {
                    ForwardingObjective composedFo = null;
                    composedFo = this.operator == FlowObjectiveCompositionManager.PolicyOperator.Parallel ? FlowObjectiveCompositionUtil.composeParallel(fo13, fo2) : FlowObjectiveCompositionUtil.composeSequential(fo13, fo2, this.priorityMultiplier);
                    if (composedFo == null) continue;
                    addUpdates.add(composedFo);
                    this.leftChild.forwardTable.addGeneratedParentForwardingObjective(fo13, composedFo);
                    this.rightChild.forwardTable.addGeneratedParentForwardingObjective(fo2, composedFo);
                }
            }
        } else {
            ForwardingObjective composedFo;
            for (ForwardingObjective forwardingObjective3 : leftUpdates.addObjectives) {
                composedFo = FlowObjectiveCompositionUtil.composeOverride(forwardingObjective3, this.priorityAddend);
                addUpdates.add(composedFo);
                this.leftChild.forwardTable.addGeneratedParentForwardingObjective(forwardingObjective3, composedFo);
            }
            for (ForwardingObjective forwardingObjective4 : rightUpdates.addObjectives) {
                composedFo = FlowObjectiveCompositionUtil.composeOverride(forwardingObjective4, 0);
                addUpdates.add(composedFo);
                this.rightChild.forwardTable.addGeneratedParentForwardingObjective(forwardingObjective4, composedFo);
            }
        }
        for (ForwardingObjective forwardingObjective5 : leftUpdates.removeObjectives) {
            fos = this.leftChild.forwardTable.getGeneratedParentForwardingObjectiveForRemove(forwardingObjective5);
            removeUpdates.addAll(fos);
        }
        this.leftChild.forwardTable.deleteGeneratedParentForwardingObjective(leftUpdates.removeObjectives);
        for (ForwardingObjective forwardingObjective6 : rightUpdates.removeObjectives) {
            fos = this.rightChild.forwardTable.getGeneratedParentForwardingObjectiveForRemove(forwardingObjective6);
            removeUpdates.addAll(fos);
        }
        this.rightChild.forwardTable.deleteGeneratedParentForwardingObjective(rightUpdates.removeObjectives);
        ForwardUpdateTable updates = new ForwardUpdateTable();
        updates.addUpdateTable(this.forwardTable.updateForward(addUpdates));
        updates.addUpdateTable(this.forwardTable.updateForward(removeUpdates));
        return updates;
    }

    public List<NextObjective> updateNext(NextObjective nextObjective) {
        switch (this.operator) {
            case Parallel: 
            case Sequential: 
            case Override: {
                return this.updateNextComposition(nextObjective);
            }
            case Application: {
                if (nextObjective.appId().id() == this.applicationId) {
                    return this.nextTable.updateNext(nextObjective);
                }
                return new ArrayList<NextObjective>();
            }
        }
        return new ArrayList<NextObjective>();
    }

    protected List<NextObjective> updateNextComposition(NextObjective nextObjective) {
        List<NextObjective> leftUpdates = this.leftChild.updateNext(nextObjective);
        List<NextObjective> rightUpdates = this.rightChild.updateNext(nextObjective);
        ArrayList<NextObjective> updates = new ArrayList<NextObjective>();
        updates.addAll(leftUpdates);
        updates.addAll(rightUpdates);
        return this.nextTable.updateNext(updates);
    }

    public String toString() {
        String str = null;
        switch (this.operator) {
            case Parallel: {
                str = "(" + this.leftChild + "+" + this.rightChild + ")";
                break;
            }
            case Sequential: {
                str = "(" + this.leftChild + ">" + this.rightChild + ")";
                break;
            }
            case Override: {
                str = "(" + this.leftChild + "/" + this.rightChild + ")";
                break;
            }
            default: {
                str = " " + this.applicationId + " ";
            }
        }
        return str;
    }
}

